/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext.filter;

import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.filter.VariantContextFilter;

public class HeterozygosityFilter
implements VariantContextFilter {
    private final String sample;
    private final boolean keepHets;

    public HeterozygosityFilter(boolean keepHets, String sample) {
        this.keepHets = keepHets;
        this.sample = sample;
    }

    public HeterozygosityFilter(boolean keepHets) {
        this(keepHets, null);
    }

    @Override
    public boolean test(VariantContext variantContext) {
        Genotype gt;
        Genotype genotype = gt = this.sample == null ? variantContext.getGenotype(0) : variantContext.getGenotype(this.sample);
        if (gt == null) {
            throw new IllegalArgumentException(this.sample == null ? "Cannot find any genotypes in VariantContext: " + String.valueOf(variantContext) : "Cannot find sample requested: " + this.sample);
        }
        return gt.isHet() ^ !this.keepHets;
    }
}

