/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.bcf2;

import htsjdk.tribble.TribbleException;
import htsjdk.variant.bcf2.BCF2Type;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFIDHeaderLine;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class BCF2Utils {
    public static final int MAX_ALLELES_IN_GENOTYPES = 127;
    public static final int OVERFLOW_ELEMENT_MARKER = 15;
    public static final int MAX_INLINE_ELEMENTS = 14;
    public static final BCF2Type[] INTEGER_TYPES_BY_SIZE = new BCF2Type[]{BCF2Type.INT8, BCF2Type.INT16, BCF2Type.INT32};
    public static final BCF2Type[] ID_TO_ENUM;

    private BCF2Utils() {
    }

    public static ArrayList<String> makeDictionary(VCFHeader header) {
        HashSet<String> seen = new HashSet<String>();
        ArrayList<String> dict = new ArrayList<String>();
        seen.add("PASS");
        dict.add("PASS");
        for (VCFHeaderLine line : header.getMetaDataInInputOrder()) {
            VCFIDHeaderLine idLine;
            if (!line.shouldBeAddedToDictionary() || seen.contains((idLine = (VCFIDHeaderLine)((Object)line)).getID())) continue;
            dict.add(idLine.getID());
            seen.add(idLine.getID());
        }
        return dict;
    }

    public static byte encodeTypeDescriptor(int nElements, BCF2Type type) {
        return (byte)((0xF & nElements) << 4 | type.getID() & 0xF);
    }

    public static int decodeSize(byte typeDescriptor) {
        return (0xF0 & typeDescriptor) >> 4;
    }

    public static int decodeTypeID(byte typeDescriptor) {
        return typeDescriptor & 0xF;
    }

    public static BCF2Type decodeType(byte typeDescriptor) {
        return ID_TO_ENUM[BCF2Utils.decodeTypeID(typeDescriptor)];
    }

    public static boolean sizeIsOverflow(byte typeDescriptor) {
        return BCF2Utils.decodeSize(typeDescriptor) == 15;
    }

    public static byte readByte(InputStream stream) throws IOException {
        return (byte)(stream.read() & 0xFF);
    }

    public static String collapseStringList(List<String> strings) {
        if (strings.isEmpty()) {
            return "";
        }
        if (strings.size() == 1) {
            return strings.get(0);
        }
        StringBuilder b = new StringBuilder();
        for (String s : strings) {
            if (s == null) continue;
            assert (s.indexOf(",") == -1);
            b.append(',').append(s);
        }
        return b.toString();
    }

    public static List<String> explodeStringList(String collapsed) {
        assert (BCF2Utils.isCollapsedString(collapsed));
        String[] exploded = collapsed.substring(1).split(",");
        return Arrays.asList(exploded);
    }

    public static boolean isCollapsedString(String s) {
        return !s.isEmpty() && s.charAt(0) == ',';
    }

    public static final File shadowBCF(File vcfFile) {
        String path = vcfFile.getAbsolutePath();
        if (path.contains(".vcf")) {
            return new File(path.replace(".vcf", ".bcf"));
        }
        File bcf = new File(path + ".bcf");
        if (bcf.canRead()) {
            return bcf;
        }
        try {
            FileOutputStream o = new FileOutputStream(bcf);
            o.close();
            bcf.delete();
            return bcf;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static BCF2Type determineIntegerType(int value) {
        for (BCF2Type potentialType : INTEGER_TYPES_BY_SIZE) {
            if (!potentialType.withinRange(value)) continue;
            return potentialType;
        }
        throw new TribbleException("Integer cannot be encoded in allowable range of even INT32: " + value);
    }

    public static BCF2Type determineIntegerType(int[] values) {
        BCF2Type minType;
        int max = 0;
        int min = 0;
        for (int v : values) {
            if (v > max) {
                max = v;
            }
            if (v >= min) continue;
            min = v;
        }
        BCF2Type maxType = BCF2Utils.determineIntegerType(max);
        return maxType.compareTo(minType = BCF2Utils.determineIntegerType(min)) >= 0 ? maxType : minType;
    }

    public static BCF2Type maxIntegerType(BCF2Type t1, BCF2Type t2) {
        switch (t1) {
            case INT8: {
                return t2;
            }
            case INT16: {
                return t2 == BCF2Type.INT32 ? t2 : t1;
            }
            case INT32: {
                return t1;
            }
        }
        throw new TribbleException("BUG: unexpected BCF2Type " + String.valueOf((Object)t1));
    }

    public static BCF2Type determineIntegerType(List<Integer> values) {
        BCF2Type maxType = BCF2Type.INT8;
        block5: for (int value : values) {
            BCF2Type type1 = BCF2Utils.determineIntegerType(value);
            switch (type1) {
                case INT8: {
                    continue block5;
                }
                case INT16: {
                    maxType = BCF2Type.INT16;
                    continue block5;
                }
                case INT32: {
                    return BCF2Type.INT32;
                }
            }
            throw new TribbleException("Unexpected integer type " + String.valueOf((Object)type1));
        }
        return maxType;
    }

    public static <T> List<T> toList(Class<T> c, Object o) {
        if (o == null) {
            return Collections.emptyList();
        }
        if (o instanceof List) {
            return (List)o;
        }
        if (o.getClass().isArray()) {
            int arraySize = Array.getLength(o);
            ArrayList<Object> list = new ArrayList<Object>(arraySize);
            for (int i = 0; i < arraySize; ++i) {
                list.add(Array.get(o, i));
            }
            return list;
        }
        return Collections.singletonList(o);
    }

    public static boolean headerLinesAreOrderedConsistently(VCFHeader outputHeader, VCFHeader genotypesBlockHeader) {
        if (!BCF2Utils.nullAsEmpty(outputHeader.getSampleNamesInOrder()).equals(BCF2Utils.nullAsEmpty(genotypesBlockHeader.getSampleNamesInOrder()))) {
            return false;
        }
        Iterator<VCFIDHeaderLine> outputLinesIt = outputHeader.getIDHeaderLines().iterator();
        Iterator<VCFIDHeaderLine> inputLinesIt = genotypesBlockHeader.getIDHeaderLines().iterator();
        while (inputLinesIt.hasNext()) {
            if (!outputLinesIt.hasNext()) {
                return false;
            }
            VCFIDHeaderLine outputLine = outputLinesIt.next();
            VCFIDHeaderLine inputLine = inputLinesIt.next();
            if (inputLine.getClass().equals(outputLine.getClass()) && inputLine.getID().equals(outputLine.getID())) continue;
            return false;
        }
        return true;
    }

    private static <T> List<T> nullAsEmpty(List<T> l) {
        if (l == null) {
            return Collections.emptyList();
        }
        return l;
    }

    static {
        int maxID = -1;
        for (BCF2Type v : BCF2Type.values()) {
            maxID = Math.max(v.getID(), maxID);
        }
        ID_TO_ENUM = new BCF2Type[maxID + 1];
        BCF2Type[] bCF2TypeArray = BCF2Type.values();
        int n = bCF2TypeArray.length;
        for (int i = 0; i < n; ++i) {
            BCF2Type v;
            BCF2Utils.ID_TO_ENUM[v.getID()] = v = bCF2TypeArray[i];
        }
    }
}

