/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.index.tabix;

import htsjdk.samtools.BinningIndexBuilder;
import htsjdk.samtools.BinningIndexContent;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.tribble.Feature;
import htsjdk.tribble.index.Index;
import htsjdk.tribble.index.IndexCreator;
import htsjdk.tribble.index.tabix.TabixFormat;
import htsjdk.tribble.index.tabix.TabixIndex;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TabixIndexCreator
implements IndexCreator {
    private final TabixFormat formatSpec;
    private final List<BinningIndexContent> indexContents = new ArrayList<BinningIndexContent>();
    private final List<String> sequenceNames = new ArrayList<String>();
    private final Set<String> sequenceNamesSeen = new HashSet<String>();
    private final SAMSequenceDictionary sequenceDictionary;
    private String currentSequenceName = null;
    private BinningIndexBuilder indexBuilder = null;
    private TabixFeature previousFeature = null;

    public TabixIndexCreator(SAMSequenceDictionary sequenceDictionary, TabixFormat formatSpec) {
        this.sequenceDictionary = sequenceDictionary;
        this.formatSpec = formatSpec.clone();
    }

    public TabixIndexCreator(TabixFormat formatSpec) {
        this(null, formatSpec);
    }

    @Override
    public void addFeature(Feature feature, long filePosition) {
        int referenceIndex;
        String sequenceName = feature.getContig();
        if (sequenceName.equals(this.currentSequenceName)) {
            referenceIndex = this.sequenceNames.size() - 1;
        } else {
            referenceIndex = this.sequenceNames.size();
            if (this.currentSequenceName != null && this.sequenceNamesSeen.contains(sequenceName)) {
                throw new IllegalArgumentException("Sequence " + String.valueOf(feature) + " added out sequence of order");
            }
        }
        TabixFeature thisFeature = new TabixFeature(referenceIndex, feature.getStart(), feature.getEnd(), filePosition);
        if (this.previousFeature != null) {
            if (this.previousFeature.compareTo(thisFeature) > 0) {
                throw new IllegalArgumentException(String.format("Features added out of order: previous (%s) > next (%s)", this.previousFeature, thisFeature));
            }
            this.finalizeFeature(filePosition);
        }
        this.previousFeature = thisFeature;
        if (referenceIndex == this.sequenceNames.size()) {
            this.advanceToReference(sequenceName);
        }
    }

    private void finalizeFeature(long featureEndPosition) {
        this.previousFeature.featureEndFilePosition = featureEndPosition;
        if (this.previousFeature.featureStartFilePosition >= this.previousFeature.featureEndFilePosition) {
            throw new IllegalArgumentException(String.format("Feature start position %d >= feature end position %d", this.previousFeature.featureStartFilePosition, this.previousFeature.featureEndFilePosition));
        }
        this.indexBuilder.processFeature(this.previousFeature);
    }

    private void advanceToReference(String sequenceName) {
        if (this.indexBuilder != null) {
            this.indexContents.add(this.indexBuilder.generateIndexContent());
        }
        int sequenceLength = this.sequenceDictionary != null ? this.sequenceDictionary.getSequence(sequenceName).getSequenceLength() : 0;
        this.indexBuilder = new BinningIndexBuilder(this.sequenceNames.size(), sequenceLength);
        this.sequenceNames.add(sequenceName);
        this.currentSequenceName = sequenceName;
        this.sequenceNamesSeen.add(sequenceName);
    }

    @Override
    public Index finalizeIndex(long finalFilePosition) {
        if (this.previousFeature != null) {
            this.finalizeFeature(finalFilePosition);
        }
        if (this.indexBuilder != null) {
            this.indexContents.add(this.indexBuilder.generateIndexContent());
        }
        BinningIndexContent[] indices = this.indexContents.toArray(new BinningIndexContent[this.sequenceNames.size()]);
        return new TabixIndex(this.formatSpec, this.sequenceNames, indices);
    }

    private static class TabixFeature
    implements BinningIndexBuilder.FeatureToBeIndexed,
    Comparable<TabixFeature> {
        private final int referenceIndex;
        private final int start;
        private final int end;
        private final long featureStartFilePosition;
        private long featureEndFilePosition = -1L;

        private TabixFeature(int referenceIndex, int start, int end, long featureStartFilePosition) {
            this.referenceIndex = referenceIndex;
            this.start = start;
            this.end = end;
            this.featureStartFilePosition = featureStartFilePosition;
        }

        @Override
        public int getStart() {
            return this.start;
        }

        @Override
        public int getEnd() {
            return this.end;
        }

        @Override
        public Integer getIndexingBin() {
            return null;
        }

        @Override
        public Chunk getChunk() {
            if (this.featureEndFilePosition == -1L) {
                throw new IllegalStateException("End position is not set");
            }
            return new Chunk(this.featureStartFilePosition, this.featureEndFilePosition);
        }

        @Override
        public int compareTo(TabixFeature other) {
            int ret = this.referenceIndex - other.referenceIndex;
            if (ret != 0) {
                return ret;
            }
            return this.start - other.start;
        }

        public String toString() {
            return "TabixFeature{referenceIndex=" + this.referenceIndex + ", start=" + this.start + ", end=" + this.end + ", featureStartFilePosition=" + this.featureStartFilePosition + ", featureEndFilePosition=" + this.featureEndFilePosition + "}";
        }
    }
}

