/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.SnappyLoaderInternal;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SnappyLoader {
    private static final Log logger = Log.getInstance(SnappyLoader.class);
    private final boolean snappyAvailable;

    public SnappyLoader() {
        this(Defaults.DISABLE_SNAPPY_COMPRESSOR);
    }

    SnappyLoader(boolean disableSnappy) {
        if (disableSnappy) {
            logger.debug("Snappy is disabled via system property.");
            this.snappyAvailable = false;
        } else {
            boolean tmpAvailable;
            try {
                tmpAvailable = SnappyLoaderInternal.tryToLoadSnappy();
            }
            catch (NoClassDefFoundError e) {
                tmpAvailable = false;
                logger.error(e, "Snappy java library was requested but not found. If Snappy is intentionally missing, this message may be suppressed by setting -Dsamjdk.snappy.disable=true ");
            }
            this.snappyAvailable = tmpAvailable;
        }
    }

    public boolean isSnappyAvailable() {
        return this.snappyAvailable;
    }

    public InputStream wrapInputStream(InputStream inputStream) {
        return this.wrapWithSnappyOrThrow(inputStream, SnappyLoaderInternal.getInputStreamWrapper());
    }

    public OutputStream wrapOutputStream(OutputStream outputStream) {
        return this.wrapWithSnappyOrThrow(outputStream, SnappyLoaderInternal.getOutputStreamWrapper());
    }

    private <T, R> R wrapWithSnappyOrThrow(T stream, IOFunction<T, R> wrapper) {
        if (this.isSnappyAvailable()) {
            try {
                return wrapper.apply(stream);
            }
            catch (Exception e) {
                throw new SAMException("Error wrapping stream with snappy", e);
            }
        }
        String errorMessage = Defaults.DISABLE_SNAPPY_COMPRESSOR ? "Cannot wrap stream with snappy compressor because snappy was disabled via the snappy.disable system property." : "Cannot wrap stream with snappy compressor because we could not load the snappy library.";
        throw new SAMException(errorMessage);
    }

    static interface IOFunction<T, R> {
        public R apply(T var1) throws IOException;
    }
}

