/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.ResourceLimitedMap;
import htsjdk.samtools.util.ResourceLimitedMapFunctor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FileAppendStreamLRUCache
extends ResourceLimitedMap<File, OutputStream> {
    public FileAppendStreamLRUCache(int cacheSize) {
        super(cacheSize, new Functor());
    }

    private static class Functor
    implements ResourceLimitedMapFunctor<File, OutputStream> {
        private Functor() {
        }

        @Override
        public OutputStream makeValue(File file) {
            try {
                return IOUtil.maybeBufferOutputStream(new FileOutputStream(file, true));
            }
            catch (FileNotFoundException e) {
                System.gc();
                System.runFinalization();
                try {
                    return IOUtil.maybeBufferOutputStream(new FileOutputStream(file, true));
                }
                catch (FileNotFoundException e2) {
                    throw new SAMException(String.valueOf(file) + "not found", e2);
                }
            }
        }

        @Override
        public void finalizeValue(File file, OutputStream out) {
            try {
                out.flush();
                out.close();
            }
            catch (IOException e) {
                throw new SAMException("Exception closing FileOutputStream for " + String.valueOf(file), e);
            }
        }
    }
}

