/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.AbstractRecordAndOffset;

public abstract class EdgingRecordAndOffset
extends AbstractRecordAndOffset {
    private EdgingRecordAndOffset(SAMRecord record, int offset) {
        super(record, offset);
    }

    public abstract EdgingRecordAndOffset getStart();

    public abstract Type getType();

    public abstract byte getBaseQuality(int var1);

    public abstract int getRefPos();

    public static EdgingRecordAndOffset createBeginRecord(SAMRecord record, int offset, int length, int refPos) {
        return new StartEdgingRecordAndOffset(record, offset, length, refPos);
    }

    public static EdgingRecordAndOffset createEndRecord(EdgingRecordAndOffset startRecord) {
        return new EndEdgingRecordAndOffset(startRecord);
    }

    private static class StartEdgingRecordAndOffset
    extends EdgingRecordAndOffset {
        private final int length;
        private final int refPos;
        private int hash = 0;

        protected StartEdgingRecordAndOffset(SAMRecord record, int offset, int length, int refPos) {
            super(record, offset);
            if (length > record.getReadLength()) {
                throw new IllegalArgumentException("Block length cannot be larger than whole read length");
            }
            this.length = length;
            this.refPos = refPos;
        }

        @Override
        public byte getBaseQuality(int position) {
            int rOffset = this.getRelativeOffset(position);
            byte[] baseQualities = this.record.getBaseQualities();
            this.validateOffset(rOffset, baseQualities);
            return baseQualities[rOffset];
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public int getRefPos() {
            return this.refPos;
        }

        @Override
        public Type getType() {
            return Type.BEGIN;
        }

        @Override
        public EdgingRecordAndOffset getStart() {
            return null;
        }

        public int hashCode() {
            if (this.hash != 0) {
                return this.hash;
            }
            this.hash = this.record.hashCode();
            this.hash = 31 * this.hash + this.length;
            this.hash = 31 * this.hash + this.offset;
            this.hash = 31 * this.hash + this.refPos;
            return this.hash;
        }

        private int getRelativeOffset(int position) {
            return position - this.refPos + this.offset;
        }
    }

    private static class EndEdgingRecordAndOffset
    extends EdgingRecordAndOffset {
        private final EdgingRecordAndOffset start;

        EndEdgingRecordAndOffset(EdgingRecordAndOffset record) {
            super(record.getRecord(), record.getOffset());
            this.start = record;
        }

        @Override
        public byte getBaseQuality(int position) {
            return this.start.getBaseQuality(position);
        }

        @Override
        public int getLength() {
            return this.start.getLength();
        }

        @Override
        public int getRefPos() {
            return this.start.getRefPos();
        }

        @Override
        public Type getType() {
            return Type.END;
        }

        @Override
        public EdgingRecordAndOffset getStart() {
            return this.start;
        }

        public int hashCode() {
            return this.start.hashCode();
        }
    }

    public static enum Type {
        BEGIN,
        END;

    }
}

