/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.seekablestream;

import htsjdk.io.HtsPath;
import htsjdk.io.IOPath;
import htsjdk.samtools.seekablestream.ISeekableStreamFactory;
import htsjdk.samtools.seekablestream.SeekableBufferedStream;
import htsjdk.samtools.seekablestream.SeekableFTPStream;
import htsjdk.samtools.seekablestream.SeekableFileStream;
import htsjdk.samtools.seekablestream.SeekableHTTPStream;
import htsjdk.samtools.seekablestream.SeekablePathStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.tribble.TribbleException;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.SeekableByteChannel;
import java.util.Set;
import java.util.function.Function;

public class SeekableStreamFactory {
    private static final ISeekableStreamFactory DEFAULT_FACTORY;
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String FTP = "ftp";
    private static final Set<String> URL_SCHEMES_WITH_LEGACY_SUPPORT;
    public static final String FILE_SCHEME = "file";
    private static ISeekableStreamFactory currentFactory;

    private SeekableStreamFactory() {
    }

    public static void setInstance(ISeekableStreamFactory factory) {
        currentFactory = factory;
    }

    public static ISeekableStreamFactory getInstance() {
        return currentFactory;
    }

    @Deprecated
    public static boolean isFilePath(String path) {
        return !SeekableStreamFactory.canBeHandledByLegacyUrlSupport(path);
    }

    public static boolean isBeingHandledByLegacyUrlSupport(String path) {
        return !new HtsPath(path).hasFileSystemProvider() && SeekableStreamFactory.canBeHandledByLegacyUrlSupport(path);
    }

    public static boolean canBeHandledByLegacyUrlSupport(String path) {
        return URL_SCHEMES_WITH_LEGACY_SUPPORT.stream().anyMatch(scheme -> path.startsWith(scheme + "://"));
    }

    static {
        URL_SCHEMES_WITH_LEGACY_SUPPORT = Set.of(HTTP, FTP, HTTPS);
        currentFactory = DEFAULT_FACTORY = new DefaultSeekableStreamFactory();
    }

    private static class DefaultSeekableStreamFactory
    implements ISeekableStreamFactory {
        private DefaultSeekableStreamFactory() {
        }

        @Override
        public SeekableStream getStreamFor(URL url) throws IOException {
            return this.getStreamFor(url.toExternalForm());
        }

        @Override
        public SeekableStream getStreamFor(String path) throws IOException {
            return this.getStreamFor(path, null);
        }

        @Override
        public SeekableStream getStreamFor(String path, Function<SeekableByteChannel, SeekableByteChannel> wrapper) throws IOException {
            return DefaultSeekableStreamFactory.getStreamFor(new HtsPath(path), wrapper);
        }

        public static SeekableStream getStreamFor(IOPath path, Function<SeekableByteChannel, SeekableByteChannel> wrapper) throws IOException {
            if (path.hasFileSystemProvider()) {
                return path.getScheme().equals(SeekableStreamFactory.FILE_SCHEME) ? new SeekableFileStream(path.toPath().toFile()) : new SeekablePathStream(path.toPath(), wrapper);
            }
            return switch (path.getScheme()) {
                case SeekableStreamFactory.HTTP, SeekableStreamFactory.HTTPS -> new SeekableHTTPStream(new URL(path.getRawInputString()));
                case SeekableStreamFactory.FTP -> new SeekableFTPStream(new URL(path.getRawInputString()));
                default -> throw new TribbleException("Unknown path type. No FileSystemProvider available for " + path.getRawInputString());
            };
        }

        @Override
        public SeekableStream getBufferedStream(SeekableStream stream) {
            return this.getBufferedStream(stream, 512000);
        }

        @Override
        public SeekableStream getBufferedStream(SeekableStream stream, int bufferSize) {
            if (bufferSize == 0) {
                return stream;
            }
            return new SeekableBufferedStream(stream, bufferSize);
        }
    }
}

