/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.reference;

import htsjdk.beta.io.bundle.Bundle;
import htsjdk.beta.io.bundle.BundleJSON;
import htsjdk.beta.io.bundle.BundleResource;
import htsjdk.beta.plugin.IOUtils;
import htsjdk.io.HtsPath;
import htsjdk.io.IOPath;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.reference.BlockCompressedIndexedFastaSequenceFile;
import htsjdk.samtools.reference.FastaSequenceFile;
import htsjdk.samtools.reference.FastaSequenceIndex;
import htsjdk.samtools.reference.IndexedFastaSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BufferedLineReader;
import htsjdk.samtools.util.FileExtensions;
import htsjdk.samtools.util.GZIIndex;
import htsjdk.samtools.util.IOUtil;
import htsjdk.utils.ValidationUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class ReferenceSequenceFileFactory {
    @Deprecated
    public static final Set<String> FASTA_EXTENSIONS = FileExtensions.FASTA;
    @Deprecated
    public static final String FASTA_INDEX_EXTENSION = ".fai";

    public static ReferenceSequenceFile getReferenceSequenceFile(File file) {
        return ReferenceSequenceFileFactory.getReferenceSequenceFile(file, true);
    }

    public static ReferenceSequenceFile getReferenceSequenceFile(File file, boolean truncateNamesAtWhitespace) {
        return ReferenceSequenceFileFactory.getReferenceSequenceFile(file, truncateNamesAtWhitespace, true);
    }

    public static ReferenceSequenceFile getReferenceSequenceFile(File file, boolean truncateNamesAtWhitespace, boolean preferIndexed) {
        return ReferenceSequenceFileFactory.getReferenceSequenceFile(IOUtil.toPath(file), HtsPath::new, truncateNamesAtWhitespace, preferIndexed);
    }

    public static ReferenceSequenceFile getReferenceSequenceFile(Path path) {
        return ReferenceSequenceFileFactory.getReferenceSequenceFile(path, true);
    }

    public static ReferenceSequenceFile getReferenceSequenceFile(Path path, boolean truncateNamesAtWhitespace) {
        return ReferenceSequenceFileFactory.getReferenceSequenceFile(path, HtsPath::new, truncateNamesAtWhitespace, true);
    }

    public static ReferenceSequenceFile getReferenceSequenceFile(Path path, boolean truncateNamesAtWhitespace, boolean preferIndexed) {
        ReferenceSequenceFileFactory.getFastaExtension(path);
        if (truncateNamesAtWhitespace && preferIndexed && ReferenceSequenceFileFactory.canCreateIndexedFastaReader(path)) {
            try {
                return IOUtil.isBlockCompressed(path, true) ? new BlockCompressedIndexedFastaSequenceFile(path) : new IndexedFastaSequenceFile(path);
            }
            catch (IOException e) {
                throw new SAMException("Error opening FASTA: " + String.valueOf(path), e);
            }
        }
        return new FastaSequenceFile(path, truncateNamesAtWhitespace);
    }

    public static <T extends IOPath> ReferenceSequenceFile getReferenceSequenceFile(Path path, Function<String, T> ioPathConstructor, boolean truncateNamesAtWhitespace, boolean preferIndexed) {
        IOPath refIOPath = (IOPath)ioPathConstructor.apply(path.toUri().toString());
        if (refIOPath.hasExtension(".json")) {
            Bundle referenceBundle = BundleJSON.toBundle(IOUtils.getStringFromPath(refIOPath), ioPathConstructor);
            return ReferenceSequenceFileFactory.getReferenceSequenceFileFromBundle(referenceBundle, truncateNamesAtWhitespace, preferIndexed);
        }
        return ReferenceSequenceFileFactory.getReferenceSequenceFile(path, truncateNamesAtWhitespace, preferIndexed);
    }

    public static ReferenceSequenceFile getReferenceSequenceFileFromBundle(Bundle referenceBundle, boolean truncateNamesAtWhitespace, boolean preferIndexed) {
        ValidationUtils.nonNull(referenceBundle, "reference bundle");
        BundleResource fastaResource = referenceBundle.getOrThrow("HAPLOID_REFERENCE");
        IOPath fastaPath = fastaResource.getIOPath().orElseThrow(() -> new RuntimeException("The fasta bundle resource must contain a fasta resource that is backed by an IOPath."));
        if (!Files.exists(fastaPath.toPath(), new LinkOption[0])) {
            throw new RuntimeException(String.format("FASTA file %s does not exist", fastaPath));
        }
        IOPath dictPath = ReferenceSequenceFileFactory.getSecondaryBundleResource(referenceBundle, "REFERENCE_DICTIONARY", "Sequence dictionary");
        IOPath indexPath = null;
        IOPath gziIndexPath = null;
        if (preferIndexed) {
            if (!truncateNamesAtWhitespace) {
                throw new RuntimeException("preferIndexed option requires truncateNamesAtWhitespace");
            }
            indexPath = ReferenceSequenceFileFactory.getSecondaryBundleResource(referenceBundle, "REFERENCE_INDEX", "FASTA index");
            gziIndexPath = ReferenceSequenceFileFactory.getSecondaryBundleResource(referenceBundle, "REFERENCE_INDEX_GZI", "GZI index");
        }
        try {
            if (IOUtil.isBlockCompressed(fastaPath.toPath(), true) && preferIndexed && indexPath != null && gziIndexPath != null) {
                return new BlockCompressedIndexedFastaSequenceFile(fastaPath, dictPath, new FastaSequenceIndex(indexPath.toPath()), GZIIndex.loadIndex(gziIndexPath.toPath()));
            }
            if (preferIndexed && indexPath != null) {
                return new IndexedFastaSequenceFile(fastaPath, dictPath, new FastaSequenceIndex(indexPath.toPath()));
            }
            return new FastaSequenceFile(fastaPath, dictPath, truncateNamesAtWhitespace);
        }
        catch (IOException e) {
            throw new SAMException("Error opening FASTA: " + String.valueOf(fastaPath), e);
        }
    }

    private static IOPath getSecondaryBundleResource(Bundle bundle, String secondaryContentType, String description) {
        return bundle.get(secondaryContentType).flatMap(BundleResource::getIOPath).flatMap(path -> {
            if (Files.exists(path.toPath(), new LinkOption[0])) {
                return Optional.of(path);
            }
            throw new RuntimeException(String.format("%s file %s does not exist", description, path));
        }).orElse(null);
    }

    public static boolean canCreateIndexedFastaReader(Path fastaFile) {
        ReferenceSequenceFileFactory.getFastaExtension(fastaFile);
        if (Files.exists(fastaFile, new LinkOption[0]) && Files.exists(ReferenceSequenceFileFactory.getFastaIndexFileName(fastaFile), new LinkOption[0])) {
            try {
                return !IOUtil.isBlockCompressed(fastaFile, true) || Files.exists(GZIIndex.resolveIndexNameForBgzipFile(fastaFile), new LinkOption[0]);
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    public static ReferenceSequenceFile getReferenceSequenceFile(String source, SeekableStream in, FastaSequenceIndex index) {
        return ReferenceSequenceFileFactory.getReferenceSequenceFile(source, in, index, null, true);
    }

    public static ReferenceSequenceFile getReferenceSequenceFile(String source, SeekableStream in, FastaSequenceIndex index, SAMSequenceDictionary dictionary, boolean truncateNamesAtWhitespace) {
        if (truncateNamesAtWhitespace && index != null) {
            return new IndexedFastaSequenceFile(source, in, index, dictionary);
        }
        return new FastaSequenceFile(source, in, dictionary, truncateNamesAtWhitespace);
    }

    public static File getDefaultDictionaryForReferenceSequence(File file) {
        return ReferenceSequenceFileFactory.getDefaultDictionaryForReferenceSequence(IOUtil.toPath(file)).toFile();
    }

    public static Path getDefaultDictionaryForReferenceSequence(Path path) {
        String name = path.getFileName().toString();
        int extensionIndex = name.length() - ReferenceSequenceFileFactory.getFastaExtension(path).length();
        return path.resolveSibling(name.substring(0, extensionIndex) + ".dict");
    }

    public static SAMSequenceDictionary loadDictionary(InputStream in) {
        SAMTextHeaderCodec codec = new SAMTextHeaderCodec();
        BufferedLineReader reader = new BufferedLineReader(in);
        SAMFileHeader header = codec.decode(reader, null);
        if (header.getSequenceDictionary().isEmpty()) {
            return null;
        }
        return header.getSequenceDictionary();
    }

    public static String getFastaExtension(Path path) {
        String name = path.getFileName().toString();
        return FileExtensions.FASTA.stream().filter(name::endsWith).findFirst().orElseThrow(() -> new IllegalArgumentException("File is not a supported reference file type: " + String.valueOf(path.toAbsolutePath())));
    }

    public static Path getFastaIndexFileName(Path fastaFile) {
        return fastaFile.resolveSibling(String.valueOf(fastaFile.getFileName()) + FASTA_INDEX_EXTENSION);
    }
}

