/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.filter;

import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.RuntimeScriptException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

public abstract class AbstractJavascriptFilter<HEADER, TYPE> {
    public static final String DEFAULT_HEADER_KEY = "header";
    private CompiledScript script = null;
    protected Bindings bindings;

    protected AbstractJavascriptFilter(File scriptFile, HEADER header) throws IOException {
        this(new FileReader(scriptFile), header);
    }

    protected AbstractJavascriptFilter(String scriptExpression, HEADER header) {
        this(new StringReader(scriptExpression), header);
    }

    protected AbstractJavascriptFilter(Reader scriptReader, HEADER header) {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("js");
        if (engine == null) {
            CloserUtil.close(scriptReader);
            throw new RuntimeScriptException("The embedded 'javascript' engine is not available in java. Do you use the SUN/Oracle Java Runtime ?");
        }
        if (scriptReader == null) {
            throw new RuntimeScriptException("missing ScriptReader.");
        }
        try {
            Compilable compilingEngine = AbstractJavascriptFilter.getCompilable(engine);
            this.script = compilingEngine.compile(scriptReader);
        }
        catch (ScriptException err) {
            throw new RuntimeScriptException("Script error in input", err);
        }
        finally {
            CloserUtil.close(scriptReader);
        }
        this.bindings = new SimpleBindings();
        this.bindings.put(DEFAULT_HEADER_KEY, header);
    }

    private static Compilable getCompilable(ScriptEngine engine) {
        if (!(engine instanceof Compilable)) {
            throw new IllegalStateException("The current javascript engine (" + String.valueOf(engine.getClass()) + ") cannot be cast to Compilable. Do you use the SUN/Oracle Java Runtime ?");
        }
        return (Compilable)Compilable.class.cast(engine);
    }

    public String getHeaderKey() {
        return DEFAULT_HEADER_KEY;
    }

    public abstract String getRecordKey();

    protected boolean accept(TYPE record) {
        try {
            this.bindings.put(this.getRecordKey(), record);
            Object result = this.script.eval(this.bindings);
            if (result == null) {
                return false;
            }
            if (result instanceof Boolean) {
                return Boolean.TRUE.equals(result);
            }
            if (result instanceof Number) {
                return ((Number)result).intValue() == 1;
            }
            return false;
        }
        catch (ScriptException err) {
            throw new RuntimeException(err);
        }
    }
}

