/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.rans;

import java.nio.ByteBuffer;

public final class RANSDecodingSymbol {
    int start;
    int freq;

    public void set(int start, int freq) {
        this.start = start;
        this.freq = freq;
    }

    public long advanceSymbolStep(long r, int scaleBits) {
        int mask = (1 << scaleBits) - 1;
        return (long)this.freq * (r >> scaleBits) + (r & (long)mask) - (long)this.start;
    }

    public long advanceSymbol4x8(long rIn, ByteBuffer byteBuffer, int scaleBits) {
        int mask = (1 << scaleBits) - 1;
        long ret = (long)this.freq * (rIn >> scaleBits) + (rIn & (long)mask) - (long)this.start;
        if (ret < 0x800000L) {
            int b;
            while ((ret = ret << 8 | (long)(b = 0xFF & byteBuffer.get())) < 0x800000L) {
            }
        }
        return ret;
    }

    public long advanceSymbolNx16(long rIn, ByteBuffer byteBuffer, int scaleBits) {
        int mask = (1 << scaleBits) - 1;
        long ret = (long)this.freq * (rIn >> scaleBits) + (rIn & (long)mask) - (long)this.start;
        if (ret < 32768L) {
            int i = 0xFF & byteBuffer.get() | (0xFF & byteBuffer.get()) << 8;
            ret = (ret << 16) + (long)i;
        }
        return ret;
    }
}

