/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.range;

import htsjdk.samtools.cram.CRAMException;
import htsjdk.samtools.cram.compression.BZIP2ExternalCompressor;
import htsjdk.samtools.cram.compression.CompressionUtils;
import htsjdk.samtools.cram.compression.range.ByteModel;
import htsjdk.samtools.cram.compression.range.RangeCoder;
import htsjdk.samtools.cram.compression.range.RangeParams;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

public class RangeEncode {
    private static final ByteBuffer EMPTY_BUFFER = CompressionUtils.allocateByteBuffer(0);

    public ByteBuffer compress(ByteBuffer inBuffer, RangeParams rangeParams) {
        ByteBuffer outBuffer;
        block17: {
            ByteBuffer inputBuffer;
            block19: {
                block18: {
                    block16: {
                        if (inBuffer.remaining() == 0) {
                            return EMPTY_BUFFER;
                        }
                        outBuffer = CompressionUtils.allocateOutputBuffer(inBuffer.remaining());
                        outBuffer.order(ByteOrder.BIG_ENDIAN);
                        int formatFlags = rangeParams.getFormatFlags();
                        outBuffer.put((byte)formatFlags);
                        if (!rangeParams.isNosz()) {
                            CompressionUtils.writeUint7(inBuffer.remaining(), outBuffer);
                        }
                        inputBuffer = inBuffer;
                        if (rangeParams.isStripe()) {
                            throw new CRAMException("Range Encoding with Stripe Flag is not implemented.");
                        }
                        int inSize = inputBuffer.remaining();
                        if (rangeParams.isPack()) {
                            int[] frequencyTable = new int[256];
                            for (int i = 0; i < inSize; ++i) {
                                int n = inputBuffer.get(i) & 0xFF;
                                frequencyTable[n] = frequencyTable[n] + 1;
                            }
                            int numSymbols = 0;
                            int[] packMappingTable = new int[256];
                            for (int i = 0; i < 256; ++i) {
                                if (frequencyTable[i] <= 0) continue;
                                packMappingTable[i] = numSymbols++;
                            }
                            if (numSymbols != 0 && numSymbols <= 16) {
                                inputBuffer = CompressionUtils.encodePack(inputBuffer, outBuffer, frequencyTable, packMappingTable, numSymbols);
                            } else {
                                outBuffer.put(0, (byte)(outBuffer.get(0) & 0xFFFFFF7F));
                            }
                        }
                        if (!rangeParams.isCAT()) break block16;
                        outBuffer.put(inputBuffer);
                        outBuffer.limit(outBuffer.position());
                        outBuffer.rewind();
                        break block17;
                    }
                    if (!rangeParams.isExternalCompression()) break block18;
                    byte[] rawBytes = new byte[inputBuffer.remaining()];
                    inputBuffer.get(rawBytes, inBuffer.position(), inputBuffer.remaining());
                    BZIP2ExternalCompressor compressor = new BZIP2ExternalCompressor();
                    byte[] extCompressedBytes = compressor.compress(rawBytes, null);
                    outBuffer.put(extCompressedBytes);
                    outBuffer.limit(outBuffer.position());
                    outBuffer.rewind();
                    break block17;
                }
                if (!rangeParams.isRLE()) break block19;
                switch (rangeParams.getOrder()) {
                    case ZERO: {
                        this.compressRLEOrder0(inputBuffer, outBuffer);
                        break block17;
                    }
                    case ONE: {
                        this.compressRLEOrder1(inputBuffer, outBuffer);
                        break block17;
                    }
                    default: {
                        throw new CRAMException("Unknown range order: " + String.valueOf((Object)rangeParams.getOrder()));
                    }
                }
            }
            switch (rangeParams.getOrder()) {
                case ZERO: {
                    this.compressOrder0(inputBuffer, outBuffer);
                    break;
                }
                case ONE: {
                    this.compressOrder1(inputBuffer, outBuffer);
                    break;
                }
                default: {
                    throw new CRAMException("Unknown range order: " + String.valueOf((Object)rangeParams.getOrder()));
                }
            }
        }
        return outBuffer;
    }

    private void compressOrder0(ByteBuffer inBuffer, ByteBuffer outBuffer) {
        int maxSymbol = 0;
        int inSize = inBuffer.remaining();
        for (int i = 0; i < inSize; ++i) {
            if (maxSymbol >= (inBuffer.get(i) & 0xFF)) continue;
            maxSymbol = inBuffer.get(i) & 0xFF;
        }
        ByteModel byteModel = new ByteModel(++maxSymbol);
        outBuffer.put((byte)maxSymbol);
        RangeCoder rangeCoder = new RangeCoder();
        for (int i = 0; i < inSize; ++i) {
            byteModel.modelEncode(outBuffer, rangeCoder, inBuffer.get(i) & 0xFF);
        }
        rangeCoder.rangeEncodeEnd(outBuffer);
        outBuffer.limit(outBuffer.position());
        outBuffer.rewind();
    }

    private void compressOrder1(ByteBuffer inBuffer, ByteBuffer outBuffer) {
        int maxSymbol = 0;
        int inSize = inBuffer.remaining();
        for (int i = 0; i < inSize; ++i) {
            if (maxSymbol >= (inBuffer.get(i) & 0xFF)) continue;
            maxSymbol = inBuffer.get(i) & 0xFF;
        }
        ++maxSymbol;
        ArrayList<ByteModel> byteModelList = new ArrayList<ByteModel>();
        for (int i = 0; i < maxSymbol; ++i) {
            byteModelList.add(i, new ByteModel(maxSymbol));
        }
        outBuffer.put((byte)maxSymbol);
        RangeCoder rangeCoder = new RangeCoder();
        int last = 0;
        for (int i = 0; i < inSize; ++i) {
            ((ByteModel)byteModelList.get(last)).modelEncode(outBuffer, rangeCoder, inBuffer.get(i) & 0xFF);
            last = inBuffer.get(i) & 0xFF;
        }
        rangeCoder.rangeEncodeEnd(outBuffer);
        outBuffer.limit(outBuffer.position());
        outBuffer.rewind();
    }

    private void compressRLEOrder0(ByteBuffer inBuffer, ByteBuffer outBuffer) {
        int maxSymbols = 0;
        int inSize = inBuffer.remaining();
        for (int i = 0; i < inSize; ++i) {
            if (maxSymbols >= (inBuffer.get(i) & 0xFF)) continue;
            maxSymbols = inBuffer.get(i) & 0xFF;
        }
        ByteModel modelLit = new ByteModel(++maxSymbols);
        ArrayList<ByteModel> byteModelRunsList = new ArrayList<ByteModel>(258);
        for (int i = 0; i <= 257; ++i) {
            byteModelRunsList.add(i, new ByteModel(4));
        }
        outBuffer.put((byte)maxSymbols);
        RangeCoder rangeCoder = new RangeCoder();
        int i = 0;
        while (i < inSize) {
            modelLit.modelEncode(outBuffer, rangeCoder, inBuffer.get(i) & 0xFF);
            int run = 1;
            while (i + run < inSize && (inBuffer.get(i + run) & 0xFF) == (inBuffer.get(i) & 0xFF)) {
                ++run;
            }
            int rctx = inBuffer.get(i) & 0xFF;
            i += --run + 1;
            int part = run >= 3 ? 3 : run;
            ((ByteModel)byteModelRunsList.get(rctx)).modelEncode(outBuffer, rangeCoder, part);
            run -= part;
            rctx = 256;
            while (part == 3) {
                part = run >= 3 ? 3 : run;
                ((ByteModel)byteModelRunsList.get(rctx)).modelEncode(outBuffer, rangeCoder, part);
                rctx = 257;
                run -= part;
            }
        }
        rangeCoder.rangeEncodeEnd(outBuffer);
        outBuffer.limit(outBuffer.position());
        outBuffer.rewind();
    }

    private void compressRLEOrder1(ByteBuffer inBuffer, ByteBuffer outBuffer) {
        int maxSymbols = 0;
        int inSize = inBuffer.remaining();
        for (int i = 0; i < inSize; ++i) {
            if (maxSymbols >= (inBuffer.get(i) & 0xFF)) continue;
            maxSymbols = inBuffer.get(i) & 0xFF;
        }
        ArrayList<ByteModel> modelLitList = new ArrayList<ByteModel>(++maxSymbols);
        for (int i = 0; i < maxSymbols; ++i) {
            modelLitList.add(i, new ByteModel(maxSymbols));
        }
        ArrayList<ByteModel> byteModelRunsList = new ArrayList<ByteModel>(258);
        for (int i = 0; i <= 257; ++i) {
            byteModelRunsList.add(i, new ByteModel(4));
        }
        outBuffer.put((byte)maxSymbols);
        RangeCoder rangeCoder = new RangeCoder();
        int i = 0;
        int last = 0;
        while (i < inSize) {
            ((ByteModel)modelLitList.get(last)).modelEncode(outBuffer, rangeCoder, inBuffer.get(i) & 0xFF);
            int run = 1;
            while (i + run < inSize && inBuffer.get(i + run) == inBuffer.get(i)) {
                ++run;
            }
            int rctx = inBuffer.get(i) & 0xFF;
            last = inBuffer.get(i) & 0xFF;
            i += --run + 1;
            int part = run >= 3 ? 3 : run;
            ((ByteModel)byteModelRunsList.get(rctx)).modelEncode(outBuffer, rangeCoder, part);
            run -= part;
            rctx = 256;
            while (part == 3) {
                part = run >= 3 ? 3 : run;
                ((ByteModel)byteModelRunsList.get(rctx)).modelEncode(outBuffer, rangeCoder, part);
                rctx = 257;
                run -= part;
            }
        }
        rangeCoder.rangeEncodeEnd(outBuffer);
        outBuffer.limit(outBuffer.position());
        outBuffer.rewind();
    }
}

