/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.nametokenisation.tokens;

import htsjdk.samtools.cram.CRAMException;
import java.util.Objects;

public class EncodeToken {
    private byte tokenType;
    private String actualValue;
    private String relativeValue;

    public EncodeToken(byte type, String actualValue, String relativeValue) {
        this.tokenType = type;
        this.actualValue = actualValue;
        this.relativeValue = relativeValue;
    }

    public byte getTokenType() {
        return this.tokenType;
    }

    public String getActualValue() {
        return this.actualValue;
    }

    public String getRelativeValue() {
        return this.relativeValue;
    }

    public int hashCode() {
        return Objects.hash(this.tokenType, this.actualValue == null ? Integer.valueOf(0) : this.actualValue, this.relativeValue == null ? Integer.valueOf(0) : this.relativeValue);
    }

    public static class DupOrDiffToken
    extends EncodeToken {
        public DupOrDiffToken(byte tokenType, String relativeValue) {
            super(tokenType, null, relativeValue);
            if (tokenType != 6 && tokenType != 5) {
                throw new CRAMException("This constructor should only be used for token types TOKEN_DIFF and TOKEN_DUP");
            }
        }

        @Override
        public String getActualValue() {
            throw new CRAMException("DUP and DIFF tokens have no actual value properties");
        }
    }

    public static class EndToken
    extends EncodeToken {
        public EndToken() {
            super((byte)12, null, null);
        }

        @Override
        public String getActualValue() {
            throw new CRAMException("END tokens have no actual value properties");
        }

        @Override
        public String getRelativeValue() {
            throw new CRAMException("END tokens have no relative value properties");
        }
    }
}

