/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.fqzcomp;

import htsjdk.samtools.cram.compression.fqzcomp.FQZParams;
import htsjdk.samtools.cram.compression.range.ByteModel;

public class FQZModels {
    private final ByteModel[] quality = new ByteModel[65536];
    private final ByteModel[] length;
    private final ByteModel reverse;
    private final ByteModel duplicate;
    private final ByteModel selector;

    public FQZModels(FQZParams fqzParams) {
        int i;
        for (i = 0; i < 65536; ++i) {
            this.quality[i] = new ByteModel(fqzParams.getMaxSymbol() + 1);
        }
        this.length = new ByteModel[4];
        for (i = 0; i < 4; ++i) {
            this.length[i] = new ByteModel(256);
        }
        this.reverse = new ByteModel(2);
        this.duplicate = new ByteModel(2);
        this.selector = fqzParams.getMaxSelector() > 0 ? new ByteModel(fqzParams.getMaxSelector() + 1) : null;
    }

    public ByteModel[] getQuality() {
        return this.quality;
    }

    public ByteModel[] getLength() {
        return this.length;
    }

    public ByteModel getReverse() {
        return this.reverse;
    }

    public ByteModel getDuplicate() {
        return this.duplicate;
    }

    public ByteModel getSelector() {
        return this.selector;
    }
}

