/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression;

import htsjdk.samtools.cram.compression.CompressionUtils;
import htsjdk.samtools.cram.compression.ExternalCompressor;
import htsjdk.samtools.cram.compression.rans.ransnx16.RANSNx16Decode;
import htsjdk.samtools.cram.compression.rans.ransnx16.RANSNx16Encode;
import htsjdk.samtools.cram.compression.rans.ransnx16.RANSNx16Params;
import htsjdk.samtools.cram.structure.CRAMCodecModelContext;
import htsjdk.samtools.cram.structure.block.BlockCompressionMethod;
import java.util.Objects;

public final class RANSNx16ExternalCompressor
extends ExternalCompressor {
    private final int flags;
    private final RANSNx16Encode ransEncode;
    private final RANSNx16Decode ransDecode;

    public RANSNx16ExternalCompressor(RANSNx16Encode ransEncode, RANSNx16Decode ransDecode) {
        this(0, ransEncode, ransDecode);
    }

    public RANSNx16ExternalCompressor(int flags, RANSNx16Encode ransEncode, RANSNx16Decode ransDecode) {
        super(BlockCompressionMethod.RANSNx16);
        this.ransEncode = ransEncode;
        this.ransDecode = ransDecode;
        this.flags = flags;
    }

    @Override
    public byte[] compress(byte[] data, CRAMCodecModelContext unused_contextModel) {
        RANSNx16Params params = new RANSNx16Params(this.flags);
        return CompressionUtils.toByteArray(this.ransEncode.compress(CompressionUtils.wrap(data), params));
    }

    @Override
    public byte[] uncompress(byte[] data) {
        return CompressionUtils.toByteArray(this.ransDecode.uncompress(CompressionUtils.wrap(data)));
    }

    @Override
    public String toString() {
        return String.format("%s(%x)", new Object[]{this.getMethod(), this.flags});
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RANSNx16ExternalCompressor that = (RANSNx16ExternalCompressor)o;
        return this.flags == that.flags;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getMethod(), this.flags});
    }
}

