/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.plugin.reads;

import htsjdk.beta.codecs.reads.bam.BAMDecoderOptions;
import htsjdk.beta.codecs.reads.cram.CRAMDecoderOptions;
import htsjdk.beta.plugin.HtsDecoderOptions;
import htsjdk.samtools.ValidationStringency;
import htsjdk.utils.ValidationUtils;
import java.nio.channels.SeekableByteChannel;
import java.util.Optional;
import java.util.function.Function;

public class ReadsDecoderOptions
implements HtsDecoderOptions {
    private ValidationStringency validationStringency = ValidationStringency.STRICT;
    private boolean eagerlyDecode = false;
    private boolean fileBasedIndexCached = false;
    private boolean memoryMapIndexes = true;
    private Function<SeekableByteChannel, SeekableByteChannel> readsChannelTransformer;
    private Function<SeekableByteChannel, SeekableByteChannel> indexChannelTransformer;
    private BAMDecoderOptions bamDecoderOptions = new BAMDecoderOptions();
    private CRAMDecoderOptions cramDecoderOptions = new CRAMDecoderOptions();

    public ValidationStringency getValidationStringency() {
        return this.validationStringency;
    }

    public ReadsDecoderOptions setValidationStringency(ValidationStringency validationStringency) {
        ValidationUtils.nonNull(validationStringency, "validationStringency");
        this.validationStringency = validationStringency;
        return this;
    }

    public boolean isDecodeEagerly() {
        return this.eagerlyDecode;
    }

    public ReadsDecoderOptions setDecodeEagerly(boolean eagerlyDecode) {
        this.eagerlyDecode = eagerlyDecode;
        return this;
    }

    public boolean isFileBasedIndexCached() {
        return this.fileBasedIndexCached;
    }

    public ReadsDecoderOptions setFileBasedIndexCached(boolean fileBasedIndexCached) {
        this.fileBasedIndexCached = fileBasedIndexCached;
        return this;
    }

    public boolean isMemoryMapIndexes() {
        return this.memoryMapIndexes;
    }

    public ReadsDecoderOptions setMemoryMapIndexes(boolean memoryMapIndexes) {
        this.memoryMapIndexes = memoryMapIndexes;
        return this;
    }

    public BAMDecoderOptions getBAMDecoderOptions() {
        return this.bamDecoderOptions;
    }

    public ReadsDecoderOptions setBAMDecoderOptions(BAMDecoderOptions bamDecoderOptions) {
        ValidationUtils.nonNull(bamDecoderOptions, "bamDecoderOptions");
        this.bamDecoderOptions = bamDecoderOptions;
        return this;
    }

    public CRAMDecoderOptions getCRAMDecoderOptions() {
        return this.cramDecoderOptions;
    }

    public ReadsDecoderOptions setCRAMDecoderOptions(CRAMDecoderOptions cramDecoderOptions) {
        ValidationUtils.nonNull(cramDecoderOptions, "cramDecoderOptions");
        this.cramDecoderOptions = cramDecoderOptions;
        return this;
    }

    public Optional<Function<SeekableByteChannel, SeekableByteChannel>> getReadsChannelTransformer() {
        return Optional.ofNullable(this.readsChannelTransformer);
    }

    public ReadsDecoderOptions setReadsChannelTransformer(Function<SeekableByteChannel, SeekableByteChannel> readsChannelTransformer) {
        this.readsChannelTransformer = readsChannelTransformer;
        return this;
    }

    public Optional<Function<SeekableByteChannel, SeekableByteChannel>> getIndexChannelTransformer() {
        return Optional.ofNullable(this.indexChannelTransformer);
    }

    public ReadsDecoderOptions setIndexChannelTransformer(Function<SeekableByteChannel, SeekableByteChannel> indexChannelTransformer) {
        this.indexChannelTransformer = indexChannelTransformer;
        return this;
    }
}

