/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.io.bundle;

import htsjdk.beta.io.bundle.BundleResource;
import htsjdk.io.IOPath;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.utils.ValidationUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Optional;

public abstract class BundleResourceBase
implements BundleResource,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String displayName;
    private final String contentType;
    private final String format;

    public BundleResourceBase(String displayName, String contentType, String format) {
        ValidationUtils.nonEmpty(displayName, "display name");
        ValidationUtils.nonEmpty(contentType, "content type");
        this.displayName = displayName;
        this.contentType = contentType;
        this.format = format;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public Optional<String> getFileFormat() {
        return Optional.ofNullable(this.format);
    }

    @Override
    public Optional<IOPath> getIOPath() {
        return Optional.empty();
    }

    @Override
    public Optional<InputStream> getInputStream() {
        return Optional.empty();
    }

    @Override
    public Optional<OutputStream> getOutputStream() {
        return Optional.empty();
    }

    @Override
    public Optional<SeekableStream> getSeekableStream() {
        return Optional.empty();
    }

    @Override
    public boolean hasSeekableStream() {
        return false;
    }

    @Override
    public boolean hasInputType() {
        return false;
    }

    @Override
    public boolean hasOutputType() {
        return false;
    }

    public String toString() {
        return String.format("%s (%s): %s/%s", this.getClass().getSimpleName(), this.getDisplayName(), this.getContentType(), this.getFileFormat().orElse("NONE"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BundleResource)) {
            return false;
        }
        BundleResourceBase that = (BundleResourceBase)o;
        if (!this.displayName.equals(that.displayName)) {
            return false;
        }
        if (!this.contentType.equals(that.contentType)) {
            return false;
        }
        return this.format != null ? this.format.equals(that.format) : that.format == null;
    }

    public int hashCode() {
        int result = this.displayName.hashCode();
        result = 31 * result + this.contentType.hashCode();
        result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
        return result;
    }
}

