/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.codecs.reads.cram.cramV3_1;

import htsjdk.beta.codecs.reads.cram.CRAMCodec;
import htsjdk.beta.codecs.reads.cram.CRAMDecoder;
import htsjdk.beta.codecs.reads.cram.CRAMEncoder;
import htsjdk.beta.codecs.reads.cram.cramV3_1.CRAMDecoderV3_1;
import htsjdk.beta.codecs.reads.cram.cramV3_1.CRAMEncoderV3_1;
import htsjdk.beta.exception.HtsjdkIOException;
import htsjdk.beta.io.bundle.Bundle;
import htsjdk.beta.io.bundle.SignatureStream;
import htsjdk.beta.plugin.HtsVersion;
import htsjdk.beta.plugin.reads.ReadsDecoderOptions;
import htsjdk.beta.plugin.reads.ReadsEncoderOptions;
import htsjdk.samtools.cram.structure.CramHeader;
import java.io.IOException;
import java.lang.invoke.StringConcatFactory;
import java.util.Arrays;

public class CRAMCodecV3_1
extends CRAMCodec {
    public static final HtsVersion VERSION_3_1 = new HtsVersion(3, 1, 0);
    private static final String CRAM_MAGIC_3_1 = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", "\u0003\u0001"}, (String)new String(CramHeader.MAGIC));

    @Override
    public HtsVersion getVersion() {
        return VERSION_3_1;
    }

    @Override
    public int getSignatureLength() {
        return CRAM_MAGIC_3_1.length();
    }

    @Override
    public boolean canDecodeSignature(SignatureStream signatureStream, String sourceName) {
        try {
            byte[] signatureBytes = new byte[this.getSignatureLength()];
            int numRead = signatureStream.read(signatureBytes);
            if (numRead < this.getSignatureLength()) {
                throw new HtsjdkIOException(String.format("Failure reading content from stream for %s", sourceName));
            }
            return Arrays.equals(signatureBytes, this.getSignatureString().getBytes());
        }
        catch (IOException e) {
            throw new HtsjdkIOException(String.format("Failure reading content from stream for %s", sourceName));
        }
    }

    public CRAMDecoder getDecoder(Bundle inputBundle, ReadsDecoderOptions readsDecoderOptions) {
        return new CRAMDecoderV3_1(inputBundle, readsDecoderOptions);
    }

    public CRAMEncoder getEncoder(Bundle outputBundle, ReadsEncoderOptions readsEncoderOptions) {
        return new CRAMEncoderV3_1(outputBundle, readsEncoderOptions);
    }

    @Override
    protected String getSignatureString() {
        return CRAM_MAGIC_3_1;
    }
}

