/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.codecs.reads.cram;

import htsjdk.beta.codecs.reads.cram.CRAMCodec;
import htsjdk.beta.codecs.reads.cram.CRAMEncoderOptions;
import htsjdk.beta.exception.HtsjdkUnsupportedOperationException;
import htsjdk.beta.io.bundle.Bundle;
import htsjdk.beta.io.bundle.BundleResource;
import htsjdk.beta.plugin.reads.ReadsEncoder;
import htsjdk.beta.plugin.reads.ReadsEncoderOptions;
import htsjdk.samtools.CRAMFileWriter;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.cram.ref.CRAMReferenceSource;
import htsjdk.samtools.cram.ref.ReferenceSource;
import htsjdk.utils.ValidationUtils;
import java.util.Optional;

public abstract class CRAMEncoder
implements ReadsEncoder {
    private final Bundle outputBundle;
    private final ReadsEncoderOptions readsEncoderOptions;
    private final String displayName;
    private CRAMFileWriter cramFileWriter;

    public CRAMEncoder(Bundle outputBundle, ReadsEncoderOptions readsEncoderOptions) {
        ValidationUtils.nonNull(outputBundle, "outputBundle");
        ValidationUtils.nonNull(readsEncoderOptions, "readsEncoderOptions");
        this.outputBundle = outputBundle;
        this.readsEncoderOptions = readsEncoderOptions;
        this.displayName = outputBundle.getOrThrow("ALIGNED_READS").getDisplayName();
    }

    @Override
    public final String getFileFormat() {
        return "CRAM";
    }

    @Override
    public final String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setHeader(SAMFileHeader samFileHeader) {
        ValidationUtils.nonNull(samFileHeader, "samFileHeader");
        if (this.cramFileWriter != null) {
            throw new IllegalStateException(String.format("A SAMFileHeader has already been has already been set for encoder %s", this.getDisplayName()));
        }
        this.cramFileWriter = this.getCRAMWriter(samFileHeader, this.readsEncoderOptions);
    }

    @Override
    public void write(SAMRecord record) {
        ValidationUtils.nonNull(record, "record");
        if (this.cramFileWriter == null) {
            throw new IllegalStateException(String.format("A SAMFileHeader must be set to establish a CRAM writer for %s", this.getDisplayName()));
        }
        this.cramFileWriter.addAlignment(record);
    }

    @Override
    public void close() {
        if (this.cramFileWriter != null) {
            this.cramFileWriter.close();
        }
    }

    public Bundle getOutputBundle() {
        return this.outputBundle;
    }

    public ReadsEncoderOptions getReadsEncoderOptions() {
        return this.readsEncoderOptions;
    }

    public static CRAMReferenceSource getCRAMReferenceSource(CRAMEncoderOptions cramEncoderOptions) {
        ValidationUtils.nonNull(cramEncoderOptions, "cramEncoderOptions");
        if (cramEncoderOptions.getReferenceSource().isPresent()) {
            return cramEncoderOptions.getReferenceSource().get();
        }
        if (cramEncoderOptions.getReferencePath().isPresent()) {
            return CRAMCodec.getCRAMReferenceSource(cramEncoderOptions.getReferencePath().get());
        }
        return ReferenceSource.getDefaultCRAMReferenceSource();
    }

    private CRAMFileWriter getCRAMWriter(SAMFileHeader samFileHeader, ReadsEncoderOptions readsEncoderOptions) {
        if (readsEncoderOptions.isPreSorted()) {
            BundleResource outputResource = this.outputBundle.getOrThrow("ALIGNED_READS");
            if (outputResource.getIOPath().isPresent()) {
                this.cramFileWriter = new CRAMFileWriter(outputResource.getIOPath().get().getOutputStream(), CRAMEncoder.getCRAMReferenceSource(readsEncoderOptions.getCRAMEncoderOptions()), samFileHeader, outputResource.getIOPath().get().toString());
                return this.cramFileWriter;
            }
            this.cramFileWriter = new CRAMFileWriter(outputResource.getOutputStream().get(), CRAMEncoder.getCRAMReferenceSource(readsEncoderOptions.getCRAMEncoderOptions()), samFileHeader, outputResource.getDisplayName());
            return this.cramFileWriter;
        }
        SAMFileWriterFactory samFileWriterFactory = new SAMFileWriterFactory();
        boolean preSorted = readsEncoderOptions.isPreSorted();
        BundleResource readsResource = this.getOutputBundle().getOrThrow("ALIGNED_READS");
        Optional<BundleResource> optIndexResource = this.getOutputBundle().get("READS_INDEX");
        Optional<BundleResource> optMD5Resource = this.getOutputBundle().get("MD5");
        if (optIndexResource.isPresent()) {
            BundleResource indexResource = optIndexResource.get();
            if (indexResource.getIOPath().isPresent()) {
                samFileWriterFactory.setCreateIndex(true);
            } else {
                throw new HtsjdkUnsupportedOperationException("Writing a CRAM index to a stream is not yet supported");
            }
        }
        if (optMD5Resource.isPresent()) {
            throw new HtsjdkUnsupportedOperationException("Can't yet specify an MD5 resource name");
        }
        CRAMEncoderOptions cramEncoderOptions = readsEncoderOptions.getCRAMEncoderOptions();
        if (!cramEncoderOptions.getReferencePath().isPresent()) {
            throw new IllegalArgumentException("An IOPath reference is required to create a CRAM encoder");
        }
        if (readsResource.getIOPath().isPresent()) {
            return samFileWriterFactory.makeCRAMWriter(samFileHeader, preSorted, readsResource.getIOPath().get().toPath(), cramEncoderOptions.getReferencePath().get().toPath());
        }
        throw new IllegalArgumentException(String.format("An reads IOPath resource is required to create a CRAM encoder (%s)", this.getOutputBundle()));
    }
}

