/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.broad.igv.Globals;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.Paintable;
import org.broad.igv.ui.util.IGVMouseInputAdapter;

public class AttributeHeaderPanel
extends JPanel
implements Paintable {
    static final int MAXIMUM_FONT_SIZE = 10;
    public static final int ATTRIBUTE_COLUMN_WIDTH = 10;
    public static final int COLUMN_BORDER_WIDTH = 1;
    private final boolean darkMode;
    Map<String, Boolean> sortOrder = new HashMap<String, Boolean>();

    public AttributeHeaderPanel() {
        this.darkMode = Globals.isDarkMode();
        this.setBackground(this.darkMode ? UIManager.getColor("Panel.background") : new Color(255, 255, 255));
        this.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseListener();
    }

    public int getAttributeColumnWidth() {
        return 10;
    }

    private String getAttributeHeading(int x) {
        int idx = x / 11;
        List<String> keys = AttributeManager.getInstance().getVisibleAttributes();
        if (idx < keys.size()) {
            return keys.get(idx);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics graphics) {
        List<String> keys;
        super.paintComponent(graphics);
        if (this.darkMode) {
            this.setBackground(UIManager.getColor("Panel.background"));
        }
        if ((keys = AttributeManager.getInstance().getVisibleAttributes()) != null && keys.size() > 0) {
            Graphics2D graphics2 = (Graphics2D)graphics.create();
            try {
                int columnWidth;
                int fontSize;
                if (PreferencesManager.getPreferences().getAntiAliasing()) {
                    graphics2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                }
                if (this.darkMode) {
                    graphics2.setColor(Color.white);
                }
                if ((fontSize = (int)(0.9 * (double)(columnWidth = this.getAttributeColumnWidth()))) > 10) {
                    fontSize = 10;
                }
                Font font = FontManager.getFont(fontSize);
                FontMetrics fm = graphics2.getFontMetrics();
                int fontAscent = fm.getHeight();
                AffineTransform transform = AffineTransform.getTranslateInstance(0.0, this.getHeight() - 1);
                graphics2.transform(transform);
                transform = AffineTransform.getQuadrantRotateInstance(-1);
                graphics2.transform(transform);
                graphics2.setFont(font);
                int i = 1;
                for (String key : keys) {
                    int columnLeftEdge = 11 * i++;
                    int x = columnLeftEdge + (11 - fontAscent) / 2;
                    int stringOffset = 2;
                    graphics2.drawString(key, stringOffset, x);
                }
            }
            finally {
                graphics2.dispose();
            }
        }
    }

    private void addMouseListener() {
        this.setToolTipText("Click attribute heading to sort");
        IGVMouseInputAdapter listener = new IGVMouseInputAdapter(){

            @Override
            public void igvMouseClicked(MouseEvent e) {
                String attKey = AttributeHeaderPanel.this.getAttributeHeading(e.getX());
                if (attKey != null) {
                    Boolean tmp = AttributeHeaderPanel.this.sortOrder.get(attKey);
                    boolean sortAscending = tmp == null ? true : tmp;
                    AttributeHeaderPanel.this.sortTrackByAttribute(attKey, sortAscending);
                    AttributeHeaderPanel.this.sortOrder.put(attKey, !sortAscending);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                String attKey = AttributeHeaderPanel.this.getAttributeHeading(e.getX());
                if (attKey != null) {
                    AttributeManager.ColumnMetaData md = AttributeManager.getInstance().getColumnMetaData(attKey);
                    if (md != null) {
                        StringBuffer buf = new StringBuffer("<html>" + attKey + "<br>Click to sort");
                        AttributeHeaderPanel.this.setToolTipText(buf.toString());
                        return;
                    }
                    AttributeHeaderPanel.this.setToolTipText("Click attribute heading to sort");
                }
            }
        };
        this.addMouseMotionListener(listener);
        this.addMouseListener(listener);
    }

    public final void sortTrackByAttribute(String sortKey, boolean isSortAscending) {
        if (sortKey != null) {
            IGV.getInstance().sortAllTracksByAttributes(new String[]{sortKey}, new boolean[]{isSortAscending});
            IGV.getInstance().getMainFrame().repaint();
        }
    }

    @Override
    public void paintOffscreen(Graphics2D g, Rectangle rect, boolean batch) {
        Graphics2D borderGraphics = (Graphics2D)g.create();
        this.paintComponent(g);
        borderGraphics.setColor(Color.lightGray);
        borderGraphics.drawRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
        borderGraphics.dispose();
    }

    @Override
    public int getSnapshotHeight(boolean batch) {
        return this.getHeight();
    }
}

