/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.commandbar;

import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideToggleButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.broad.igv.Globals;
import org.broad.igv.event.GenomeChangeEvent;
import org.broad.igv.event.GenomeResetEvent;
import org.broad.igv.event.IGVEvent;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.event.IGVEventObserver;
import org.broad.igv.event.RefreshEvent;
import org.broad.igv.event.ViewChange;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.session.History;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.ShowDetailsBehavior;
import org.broad.igv.ui.action.FitDataToWindowMenuAction;
import org.broad.igv.ui.action.ReloadTracksMenuAction;
import org.broad.igv.ui.commandbar.ChromosomeComboBox;
import org.broad.igv.ui.commandbar.GenomeComboBox;
import org.broad.igv.ui.commandbar.SearchTextField;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.panel.ZoomSliderPanel;
import org.broad.igv.ui.util.IconFactory;
import org.broad.igv.ui.util.UIUtilities;

public class IGVCommandBar
extends JPanel
implements IGVEventObserver {
    private static Logger log = LogManager.getLogger(IGVCommandBar.class);
    static final String MODIFY_DETAILS_TOOLTIP = "Modify popup text behavior in data panels";
    static final int DEFAULT_CHROMOSOME_DROPDOWN_WIDTH = 120;
    private ChromosomeComboBox chromosomeComboBox;
    private GenomeComboBox genomeComboBox;
    private JideButton goButton;
    private JideButton homeButton;
    private JPanel locationPanel;
    private JideButton refreshButton;
    private JideToggleButton roiToggleButton;
    private JideButton detailsBehaviorButton;
    private JideToggleButton rulerLineButton;
    private SearchTextField searchTextField;
    private JPanel toolPanel;
    private JPanel zoomControl;
    private JideButton backButton;
    private JideButton forwardButton;
    private JideButton fitToWindowButton;
    private ShowDetailsBehavior detailsBehavior;

    public IGVCommandBar() {
        this.initComponents();
        this.refreshGenomeListComboBox();
        String currentChr = FrameManager.getDefaultFrame().getChrName();
        boolean isWholeGenome = currentChr.equals("All");
        this.chromosomeComboBox.setSelectedItem(currentChr);
        this.roiToggleButton.setEnabled(!isWholeGenome);
        this.zoomControl.setEnabled(!isWholeGenome && !FrameManager.isGeneListMode());
        this.detailsBehaviorButton.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                IGVCommandBar.this.getPopupMenuToolTipBehavior().show(e.getComponent(), e.getX(), e.getY());
            }
        });
        IGVEventBus.getInstance().subscribe(ViewChange.class, this);
        IGVEventBus.getInstance().subscribe(GenomeChangeEvent.class, this);
        IGVEventBus.getInstance().subscribe(GenomeResetEvent.class, this);
    }

    private JPopupMenu getPopupMenuToolTipBehavior() {
        IGVPopupMenu popup = new IGVPopupMenu();
        for (final ShowDetailsBehavior behavior : ShowDetailsBehavior.values()) {
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(behavior.getLabel());
            menuItem.setSelected(this.detailsBehavior == behavior);
            menuItem.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IGVCommandBar.this.detailsBehavior = behavior;
                    PreferencesManager.getPreferences().put("DETAILS_BEHAVIOR", behavior.name());
                }
            });
            popup.add(menuItem);
        }
        return popup;
    }

    public ShowDetailsBehavior getDetailsBehavior() {
        return this.detailsBehavior;
    }

    public void setGeneListMode(boolean geneListMode) {
        this.chromosomeComboBox.setEnabled(!geneListMode);
        if (geneListMode) {
            this.searchTextField.setText("");
        }
        this.zoomControl.setEnabled(!geneListMode);
    }

    public void updateCurrentCoordinates() {
        if (IGV.hasInstance()) {
            if (GenomeManager.getInstance().getCurrentGenome() == Genome.NULL_GENOME) {
                UIUtilities.invokeOnEventThread(() -> this.searchTextField.setText(""));
            } else {
                String p = "";
                ReferenceFrame defaultFrame = FrameManager.getDefaultFrame();
                String chrName = defaultFrame.getChrName();
                if (!"All".equals(chrName) && !FrameManager.isGeneListMode()) {
                    p = defaultFrame.getFormattedLocusString();
                }
                String position = p;
                History history = IGV.getInstance().getSession().getHistory();
                UIUtilities.invokeOnEventThread(() -> {
                    this.searchTextField.setText(position);
                    this.forwardButton.setEnabled(history.canGoForward());
                    this.backButton.setEnabled(history.canGoBack());
                    this.roiToggleButton.setEnabled(!"All".equals(chrName));
                    this.zoomControl.setEnabled(!"All".equals(chrName) && !FrameManager.isGeneListMode());
                });
            }
        }
    }

    public void refreshGenomeListComboBox() {
        UIUtilities.invokeAndWaitOnEventThread(() -> this.genomeComboBox.refreshGenomeListComboBox());
    }

    private void adjustPopupWidth(JComboBox box) {
        if (box.getItemCount() == 0) {
            return;
        }
        Accessible comp = box.getUI().getAccessibleChild(box, 0);
        if (!(comp instanceof JPopupMenu)) {
            return;
        }
        JPopupMenu popup = (JPopupMenu)comp;
        JComponent scrollPane = null;
        for (Component scomp : popup.getComponents()) {
            if (!(scomp instanceof JScrollPane)) continue;
            scrollPane = (JScrollPane)scomp;
        }
        if (scrollPane == null) {
            return;
        }
        int rendererWidth = box.getWidth();
        Dimension size = scrollPane.getPreferredSize();
        size.width = Math.max(size.width, rendererWidth);
        scrollPane.setPreferredSize(size);
        scrollPane.setMaximumSize(size);
        scrollPane.revalidate();
    }

    private void homeButtonActionPerformed(ActionEvent evt) {
        String chrName;
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        IGV.getInstance().setGeneList(null);
        if (genome != null && (chrName = genome.getHomeChromosome()) != null && !chrName.equals(this.chromosomeComboBox.getSelectedItem())) {
            FrameManager.getDefaultFrame().changeChromosome(chrName, false);
        }
    }

    private void refreshButtonActionPerformed(ActionEvent evt) {
        IGVEventBus.getInstance().post(new RefreshEvent());
        new ReloadTracksMenuAction("", -1, IGV.getInstance()).actionPerformed(evt);
    }

    private void goButtonActionPerformed(ActionEvent evt) {
        String searchText = this.searchTextField.getText();
        this.searchByLocus(searchText);
    }

    private void roiToggleButtonActionPerformed(ActionEvent evt) {
        if (this.roiToggleButton.isSelected()) {
            IGV.getInstance().beginROI((JButton)this.roiToggleButton);
        } else {
            IGV.getInstance().endROI();
        }
    }

    @Override
    public void receiveEvent(IGVEvent e) {
        if (e instanceof ViewChange) {
            ViewChange event = (ViewChange)e;
            if (event.type == ViewChange.Type.ChromosomeChange || event.type == ViewChange.Type.LocusChange) {
                String chrName = FrameManager.getDefaultFrame().getChrName();
                this.roiToggleButton.setEnabled(!"All".equals(chrName));
                this.zoomControl.setEnabled(!"All".equals(chrName) && !FrameManager.isGeneListMode());
                String displayName = GenomeManager.getInstance().getCurrentGenome().getChromosomeDisplayName(chrName);
                if (!displayName.equals(this.chromosomeComboBox.getSelectedItem())) {
                    this.chromosomeComboBox.setSelectedItem(displayName);
                }
            }
            this.updateCurrentCoordinates();
            this.repaint();
        } else if (e instanceof GenomeChangeEvent) {
            GenomeChangeEvent event = (GenomeChangeEvent)e;
            Genome genome = event.genome();
            this.refreshGenomeListComboBox();
            this.chromosomeComboBox.updateChromosFromGenome(genome);
            String chrName = FrameManager.getDefaultFrame().getChrName();
            this.zoomControl.setEnabled(!"All".equals(chrName) && !FrameManager.isGeneListMode());
            this.updateCurrentCoordinates();
        } else if (e instanceof GenomeResetEvent) {
            this.refreshGenomeListComboBox();
        } else {
            log.warn("Unknown event class: " + String.valueOf(e.getClass()));
        }
    }

    public void focusSearchBox() {
        this.searchTextField.requestFocusInWindow();
        this.searchTextField.selectAll();
    }

    public void searchByLocus(String searchText) {
        if (searchText != null && searchText.length() > 0) {
            String homeChr = GenomeManager.getInstance().getCurrentGenome().getHomeChromosome();
            if (searchText.equalsIgnoreCase(homeChr)) {
                this.homeButtonActionPerformed(null);
            } else {
                this.searchTextField.setText(searchText);
                this.searchTextField.searchByLocus(searchText);
            }
        }
    }

    private void initComponents() {
        this.setMinimumSize(new Dimension(200, 32));
        JideBoxLayout layout = new JideBoxLayout((Container)this, 0);
        this.setLayout((LayoutManager)layout);
        boolean darkMode = Globals.isDarkMode();
        String detailsPreference = PreferencesManager.getPreferences().get("DETAILS_BEHAVIOR");
        this.detailsBehavior = ShowDetailsBehavior.valueOf(detailsPreference.toUpperCase());
        this.locationPanel = new JPanel();
        this.locationPanel.setBorder(new LineBorder(Color.lightGray, 1, true));
        this.locationPanel.setPreferredSize(new Dimension(150, 20));
        this.locationPanel.setLayout((LayoutManager)new JideBoxLayout((Container)this.locationPanel, 0));
        this.locationPanel.setAlignmentY(0.5f);
        this.locationPanel.add(Box.createRigidArea(new Dimension(10, 36)), "fix");
        this.genomeComboBox = new GenomeComboBox();
        this.genomeComboBox.setMinimumSize(new Dimension(210, 27));
        this.genomeComboBox.setPreferredSize(new Dimension(210, 27));
        this.genomeComboBox.setMaximumSize(new Dimension(300, 27));
        this.genomeComboBox.setToolTipText("Switch the current genome");
        this.genomeComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                try {
                    IGVCommandBar.this.adjustPopupWidth(IGVCommandBar.this.genomeComboBox);
                }
                catch (Exception e1) {
                    log.warn(e1.getMessage(), e1);
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.locationPanel.add((Component)this.genomeComboBox, "fix");
        this.locationPanel.add(Box.createHorizontalStrut(5), "fix");
        this.chromosomeComboBox = new ChromosomeComboBox();
        this.chromosomeComboBox.setToolTipText("Select a chromosome to view");
        this.chromosomeComboBox.setMaximumSize(new Dimension(120, 30));
        this.chromosomeComboBox.setMinimumSize(new Dimension(120, 30));
        this.chromosomeComboBox.setPreferredSize(new Dimension(120, 30));
        this.locationPanel.add((Component)this.chromosomeComboBox, "fix");
        this.locationPanel.add(Box.createHorizontalStrut(5), "fix");
        this.searchTextField = new SearchTextField();
        this.searchTextField.setMaximumSize(new Dimension(250, 15));
        this.searchTextField.setMinimumSize(new Dimension(100, 28));
        this.searchTextField.setPreferredSize(new Dimension(230, 28));
        this.searchTextField.setAlignmentY(0.5f);
        this.locationPanel.add((Component)this.searchTextField, "fix");
        this.goButton = new JideButton("Go");
        this.goButton.setToolTipText("Jump to gene or locus");
        this.goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IGVCommandBar.this.goButtonActionPerformed(evt);
            }
        });
        this.locationPanel.add((Component)this.goButton, "fix");
        this.add((Component)this.locationPanel, "fix");
        this.add(Box.createHorizontalStrut(10), "fix");
        this.toolPanel = new JPanel();
        this.toolPanel.setAlignmentX(1.0f);
        this.toolPanel.setLayout((LayoutManager)new JideBoxLayout((Container)this.toolPanel, 0));
        this.homeButton = new JideButton();
        this.homeButton.setAlignmentX(1.0f);
        this.homeButton.setIcon((Icon)new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Home24.gif")));
        this.homeButton.setMaximumSize(new Dimension(32, 32));
        this.homeButton.setMinimumSize(new Dimension(32, 32));
        this.homeButton.setPreferredSize(new Dimension(32, 32));
        this.homeButton.setToolTipText("Jump to whole genome view");
        this.homeButton.addActionListener(evt -> this.homeButtonActionPerformed(evt));
        this.toolPanel.add((Component)this.homeButton, "fix");
        this.backButton = new JideButton();
        this.backButton.setIcon((Icon)new ImageIcon(this.getClass().getResource(darkMode ? "/images/left-arrow.invert.gif" : "/images/left-arrow.gif")));
        this.backButton.setToolTipText("Go back");
        this.backButton.setMaximumSize(new Dimension(32, 32));
        this.backButton.setMinimumSize(new Dimension(32, 32));
        this.backButton.setPreferredSize(new Dimension(32, 32));
        this.backButton.addActionListener(evt -> {
            History history = IGV.getInstance().getSession().getHistory();
            history.back();
        });
        this.backButton.setEnabled(false);
        this.toolPanel.add((Component)this.backButton, "fix");
        this.forwardButton = new JideButton();
        this.forwardButton.setIcon((Icon)new ImageIcon(this.getClass().getResource(darkMode ? "/images/right-arrow.invert.gif" : "/images/right-arrow.gif")));
        this.forwardButton.setToolTipText("Go forward");
        this.forwardButton.setMaximumSize(new Dimension(32, 32));
        this.forwardButton.setMinimumSize(new Dimension(32, 32));
        this.forwardButton.setPreferredSize(new Dimension(32, 32));
        this.forwardButton.addActionListener(evt -> {
            History history = IGV.getInstance().getSession().getHistory();
            history.forward();
        });
        this.forwardButton.setEnabled(false);
        this.toolPanel.add((Component)this.forwardButton, "fix");
        this.refreshButton = new JideButton();
        this.refreshButton.setAlignmentX(1.0f);
        this.refreshButton.setIcon((Icon)new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Refresh24.gif")));
        this.refreshButton.setMaximumSize(new Dimension(32, 32));
        this.refreshButton.setMinimumSize(new Dimension(32, 32));
        this.refreshButton.setPreferredSize(new Dimension(32, 32));
        this.refreshButton.setToolTipText("Reload tracks and refresh the screen");
        this.refreshButton.addActionListener(evt -> this.refreshButtonActionPerformed(evt));
        this.toolPanel.add((Component)this.refreshButton, "fix");
        ImageIcon regionOfInterestIcon = IconFactory.getInstance().getIcon(IconFactory.IconID.REGION_OF_INTEREST);
        this.roiToggleButton = new JideToggleButton((Icon)regionOfInterestIcon);
        this.roiToggleButton.setAlignmentX(1.0f);
        this.roiToggleButton.setToolTipText("Define a region of interest.");
        this.roiToggleButton.setMaximumSize(new Dimension(32, 32));
        this.roiToggleButton.setMinimumSize(new Dimension(32, 32));
        this.roiToggleButton.setPreferredSize(new Dimension(32, 32));
        this.roiToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IGVCommandBar.this.roiToggleButtonActionPerformed(evt);
            }
        });
        this.toolPanel.add((Component)this.roiToggleButton, "fix");
        this.fitToWindowButton = new JideButton();
        this.fitToWindowButton.setAlignmentX(1.0f);
        this.fitToWindowButton.setIcon((Icon)new ImageIcon(this.getClass().getResource(darkMode ? "/images/collapseall.invert.gif" : "/images/collapseall.gif")));
        this.fitToWindowButton.setMaximumSize(new Dimension(32, 32));
        this.fitToWindowButton.setMinimumSize(new Dimension(32, 32));
        this.fitToWindowButton.setPreferredSize(new Dimension(32, 32));
        this.fitToWindowButton.setToolTipText("Resize tracks to fit in window.");
        this.fitToWindowButton.addActionListener(evt -> new FitDataToWindowMenuAction(null, 0, IGV.getInstance()).actionPerformed(evt));
        this.toolPanel.add((Component)this.fitToWindowButton, "fix");
        ImageIcon noTooltipIcon = IconFactory.getInstance().getIcon(IconFactory.IconID.NO_TOOLTIP);
        ImageIcon tooltipIcon = IconFactory.getInstance().getIcon(IconFactory.IconID.TOOLTIP);
        this.detailsBehaviorButton = new JideButton((Icon)noTooltipIcon);
        this.detailsBehaviorButton.setAlignmentX(1.0f);
        this.detailsBehaviorButton.setToolTipText(MODIFY_DETAILS_TOOLTIP);
        this.detailsBehaviorButton.setMaximumSize(new Dimension(32, 32));
        this.detailsBehaviorButton.setMinimumSize(new Dimension(32, 32));
        this.detailsBehaviorButton.setPreferredSize(new Dimension(32, 32));
        this.toolPanel.add((Component)this.detailsBehaviorButton, "fix");
        this.rulerLineButton = new JideToggleButton();
        this.rulerLineButton.setIcon((Icon)new ImageIcon(this.getClass().getResource("/images/vertical-line.gif")));
        this.rulerLineButton.setAlignmentX(1.0f);
        this.rulerLineButton.setToolTipText("Enable ruler line in data panels");
        this.rulerLineButton.setMaximumSize(new Dimension(32, 32));
        this.rulerLineButton.setMinimumSize(new Dimension(32, 32));
        this.rulerLineButton.setPreferredSize(new Dimension(32, 32));
        this.rulerLineButton.addActionListener(evt -> {
            IGV.getInstance().setRulerEnabled(this.rulerLineButton.isSelected());
            IGV.getInstance().repaint();
        });
        this.toolPanel.add((Component)this.rulerLineButton, "fix");
        this.add(this.toolPanel);
        this.add(Box.createHorizontalGlue(), "vary");
        this.zoomControl = new ZoomSliderPanel();
        Dimension dimSize = new Dimension(200, 30);
        this.zoomControl.setPreferredSize(dimSize);
        this.zoomControl.setMinimumSize(dimSize);
        this.zoomControl.setMaximumSize(dimSize);
        this.zoomControl.setToolTipText("Click + to zoom in,  - to zoom out");
        this.zoomControl.setOpaque(false);
        this.add((Component)this.zoomControl, "fix");
        this.add(Box.createHorizontalStrut(20), "fix");
    }
}

