/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import java.util.List;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.Track;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.TrackFilterDialog;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.TrackFilter;

public class FilterTracksMenuAction
extends MenuAction {
    IGV igv;

    public FilterTracksMenuAction(String label, int mnemonic, IGV igv) {
        super(label, null, mnemonic);
        this.igv = igv;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<String> uniqueAttributeKeys = AttributeManager.getInstance().getAttributeNames();
        if (uniqueAttributeKeys == null && (uniqueAttributeKeys == null || uniqueAttributeKeys.isEmpty())) {
            MessageUtils.showMessage("No attributes found to use in a filter");
            return;
        }
        TrackFilter trackFilter = IGV.getInstance().getSession().getFilter();
        TrackFilterDialog dialog = new TrackFilterDialog(this.igv.getMainFrame(), "Filter Tracks", trackFilter);
        dialog.setVisible(true);
        if (!dialog.isCancelled()) {
            trackFilter = dialog.getFilter();
            this.filterTracks(trackFilter);
            this.igv.repaint();
        }
    }

    private void filterTracks(TrackFilter trackFilter) {
        if (trackFilter == null) {
            List<Track> tracks = IGV.getInstance().getAllTracks();
            IGV.getInstance().getSession().setFilter(null);
            for (Track track : tracks) {
                track.setVisible(true);
            }
        } else {
            IGV.getInstance().getSession().setFilter(trackFilter);
            trackFilter.evaluate();
        }
        for (Track track : IGV.getInstance().getAllTracks()) {
            track.filterSamples(trackFilter);
        }
    }
}

