/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.mcp;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.modelcontextprotocol.server.McpSyncServerExchange;
import io.modelcontextprotocol.spec.McpSchema;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.broad.igv.batch.CommandExecutor;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.ui.IGV;

public class McpTools {
    private static final Logger log = LogManager.getLogger(McpTools.class);
    static IGV igv = IGV.hasInstance() ? IGV.getInstance() : null;
    static CommandExecutor executor = new CommandExecutor(igv);

    public static ToolDescriptor getFileTool() {
        return McpTools.createTool("loadFile", "Loads a file from a given path or URL", List.of(new ToolArgument("path", "A file path or URL", null, false)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<ToolDescriptor> getTools() {
        try (InputStream is = McpTools.class.getResourceAsStream("/tools.yaml");){
            if (is == null) {
                log.error("Could not find tools.yaml");
                List<ToolDescriptor> list2 = Collections.emptyList();
                return list2;
            }
            ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            List toolDefs = (List)mapper.readValue(is, (TypeReference)new TypeReference<List<ToolDefinition>>(){});
            List<ToolDescriptor> list = toolDefs.stream().map(def -> McpTools.createTool(def.name(), def.description(), def.arguments())).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            log.error("Error reading tools.yaml", e);
            return Collections.emptyList();
        }
    }

    static ToolDescriptor createTool(String name, String description, List<ToolArgument> arguments) {
        LinkedHashMap properties = new LinkedHashMap();
        if (arguments != null) {
            for (ToolArgument arg2 : arguments) {
                LinkedHashMap<String, Object> argSchemaMap = new LinkedHashMap<String, Object>();
                argSchemaMap.put("type", "string");
                argSchemaMap.put("description", arg2.description());
                if (arg2.enumValues() != null && !arg2.enumValues().isEmpty()) {
                    List oneOfList = arg2.enumValues().stream().map(ev -> {
                        LinkedHashMap<String, String> constSchema = new LinkedHashMap<String, String>();
                        constSchema.put("const", ev.value());
                        constSchema.put("description", ev.description());
                        return constSchema;
                    }).collect(Collectors.toList());
                    argSchemaMap.put("oneOf", oneOfList);
                }
                properties.put(arg2.name(), argSchemaMap);
            }
        }
        List<Object> requiredArgs = new ArrayList();
        if (arguments != null) {
            requiredArgs = arguments.stream().filter(arg -> !arg.optional()).map(ToolArgument::name).toList();
        }
        McpSchema.JsonSchema inputSchema = new McpSchema.JsonSchema("object", properties, requiredArgs, null, null, null);
        McpSchema.Tool tool = McpSchema.Tool.builder().name(name).description(description).inputSchema(inputSchema).build();
        BiFunction<McpSyncServerExchange, Map<String, Object>, McpSchema.CallToolResult> handler = (exchange, args) -> {
            String argString = "";
            if (args != null && !args.isEmpty()) {
                argString = arguments != null ? arguments.stream().map(ToolArgument::name).filter(args::containsKey).map(args::get).map(Object::toString).collect(Collectors.joining(" ")) : args.values().stream().map(Object::toString).collect(Collectors.joining(" "));
            }
            log.info("Executing tool: " + name + " with args: " + argString);
            String command = (name + " " + argString).trim();
            try {
                String result = executor.execute(command);
                boolean isError = !"OK".equalsIgnoreCase(result);
                return McpSchema.CallToolResult.builder().content(List.of(new McpSchema.TextContent(result))).isError(Boolean.valueOf(isError)).build();
            }
            catch (Exception e) {
                String errorMessage = "Error executing tool '" + name + "': " + e.getMessage();
                log.error(errorMessage, e);
                throw new RuntimeException(errorMessage, e);
            }
        };
        return new ToolDescriptor(tool, handler);
    }

    record ToolArgument(String name, String description, List<EnumValue> enumValues, boolean optional) {
    }

    public record ToolDescriptor(McpSchema.Tool tool, BiFunction<McpSyncServerExchange, Map<String, Object>, McpSchema.CallToolResult> handler) {
    }

    record EnumValue(String value, String description) {
    }

    record ToolDefinition(String name, String description, List<ToolArgument> arguments) {
    }
}

