/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.batch;

import biz.source_code.base64Coder.Base64Coder;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URLDecoder;
import java.nio.channels.ClosedByInterruptException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.broad.igv.Globals;
import org.broad.igv.batch.CommandExecutor;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.oauth.OAuthProvider;
import org.broad.igv.oauth.OAuthUtils;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.StringUtils;

public class CommandListener
implements Runnable {
    public static final String OK = "OK";
    private static boolean isListening = false;
    public static int currentListenerPort = -1;
    private static Logger log = LogManager.getLogger(CommandListener.class);
    private static CommandListener listener;
    private static final String CRLF = "\r\n";
    private int port = -1;
    private ServerSocket serverSocket = null;
    private Socket clientSocket = null;
    private Thread listenerThread;
    boolean halt = false;
    public static Set<String> fileParams;
    public static Set<String> indexParams;
    private static final String HTTP_RESPONSE = "HTTP/1.1 200 OK";
    private static final String HTTP_NO_RESPONSE = "HTTP/1.1 204 No Response";
    private static final String CONNECTION_CLOSE = "Connection: close";
    private static final String NO_CACHE = "Cache-Control: no-cache, no-store";
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin: *";
    private static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers: access-control-allow-origin";

    public static synchronized void start() {
        CommandListener.start(PreferencesManager.getPreferences().getAsInt("PORT_NUMBER"));
    }

    public static synchronized void start(int port) {
        try {
            listener = new CommandListener(port);
            CommandListener.listener.listenerThread.start();
        }
        catch (Exception e) {
            listener.closeSockets();
            listener = null;
            log.error(e);
        }
    }

    public static synchronized void halt() {
        if (listener != null) {
            CommandListener.listener.halt = true;
            CommandListener.listener.listenerThread.interrupt();
            listener.closeSockets();
            listener = null;
        }
    }

    private CommandListener(int port) {
        this.port = port;
        this.listenerThread = new Thread(this);
    }

    public static boolean isListening() {
        return listener != null;
    }

    @Override
    public void run() {
        block7: {
            try {
                CommandExecutor cmdExe = new CommandExecutor(IGV.getInstance());
                this.serverSocket = new ServerSocket(this.port);
                log.info("Listening on port " + this.port);
                currentListenerPort = this.port;
                while (!this.halt) {
                    this.clientSocket = this.serverSocket.accept();
                    this.processClientSession(cmdExe);
                    if (this.clientSocket == null) continue;
                    try {
                        this.clientSocket.close();
                        this.clientSocket = null;
                    }
                    catch (IOException e) {
                        log.error("Error in client socket loop", e);
                    }
                }
            }
            catch (BindException e) {
                log.error(e);
                currentListenerPort = -1;
                listener = null;
            }
            catch (ClosedByInterruptException e) {
                log.error(e);
                listener = null;
            }
            catch (IOException e) {
                listener = null;
                if (this.halt) break block7;
                log.error("IO Error on port socket ", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processClientSession(CommandExecutor cmdExe) throws IOException {
        PrintWriter out = null;
        BufferedReader in = null;
        try {
            String inputLine;
            out = new PrintWriter(this.clientSocket.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
            while (!this.halt && (inputLine = in.readLine()) != null) {
                boolean isHTTP;
                boolean oauthCallback;
                String cmd = inputLine;
                boolean bl = oauthCallback = cmd.startsWith("GET /oauthCallback") || cmd.startsWith("GET /?state=");
                if (oauthCallback) {
                    log.info("OAuth callback received");
                }
                boolean bl2 = isHTTP = cmd.startsWith("OPTIONS") || cmd.startsWith("HEAD") || cmd.startsWith("GET");
                if (isHTTP) {
                    if (cmd.startsWith("OPTIONS")) {
                        this.sendHTTPOptionsResponse(out);
                    } else {
                        Object result = null;
                        String command = null;
                        HashMap<String, String> params = null;
                        String[] tokens = inputLine.split(" ");
                        if (tokens.length < 2) {
                            result = "ERROR unexpected command line: " + inputLine;
                        } else {
                            String[] parts = tokens[1].split("\\?");
                            command = parts[0];
                            params = parts.length < 2 ? new HashMap<String, String>() : this.parseParameters(parts[1]);
                        }
                        HashMap<String, String> headers = new HashMap<String, String>();
                        String nextLine = in.readLine();
                        while (nextLine != null && nextLine.length() > 0) {
                            nextLine = in.readLine();
                            String[] headerTokens = Globals.colonPattern.split(nextLine, 2);
                            if (headerTokens.length != 2) continue;
                            headers.put(headerTokens[0].trim(), headerTokens[1].trim());
                        }
                        if (cmd.startsWith("HEAD")) {
                            this.sendHTTPResponse(out, (String)result, "text/html", "HEAD");
                        } else if (command != null) {
                            if (oauthCallback) {
                                OAuthProvider provider = OAuthUtils.getInstance().getProviderForState((String)params.get("state"));
                                if (params.containsKey("error")) {
                                    this.sendTextResponse(out, "Error authorizing IGV: " + (String)params.get("error"));
                                } else if (params.containsKey("code")) {
                                    provider.fetchAccessToken((String)params.get("code"));
                                    this.sendTextResponse(out, "Authorization successful.  You may close this tab.");
                                } else if (params.containsKey("token")) {
                                    log.info("Oauth token received");
                                    provider.setAccessToken((String)params.get("token"));
                                    this.sendTextResponse(out, "Authorization successful.  You may close this tab.");
                                } else {
                                    this.sendTextResponse(out, "Unsuccessful authorization response: " + inputLine);
                                }
                                if (!PreferencesManager.getPreferences().getAsBoolean("PORT_ENABLED")) {
                                    CommandListener.halt();
                                }
                            } else {
                                result = this.processGet(command, params, cmdExe);
                                if (OK.equals(result)) {
                                    result = null;
                                }
                                this.sendTextResponse(out, (String)result);
                            }
                        }
                    }
                    return;
                }
                try {
                    Globals.setBatch(true);
                    String finalInputLine = inputLine;
                    PrintWriter finalOut = out;
                    UIUtilities.invokeAndWaitOnEventThread(() -> {
                        String response = cmdExe.execute(finalInputLine);
                        finalOut.println(response);
                        finalOut.flush();
                    });
                }
                catch (Exception e) {
                    String response = "ERROR processing command: " + e.getMessage();
                    out.println(response);
                    out.flush();
                }
                finally {
                    Globals.setBatch(false);
                }
            }
        }
        catch (IOException e) {
            log.error("Error processing client session", e);
        }
        finally {
            Globals.setSuppressMessages(false);
            Globals.setBatch(false);
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    private void closeSockets() {
        if (this.clientSocket != null) {
            try {
                this.clientSocket.close();
                this.clientSocket = null;
            }
            catch (IOException e) {
                log.error("Error closing clientSocket", e);
            }
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
                this.serverSocket = null;
            }
            catch (IOException e) {
                log.error("Error closing server socket", e);
            }
        }
    }

    private void sendTextResponse(PrintWriter out, String result) {
        this.sendHTTPResponse(out, result, "text/html", "GET");
    }

    private void sendHTTPResponse(PrintWriter out, String result, String contentType, String method) {
        out.print(result == null ? HTTP_NO_RESPONSE : HTTP_RESPONSE);
        out.print(CRLF);
        out.print(ACCESS_CONTROL_ALLOW_ORIGIN);
        out.print(CRLF);
        if (result != null) {
            out.print("Content-Type: " + contentType);
            out.print(CRLF);
            out.print("Content-Length: " + result.length());
            out.print(CRLF);
            out.print(NO_CACHE);
            out.print(CRLF);
            out.print(CONNECTION_CLOSE);
            out.print(CRLF);
            if (!method.equals("HEAD")) {
                out.print(CRLF);
                out.print(result);
                out.print(CRLF);
            }
        } else {
            out.print(CRLF);
        }
        out.close();
    }

    private void sendHTTPOptionsResponse(PrintWriter out) {
        out.print(HTTP_NO_RESPONSE);
        out.print(CRLF);
        out.print(ACCESS_CONTROL_ALLOW_ORIGIN);
        out.print(CRLF);
        out.print(ACCESS_CONTROL_ALLOW_HEADERS);
        out.print(CRLF);
        out.println("Access-Control-Allow-Methods: HEAD, GET, OPTIONS");
        out.print(CRLF);
        out.close();
    }

    private String processGet(String command, Map<String, String> params, CommandExecutor cmdExe) throws IOException {
        String result = OK;
        Frame mainFrame = IGV.getInstance().getMainFrame();
        mainFrame.toFront();
        mainFrame.setAlwaysOnTop(true);
        mainFrame.setAlwaysOnTop(false);
        if (command.equals("/")) {
            if (params.containsKey("hubURL")) {
                GenomeManager.getInstance().loadGenome(URLDecoder.decode(params.get("hubURL")));
            }
        } else if (command.equals("/load")) {
            String fp;
            String file = null;
            Iterator<String> iterator = fileParams.iterator();
            while (iterator.hasNext() && (file = params.get(fp = iterator.next())) == null) {
            }
            String genome = params.get("genome");
            if (genome == null) {
                genome = params.get("db");
            }
            if (genome != null) {
                GenomeManager.getInstance().loadGenomeById(genome);
            }
            if (file != null) {
                String mergeValue = params.get("merge");
                if (mergeValue != null) {
                    mergeValue = URLDecoder.decode(mergeValue, "UTF-8");
                }
                boolean merge = mergeValue != null ? ("ask".equals(mergeValue) ? !MessageUtils.confirm("Unload current session before loading new tracks?") : mergeValue.equalsIgnoreCase("true")) : !file.endsWith(".xml") && !file.endsWith(".php") && !file.endsWith(".php3");
                String name = params.get("name");
                String format = params.get("format");
                String locus = params.get("locus");
                String index = params.get("index");
                String coverage = params.get("coverage");
                String sort = params.get("sort");
                String sortTag = params.get("sortTag");
                boolean dup = "true".equals(params.get("dup"));
                result = cmdExe.loadFiles(file, index, coverage, name, format, locus, merge, params, sort, sortTag, dup);
            } else {
                result = OK;
            }
        } else if (command.equals("/reload") || command.equals("/goto")) {
            String locus = params.get("locus");
            IGV.getInstance().goToLocus(locus);
        } else if (command.equals("/execute")) {
            String param = StringUtils.decodeURL(params.get("command"));
            result = cmdExe.execute(param);
        } else if (command.equals("/ping")) {
            result = OK;
        } else if (command.equals("/version")) {
            result = "3.0";
        } else {
            return "ERROR Unknown command: " + command;
        }
        return result;
    }

    private Map<String, String> parseParameters(String parameterString) {
        String[] kvPairs;
        parameterString = parameterString.replace("&amp;", "&");
        HashMap<String, String> params = new HashMap<String, String>();
        for (String kvString : kvPairs = parameterString.split("&")) {
            String[] kv = kvString.split("=", 2);
            if (kv.length == 1) {
                params.put(kv[0], null);
                continue;
            }
            String key = StringUtils.decodeURL(kv[0]);
            boolean cmdExeWillDecode = (fileParams.contains(key) || indexParams.contains(key)) && CommandExecutor.needsDecode(kv[1]);
            String value = cmdExeWillDecode ? kv[1] : StringUtils.decodeURL(kv[1]);
            params.put(kv[0], value);
        }
        return params;
    }

    static String computeResponseKey(String input) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest digest = null;
        digest = MessageDigest.getInstance("SHA-1");
        digest.reset();
        digest.update(input.getBytes("UTF-8"));
        return new String(Base64Coder.encode(digest.digest()));
    }

    static {
        String[] fps = new String[]{"file", "bigDataURL", "sessionURL", "dataURL", "hubURL"};
        fileParams = new LinkedHashSet<String>(Arrays.asList(fps));
        fileParams = Collections.unmodifiableSet(fileParams);
        indexParams = new HashSet<String>(Arrays.asList("index"));
    }
}

