/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.codecs.variants.vcf;

import htsjdk.beta.codecs.variants.vcf.VariantsCodecUtils;
import htsjdk.beta.exception.HtsjdkException;
import htsjdk.beta.exception.HtsjdkIOException;
import htsjdk.beta.exception.HtsjdkUnsupportedOperationException;
import htsjdk.beta.io.bundle.Bundle;
import htsjdk.beta.io.bundle.BundleResource;
import htsjdk.beta.plugin.interval.HtsInterval;
import htsjdk.beta.plugin.interval.HtsIntervalUtils;
import htsjdk.beta.plugin.interval.HtsQueryRule;
import htsjdk.beta.plugin.variants.VariantsDecoder;
import htsjdk.beta.plugin.variants.VariantsDecoderOptions;
import htsjdk.io.IOPath;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.FeatureReader;
import htsjdk.utils.ValidationUtils;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.AbstractVCFCodec;
import htsjdk.variant.vcf.VCFHeader;
import java.io.IOException;
import java.util.List;
import java.util.Optional;

public abstract class VCFDecoder
implements VariantsDecoder {
    private final Bundle inputBundle;
    private final VariantsDecoderOptions variantsDecoderOptions;
    private final String displayName;
    private final FeatureReader<VariantContext> vcfReader;
    private final VCFHeader vcfHeader;

    public VCFDecoder(Bundle inputBundle, AbstractVCFCodec vcfCodec, VariantsDecoderOptions variantsDecoderOptions) {
        ValidationUtils.nonNull(inputBundle, "inputBundle");
        ValidationUtils.nonNull(vcfCodec, "vcfCodec");
        ValidationUtils.nonNull(variantsDecoderOptions, "variantsDecoderOptions");
        this.inputBundle = inputBundle;
        this.variantsDecoderOptions = variantsDecoderOptions;
        this.displayName = inputBundle.getOrThrow("VARIANT_CONTEXTS").getDisplayName();
        this.vcfReader = VCFDecoder.getVCFReader(inputBundle, vcfCodec, variantsDecoderOptions);
        this.vcfHeader = (VCFHeader)this.vcfReader.getHeader();
    }

    @Override
    public final String getFileFormat() {
        return "VCF";
    }

    @Override
    public final String getDisplayName() {
        return this.displayName;
    }

    @Override
    public VCFHeader getHeader() {
        return this.vcfHeader;
    }

    @Override
    public CloseableIterator<VariantContext> iterator() {
        try {
            return this.vcfReader.iterator();
        }
        catch (IOException e) {
            throw new HtsjdkIOException(String.format("Exception creating variant context iterator for %s", this.displayName), e);
        }
    }

    @Override
    public boolean isQueryable() {
        VariantsCodecUtils.assertBundleContainsIndex(this.getInputBundle());
        return this.vcfReader.isQueryable();
    }

    @Override
    public boolean hasIndex() {
        VariantsCodecUtils.assertBundleContainsIndex(this.getInputBundle());
        return this.vcfReader.isQueryable();
    }

    @Override
    public CloseableIterator<VariantContext> query(List<HtsInterval> intervals, HtsQueryRule queryRule) {
        ValidationUtils.nonNull(intervals, "interval list");
        ValidationUtils.validateArg(!intervals.isEmpty(), "interval list must contain intervals");
        VariantsCodecUtils.assertBundleContainsIndex(this.getInputBundle());
        if (intervals.size() > 1) {
            throw new HtsjdkUnsupportedOperationException(String.format("query for lists not yet implemented for decoder %s", this.displayName));
        }
        if (queryRule != HtsQueryRule.OVERLAPPING) {
            throw new HtsjdkUnsupportedOperationException(String.format("query for contained intervals not implemented for this decoder %s", this.displayName));
        }
        try {
            return this.vcfReader.query(HtsIntervalUtils.toLocatableList(intervals).get(0));
        }
        catch (IOException e) {
            throw new HtsjdkIOException(String.format("Exception processing query on VCFDecoder %s", this.displayName), e);
        }
    }

    @Override
    public CloseableIterator<VariantContext> query(String queryString) {
        ValidationUtils.nonNull(queryString, "queryString");
        VariantsCodecUtils.assertBundleContainsIndex(this.getInputBundle());
        return this.queryStart(queryString, 1L);
    }

    @Override
    public CloseableIterator<VariantContext> queryStart(String queryName, long start) {
        ValidationUtils.nonNull(queryName, "queryName");
        ValidationUtils.validateArg(this.isQueryable(), String.format("Decoder %s is not queryable", this.displayName));
        VariantsCodecUtils.assertBundleContainsIndex(this.getInputBundle());
        if (this.vcfHeader == null) {
            throw new HtsjdkException(String.format("A valid VCF header is required to execute a query, but is not present: %s.", this.displayName));
        }
        SAMSequenceDictionary seqDict = this.vcfHeader.getSequenceDictionary();
        if (seqDict == null) {
            throw new HtsjdkException(String.format("No  sequence dictionary is present in the input: %s.", this.displayName));
        }
        SAMSequenceRecord samSequenceRecord = seqDict.getSequence(queryName);
        if (samSequenceRecord == null) {
            throw new HtsjdkException(String.format("The query name %s is not present in the dictionary provided in the input: %s.", queryName, this.displayName));
        }
        int length = samSequenceRecord.getSequenceLength();
        try {
            return this.vcfReader.query(queryName, HtsIntervalUtils.toIntegerSafe(start), length);
        }
        catch (IOException e) {
            throw new HtsjdkIOException(String.format("Exception processing queryStart on VCFDecoder", this.displayName), e);
        }
    }

    @Override
    public void close() {
        try {
            this.vcfReader.close();
        }
        catch (IOException e) {
            throw new HtsjdkIOException(String.format("Exception closing input stream %s for", this.getDisplayName()), e);
        }
    }

    public Bundle getInputBundle() {
        return this.inputBundle;
    }

    public VariantsDecoderOptions getReadsDecoderOptions() {
        return this.variantsDecoderOptions;
    }

    private static FeatureReader<VariantContext> getVCFReader(Bundle inputBundle, AbstractVCFCodec vcfCodec, VariantsDecoderOptions decoderOptions) {
        BundleResource variantsResource = inputBundle.getOrThrow("VARIANT_CONTEXTS");
        if (!variantsResource.hasInputType()) {
            throw new IllegalArgumentException(String.format("The provided %s resource (%s) must be a readable/input resource", "VARIANT_CONTEXTS", variantsResource));
        }
        if (variantsResource.getIOPath().isEmpty()) {
            throw new HtsjdkUnsupportedOperationException("VCF reader from stream not implemented");
        }
        IOPath variantsIOPath = variantsResource.getIOPath().get();
        Optional<IOPath> indexIOPath = VCFDecoder.getIndexIOPath(inputBundle);
        return AbstractFeatureReader.getFeatureReader(variantsIOPath.getURIString(), indexIOPath.map(IOPath::getURIString).orElse(null), vcfCodec, indexIOPath.isPresent(), decoderOptions.getVariantsChannelTransformer().orElse(null), decoderOptions.getIndexChannelTransformer().orElse(null));
    }

    private static Optional<IOPath> getIndexIOPath(Bundle inputBundle) {
        Optional<BundleResource> optIndexResource = inputBundle.get("VARIANTS_INDEX");
        if (optIndexResource.isEmpty()) {
            return Optional.empty();
        }
        BundleResource indexResource = optIndexResource.get();
        if (!indexResource.hasInputType()) {
            throw new IllegalArgumentException(String.format("The provided %s index resource (%s) must be a readable/input resource", "VARIANTS_INDEX", indexResource));
        }
        if (indexResource.getIOPath().isEmpty()) {
            throw new HtsjdkUnsupportedOperationException("Reading a VCF index from a stream not implemented");
        }
        return indexResource.getIOPath();
    }
}

