/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.index;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.seekablestream.ISeekableStreamFactory;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.seekablestream.SeekableStreamFactory;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.LocationAware;
import htsjdk.tribble.CloseableTribbleIterator;
import htsjdk.tribble.Feature;
import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.index.DynamicIndexCreator;
import htsjdk.tribble.index.Index;
import htsjdk.tribble.index.IndexCreator;
import htsjdk.tribble.index.interval.IntervalIndexCreator;
import htsjdk.tribble.index.interval.IntervalTreeIndex;
import htsjdk.tribble.index.linear.LinearIndex;
import htsjdk.tribble.index.linear.LinearIndexCreator;
import htsjdk.tribble.index.tabix.TabixFormat;
import htsjdk.tribble.index.tabix.TabixIndex;
import htsjdk.tribble.index.tabix.TabixIndexCreator;
import htsjdk.tribble.readers.PositionalBufferedStream;
import htsjdk.tribble.util.LittleEndianInputStream;
import htsjdk.tribble.util.ParsingUtils;
import htsjdk.utils.ValidationUtils;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Function;
import java.util.zip.GZIPInputStream;

public class IndexFactory {
    public static Index loadIndex(String indexFile) {
        return IndexFactory.loadIndex(indexFile, (Function<SeekableByteChannel, SeekableByteChannel>)null);
    }

    public static Index loadIndex(String indexFile, Function<SeekableByteChannel, SeekableByteChannel> indexWrapper) {
        try {
            return IndexFactory.loadIndex(indexFile, IndexFactory.indexFileInputStream(indexFile, indexWrapper));
        }
        catch (IOException ex) {
            throw new TribbleException.UnableToReadIndexFile("Unable to read index file", indexFile, ex);
        }
    }

    public static Index loadIndex(String source, InputStream inputStream) {
        Index index;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, Defaults.NON_ZERO_BUFFER_SIZE);
        try {
            index = IndexFactory.createIndex(bufferedInputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bufferedInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (EOFException ex) {
                throw new TribbleException.CorruptedIndexFile("Index file is corrupted", source, ex);
            }
            catch (IOException ex) {
                throw new TribbleException.UnableToReadIndexFile("Failed to read index file", source, ex);
            }
        }
        bufferedInputStream.close();
        return index;
    }

    private static Index createIndex(BufferedInputStream bufferedInputStream) throws IOException {
        return IndexType.getIndexType(bufferedInputStream).createIndex(bufferedInputStream);
    }

    private static InputStream indexFileInputStream(String indexFile, Function<SeekableByteChannel, SeekableByteChannel> indexWrapper) throws IOException {
        InputStream inputStreamInitial = ParsingUtils.openInputStream(indexFile, indexWrapper);
        if (indexFile.endsWith(".gz")) {
            return new GZIPInputStream(inputStreamInitial);
        }
        if (indexFile.endsWith(".tbi")) {
            return new BlockCompressedInputStream(inputStreamInitial);
        }
        return inputStreamInitial;
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> LinearIndex createLinearIndex(File inputFile, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> codec) {
        return IndexFactory.createLinearIndex(IOUtil.toPath(inputFile), codec, 8000);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> LinearIndex createLinearIndex(Path inputPath, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> codec) {
        return IndexFactory.createLinearIndex(inputPath, codec, 8000);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> LinearIndex createLinearIndex(File inputFile, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> codec, int binSize) {
        return IndexFactory.createLinearIndex(IOUtil.toPath(inputFile), codec, binSize);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> LinearIndex createLinearIndex(Path inputPath, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> codec, int binSize) {
        ValidationUtils.nonNull(inputPath, "input path must be non-null");
        LinearIndexCreator indexCreator = new LinearIndexCreator(inputPath, binSize);
        return (LinearIndex)IndexFactory.createIndex(inputPath, new FeatureIterator<FEATURE_TYPE, SOURCE_TYPE>(inputPath, codec), indexCreator);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> IntervalTreeIndex createIntervalIndex(File inputFile, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> codec) {
        return IndexFactory.createIntervalIndex(IOUtil.toPath(inputFile), codec, 600);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> IntervalTreeIndex createIntervalIndex(Path inputPath, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> codec) {
        return IndexFactory.createIntervalIndex(inputPath, codec, 600);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> IntervalTreeIndex createIntervalIndex(File inputFile, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> codec, int featuresPerInterval) {
        return IndexFactory.createIntervalIndex(IOUtil.toPath(inputFile), codec, featuresPerInterval);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> IntervalTreeIndex createIntervalIndex(Path inputPath, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> codec, int featuresPerInterval) {
        ValidationUtils.nonNull(inputPath, "input path must be non-null");
        IntervalIndexCreator indexCreator = new IntervalIndexCreator(inputPath, featuresPerInterval);
        return (IntervalTreeIndex)IndexFactory.createIndex(inputPath, new FeatureIterator<FEATURE_TYPE, SOURCE_TYPE>(inputPath, codec), indexCreator);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> Index createDynamicIndex(File inputFile, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> codec) {
        return IndexFactory.createDynamicIndex(IOUtil.toPath(inputFile), codec, IndexBalanceApproach.FOR_SEEK_TIME);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> Index createDynamicIndex(Path inputPath, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> codec) {
        return IndexFactory.createDynamicIndex(inputPath, codec, IndexBalanceApproach.FOR_SEEK_TIME);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> Index createIndex(File inputFile, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> codec, IndexType type) {
        return IndexFactory.createIndex(IOUtil.toPath(inputFile), codec, type, null);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> Index createIndex(Path inputhPath, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> codec, IndexType type) {
        return IndexFactory.createIndex(inputhPath, codec, type, null);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> Index createIndex(File inputFile, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> codec, IndexType type, SAMSequenceDictionary sequenceDictionary) {
        return IndexFactory.createIndex(IOUtil.toPath(inputFile), codec, type, sequenceDictionary);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> Index createIndex(Path inputPath, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> codec, IndexType type, SAMSequenceDictionary sequenceDictionary) {
        switch (type) {
            case INTERVAL_TREE: {
                return IndexFactory.createIntervalIndex(inputPath, codec);
            }
            case LINEAR: {
                return IndexFactory.createLinearIndex(inputPath, codec);
            }
            case TABIX: {
                return IndexFactory.createTabixIndex(inputPath, codec, sequenceDictionary);
            }
        }
        throw new IllegalArgumentException("Unrecognized IndexType " + String.valueOf((Object)type));
    }

    @Deprecated
    public static void writeIndex(Index idx, File idxFile) throws IOException {
        idx.write(idxFile);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> Index createDynamicIndex(File inputFile, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> codec, IndexBalanceApproach iba) {
        return IndexFactory.createDynamicIndex(IOUtil.toPath(inputFile), codec, iba);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> Index createDynamicIndex(Path inputPath, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> codec, IndexBalanceApproach iba) {
        ValidationUtils.nonNull(inputPath, "input path must be non-null");
        DynamicIndexCreator indexCreator = new DynamicIndexCreator(inputPath, iba);
        return IndexFactory.createIndex(inputPath, new FeatureIterator<FEATURE_TYPE, SOURCE_TYPE>(inputPath, codec), indexCreator);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> TabixIndex createTabixIndex(File inputFile, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> codec, TabixFormat tabixFormat, SAMSequenceDictionary sequenceDictionary) {
        return IndexFactory.createTabixIndex(IOUtil.toPath(inputFile), codec, tabixFormat, sequenceDictionary);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> TabixIndex createTabixIndex(Path inputPath, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> codec, TabixFormat tabixFormat, SAMSequenceDictionary sequenceDictionary) {
        ValidationUtils.nonNull(inputPath, "input path must be non-null");
        TabixIndexCreator indexCreator = new TabixIndexCreator(sequenceDictionary, tabixFormat);
        return (TabixIndex)IndexFactory.createIndex(inputPath, new FeatureIterator<FEATURE_TYPE, SOURCE_TYPE>(inputPath, codec), indexCreator);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> TabixIndex createTabixIndex(File inputFile, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> codec, SAMSequenceDictionary sequenceDictionary) {
        return IndexFactory.createTabixIndex(IOUtil.toPath(inputFile), codec, codec.getTabixFormat(), sequenceDictionary);
    }

    public static <FEATURE_TYPE extends Feature, SOURCE_TYPE> TabixIndex createTabixIndex(Path inputPath, FeatureCodec<FEATURE_TYPE, SOURCE_TYPE> codec, SAMSequenceDictionary sequenceDictionary) {
        return IndexFactory.createTabixIndex(inputPath, codec, codec.getTabixFormat(), sequenceDictionary);
    }

    private static Index createIndex(Path inputPath, FeatureIterator iterator, IndexCreator creator) {
        Locatable lastFeature = null;
        HashMap<String, Feature> visitedChromos = new HashMap<String, Feature>(40);
        while (iterator.hasNext()) {
            String lastChr;
            long position = iterator.getPosition();
            Feature currentFeature = iterator.next();
            IndexFactory.checkSorted(inputPath, lastFeature, currentFeature);
            String curChr = currentFeature.getContig();
            String string = lastChr = lastFeature != null ? lastFeature.getContig() : null;
            if (!curChr.equals(lastChr)) {
                if (visitedChromos.containsKey(curChr)) {
                    Object msg = "Input file must have contiguous chromosomes.";
                    msg = (String)msg + " Saw feature " + IndexFactory.featToString((Feature)visitedChromos.get(curChr));
                    msg = (String)msg + " followed later by " + IndexFactory.featToString((Feature)lastFeature);
                    msg = (String)msg + " and then " + IndexFactory.featToString(currentFeature);
                    throw new TribbleException.MalformedFeatureFile((String)msg, inputPath.toString());
                }
                visitedChromos.put(curChr, currentFeature);
            }
            creator.addFeature(currentFeature, position);
            lastFeature = currentFeature;
        }
        long finalPosition = iterator.getPosition();
        iterator.close();
        return creator.finalizeIndex(finalPosition);
    }

    private static String featToString(Feature feature) {
        return feature.getContig() + ":" + feature.getStart() + "-" + feature.getEnd();
    }

    private static void checkSorted(Path inputPath, Feature lastFeature, Feature currentFeature) {
        if (lastFeature != null && currentFeature.getStart() < lastFeature.getStart() && lastFeature.getContig().equals(currentFeature.getContig())) {
            throw new TribbleException.MalformedFeatureFile("Input file is not sorted by start position. \nWe saw a record with a start of " + currentFeature.getContig() + ":" + currentFeature.getStart() + " after a record with a start of " + lastFeature.getContig() + ":" + lastFeature.getStart(), inputPath.toString());
        }
    }

    public static enum IndexType {
        LINEAR(1480870228, LinearIndex.INDEX_TYPE, true, LinearIndex::new, 8000),
        INTERVAL_TREE(1480870228, IntervalTreeIndex.INDEX_TYPE, true, IntervalTreeIndex::new, 600),
        TABIX(TabixIndex.MAGIC_NUMBER, null, false, TabixIndex::new, -1);

        private final int magicNumber;
        private final Integer tribbleIndexType;
        private final int defaultBinSize;
        private final boolean canCreate;
        private final IndexFromStreamFunction createFromInputStream;

        public int getDefaultBinSize() {
            return this.defaultBinSize;
        }

        public boolean canCreate() {
            return this.canCreate;
        }

        private IndexType(int magicNumber, Integer tribbleIndexType, boolean canCreate, IndexFromStreamFunction createFromInputStream, int defaultBinSize) {
            this.magicNumber = magicNumber;
            this.tribbleIndexType = tribbleIndexType;
            this.canCreate = canCreate;
            this.createFromInputStream = createFromInputStream;
            this.defaultBinSize = defaultBinSize;
        }

        public Integer getTribbleIndexType() {
            return this.tribbleIndexType;
        }

        public Index createIndex(InputStream in) {
            try {
                return this.createFromInputStream.apply(in);
            }
            catch (IOException e) {
                throw new TribbleException("Failed to create index from stream.", e);
            }
        }

        public int getMagicNumber() {
            return this.magicNumber;
        }

        public static IndexType getIndexType(BufferedInputStream is) {
            int type;
            int magicNumber;
            is.mark(128);
            LittleEndianInputStream dis = new LittleEndianInputStream(is);
            try {
                magicNumber = dis.readInt();
                type = dis.readInt();
                is.reset();
                for (IndexType indexType : IndexType.values()) {
                    if (indexType.magicNumber != magicNumber || indexType.tribbleIndexType != null && indexType.tribbleIndexType != type) continue;
                    return indexType;
                }
            }
            catch (IOException e) {
                throw new TribbleException("Problem detecting index type", e);
            }
            throw new TribbleException.UnableToCreateCorrectIndexType(String.format("Unknown index type.  magic number: 0x%x; type %d", magicNumber, type));
        }

        private static interface IndexFromStreamFunction {
            public Index apply(InputStream var1) throws IOException;
        }
    }

    static class FeatureIterator<FEATURE_TYPE extends Feature, SOURCE>
    implements CloseableTribbleIterator<Feature> {
        private final SOURCE source;
        private Feature nextFeature;
        private final FeatureCodec<FEATURE_TYPE, SOURCE> codec;
        private final Path inputPath;
        private long cachedPosition;

        public FeatureIterator(File inputFile, FeatureCodec<FEATURE_TYPE, SOURCE> codec) {
            this(IOUtil.toPath(inputFile), codec);
        }

        public FeatureIterator(Path inputPath, FeatureCodec<FEATURE_TYPE, SOURCE> codec) {
            ValidationUtils.nonNull(inputPath, "FeatureIterator input path cannot be null");
            this.codec = codec;
            String filePath = codec.getPathToDataFile(inputPath.toUri().toString());
            try {
                this.inputPath = IOUtil.getPath(filePath);
            }
            catch (IOException e) {
                throw new TribbleException("Failed while constructing a FeatureIterator due to a problem converting String to Path", e);
            }
            try {
                if (IOUtil.hasBlockCompressedExtension(this.inputPath)) {
                    BlockCompressedInputStream bcs = FeatureIterator.initIndexableBlockCompressedStream(this.inputPath);
                    this.source = codec.makeIndexableSourceFromStream(bcs);
                } else {
                    PositionalBufferedStream ps = FeatureIterator.initIndexablePositionalStream(this.inputPath);
                    this.source = codec.makeIndexableSourceFromStream(ps);
                }
                this.codec.readHeader(this.source);
                this.readNextFeature();
            }
            catch (IOException e) {
                throw new TribbleException.InvalidHeader("Error reading header " + e.getMessage());
            }
        }

        private static PositionalBufferedStream initIndexablePositionalStream(Path inputPath) {
            try {
                InputStream fileStream = Files.newInputStream(inputPath, new OpenOption[0]);
                return new PositionalBufferedStream(fileStream);
            }
            catch (IOException e) {
                throw new TribbleException.FeatureFileDoesntExist("Unable to open the input file, most likely the file doesn't exist.", inputPath.toString());
            }
        }

        private static BlockCompressedInputStream initIndexableBlockCompressedStream(Path inputPath) {
            try {
                if (!IOUtil.isBlockCompressed(inputPath, true)) {
                    throw new TribbleException.MalformedFeatureFile("Input file is not in valid block compressed format.", inputPath.toString());
                }
                ISeekableStreamFactory ssf = SeekableStreamFactory.getInstance();
                SeekableStream seekableStream = ssf.getStreamFor(inputPath.toUri().toString());
                return new BlockCompressedInputStream(seekableStream);
            }
            catch (FileNotFoundException e) {
                throw new TribbleException.FeatureFileDoesntExist("Unable to open the input file, most likely the file doesn't exist.", inputPath.toString());
            }
            catch (IOException e) {
                throw new TribbleException.MalformedFeatureFile("Error initializing stream", inputPath.toString(), e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextFeature != null;
        }

        @Override
        public Feature next() {
            Feature ret = this.nextFeature;
            this.readNextFeature();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("We cannot remove");
        }

        public long getPosition() {
            return this.hasNext() ? this.cachedPosition : ((LocationAware)this.source).getPosition();
        }

        @Override
        public Iterator<Feature> iterator() {
            return this;
        }

        @Override
        public void close() {
            this.codec.close(this.source);
        }

        private void readNextFeature() {
            this.cachedPosition = ((LocationAware)this.source).getPosition();
            try {
                this.nextFeature = null;
                while (this.nextFeature == null && !this.codec.isDone(this.source)) {
                    this.nextFeature = this.codec.decodeLoc(this.source);
                }
            }
            catch (IOException e) {
                throw new TribbleException.MalformedFeatureFile("Unable to read a line from the file", this.inputPath.toString(), e);
            }
        }
    }

    public static enum IndexBalanceApproach {
        FOR_SIZE,
        FOR_SEEK_TIME;

    }
}

