/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.util.Comparator;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.genome.ChromosomeNameComparator;

public class ChromosomeComparator
implements Comparator<Chromosome> {
    private final int minSizeImportant;

    public ChromosomeComparator(int minSizeImportant) {
        this.minSizeImportant = minSizeImportant;
    }

    @Override
    public int compare(Chromosome o1, Chromosome o2) {
        boolean o2import;
        boolean checkNames;
        boolean o1import = this.isImportant(o1);
        boolean bl = checkNames = o1import == (o2import = this.isImportant(o2));
        if (checkNames) {
            return ChromosomeNameComparator.get().compare(o1.getName(), o2.getName());
        }
        if (o1import) {
            return -1;
        }
        return 1;
    }

    private boolean isImportant(Chromosome chromo) {
        if (chromo.getLength() > this.minSizeImportant) {
            return true;
        }
        return chromo.getName().toLowerCase().startsWith("chr") && chromo.getName().length() <= 6;
    }
}

