/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bedpe;

import java.awt.Color;
import java.util.Map;
import org.broad.igv.bedpe.BedPE;
import org.broad.igv.bedpe.BedPEShape;

public class BedPEFeature
implements BedPE {
    public String chr1;
    public int start1;
    public int end1;
    public String chr2;
    public int start2;
    public int end2;
    String name;
    String scoreString = "";
    double score;
    Color color;
    int thickness = 1;
    String type;
    Map<String, String> attributes;
    int row;
    BedPEShape shape;

    public BedPEFeature(String chr1, int start1, int end1, String chr2, int start2, int end2) {
        this.chr1 = chr1;
        this.start1 = start1;
        this.chr2 = chr2;
        this.end1 = end1;
        this.start2 = start2;
        this.end2 = end2;
    }

    @Override
    public BedPEFeature get() {
        return this;
    }

    public String getChr() {
        if (this.isSameChr()) {
            return this.chr1;
        }
        return null;
    }

    public int getStart() {
        return Math.min(this.start1, this.start2);
    }

    public int getEnd() {
        return Math.max(this.end1, this.end2);
    }

    public double getMidStart() {
        return Math.min((double)(this.start1 + this.end1) / 2.0, (double)(this.start2 + this.end2) / 2.0);
    }

    public double getMidEnd() {
        return Math.max((double)(this.start1 + this.end1) / 2.0, (double)(this.start2 + this.end2) / 2.0);
    }

    @Override
    public double getScore() {
        return this.score;
    }

    @Override
    public boolean isSameChr() {
        return this.chr1.equals(this.chr2);
    }

    @Override
    public void setRow(int row) {
        this.row = row;
    }

    @Override
    public int getRow() {
        return this.row;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public int getThickness() {
        return this.thickness;
    }

    public String getContig() {
        return this.getChr();
    }

    @Override
    public BedPEShape getShape() {
        return this.shape;
    }

    @Override
    public void setShape(BedPEShape shape) {
        this.shape = shape;
    }

    @Override
    public String getValueString() {
        StringBuffer buf = new StringBuffer();
        String locus1 = this.chr1 + ":" + this.start1 + "-" + this.end1;
        String locus2 = this.chr2 + ":" + this.start2 + "-" + this.end2;
        if (this.name != null && this.name.length() > 0 && !this.name.equals(".")) {
            buf.append(this.name + "<br>");
        }
        buf.append(locus1);
        buf.append("<br>" + locus2);
        buf.append("<br>Score: " + this.score);
        if (this.attributes != null) {
            buf.append("<br><hr>");
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                buf.append("<br>" + entry.getKey() + ": " + entry.getValue());
            }
        }
        return buf.toString();
    }

    @Override
    public double getCenterDistance() {
        return Math.abs((double)(this.start1 + this.end1) / 2.0 - (double)(this.start2 + this.end2) / 2.0);
    }
}

