/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.CloseableTribbleIterator;
import htsjdk.tribble.Feature;
import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.FeatureReader;
import htsjdk.tribble.index.Index;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.broad.igv.Globals;
import org.broad.igv.data.AbstractDataSource;
import org.broad.igv.data.DataTile;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.NamedFeature;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.CachingFeatureReader;
import org.broad.igv.feature.tribble.CodecFactory;
import org.broad.igv.feature.tribble.IGVFeatureReader;
import org.broad.igv.feature.tribble.TribbleIndexNotFoundException;
import org.broad.igv.feature.tribble.TribbleReaderWrapper;
import org.broad.igv.feature.tribble.VCFWrapperCodec;
import org.broad.igv.feature.tribble.reader.IGVComponentMethods;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.IndexCreatorDialog;
import org.broad.igv.util.AmazonUtils;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.RuntimeUtils;
import org.broad.igv.util.collections.CollUtils;

public abstract class TribbleFeatureSource
implements FeatureSource {
    private final ResourceLocator locator;
    private AbstractFeatureReader abstractReader;
    private final boolean useIndex;
    IGVFeatureReader reader;
    boolean isVCF;
    Genome genome;
    Map<String, String> chrNameMap = new HashMap<String, String>();
    private int featureWindowSize;
    Object header;
    Class featureClass;

    public static TribbleFeatureSource getFeatureSource(ResourceLocator locator, Genome genome) throws IOException, TribbleIndexNotFoundException {
        return TribbleFeatureSource.getFeatureSource(locator, genome, true);
    }

    public static TribbleFeatureSource getFeatureSource(ResourceLocator locator, Genome genome, boolean useCache) throws IOException, TribbleIndexNotFoundException {
        String path;
        boolean indexRequired;
        AbstractFeatureReader.setComponentMethods((AbstractFeatureReader.ComponentMethods)IGVComponentMethods.getInstance());
        FeatureCodec codec = CodecFactory.getCodec(locator, genome);
        boolean indexExists = false;
        String idxPath = locator.getIndexPath();
        if (idxPath != null) {
            if (FileUtils.isRemote(idxPath)) {
                idxPath = HttpUtils.mapURL(idxPath);
            }
            indexExists = true;
        } else {
            String maybeIdxPath = ResourceLocator.indexFile(locator);
            if (maybeIdxPath == null) {
                indexExists = false;
            } else {
                if (FileUtils.isRemote(maybeIdxPath)) {
                    maybeIdxPath = HttpUtils.mapURL(maybeIdxPath);
                }
                if (FileUtils.resourceExists(maybeIdxPath)) {
                    indexExists = true;
                    idxPath = maybeIdxPath;
                }
            }
        }
        int hundredMB = 100000000;
        int oneGB = 1000000000;
        long size = FileUtils.getLength(locator.getPath());
        boolean bl = indexRequired = size > 1000000000L;
        if (!Globals.isHeadless() && locator.isLocal() && !locator.getPath().endsWith(".gz") && !indexExists && size > 100000000L) {
            TribbleFeatureSource.createIndex(locator, indexRequired);
        }
        if (FileUtils.isRemote(path = locator.getPath())) {
            path = HttpUtils.mapURL(path);
        }
        AbstractFeatureReader basicReader = AbstractFeatureReader.getFeatureReader((String)path, (String)idxPath, (FeatureCodec)codec, (indexRequired || indexExists ? 1 : 0) != 0);
        if (indexExists) {
            return new IndexedFeatureSource(basicReader, codec, locator, genome, useCache, true);
        }
        return new NonIndexedFeatureSource(basicReader, codec, locator, genome, indexRequired || indexExists);
    }

    private static Index createIndex(ResourceLocator locator, boolean indexRequired) {
        File baseFile = new File(locator.getPath());
        File newIdxFile = new File(locator.getPath() + ".idx");
        String messageText = "An index file for " + baseFile.getAbsolutePath() + " could not be located. An index is " + (indexRequired ? "required" : "recommended") + " to view files of this size.   Click \"Go\" to create one now or \"Cancel to proceed without an index.";
        IndexCreatorDialog dialog = IndexCreatorDialog.createShowDialog(IGV.getMainFrame(), baseFile, newIdxFile, messageText);
        return (Index)dialog.getIndex();
    }

    private TribbleFeatureSource(ResourceLocator locator, AbstractFeatureReader reader, FeatureCodec codec, Genome genome, boolean useCache, boolean useIndex) throws IOException {
        this.useIndex = useIndex;
        this.abstractReader = reader;
        this.locator = locator;
        this.genome = genome;
        this.isVCF = codec.getClass() == VCFWrapperCodec.class;
        this.featureClass = codec.getFeatureType();
        this.header = reader.getHeader();
        this.featureWindowSize = this.estimateFeatureWindowSize((FeatureReader)reader);
        this.reader = useCache ? new CachingFeatureReader((FeatureReader)reader, 5, this.featureWindowSize) : new TribbleReaderWrapper((FeatureReader<Feature>)reader);
    }

    IGVFeatureReader checkReader() {
        try {
            String aPath = this.locator.getPath();
            if (AmazonUtils.isAwsS3Path(aPath).booleanValue() && !AmazonUtils.isS3PresignedValid(aPath)) {
                if (this.reader instanceof CachingFeatureReader) {
                    String idxPath;
                    String path = this.locator.getPath();
                    if (FileUtils.isRemote(path)) {
                        path = HttpUtils.mapURL(path);
                    }
                    if ((idxPath = this.locator.getIndexPath()) != null) {
                        if (FileUtils.isRemote(idxPath)) {
                            idxPath = HttpUtils.mapURL(idxPath);
                        }
                    } else {
                        idxPath = ResourceLocator.indexFile(this.locator);
                        if (idxPath != null && FileUtils.isRemote(idxPath)) {
                            idxPath = HttpUtils.mapURL(idxPath);
                        }
                    }
                    this.abstractReader = AbstractFeatureReader.getFeatureReader((String)path, (String)idxPath, (FeatureCodec)CodecFactory.getCodec(this.locator, this.genome), (boolean)this.useIndex);
                    this.reader = new CachingFeatureReader((FeatureReader)this.abstractReader, 5, this.featureWindowSize);
                } else {
                    this.reader = new TribbleReaderWrapper((FeatureReader<Feature>)this.abstractReader);
                }
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return this.reader;
    }

    protected abstract int estimateFeatureWindowSize(FeatureReader var1);

    protected abstract Collection<String> getSequenceNames();

    public abstract boolean isIndexed();

    public Class getFeatureClass() {
        return this.featureClass;
    }

    @Override
    public int getFeatureWindowSize() {
        return this.featureWindowSize;
    }

    @Override
    public void setFeatureWindowSize(int size) {
        this.featureWindowSize = size;
        if (this.reader instanceof CachingFeatureReader) {
            ((CachingFeatureReader)this.reader).setBinSize(size);
        }
    }

    public Object getHeader() {
        return this.header;
    }

    static class NonIndexedFeatureSource
    extends TribbleFeatureSource {
        Map<String, List<Feature>> featureMap = new HashMap<String, List<Feature>>(25);
        CoverageDataSource coverageData;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private NonIndexedFeatureSource(AbstractFeatureReader basicReader, FeatureCodec codec, ResourceLocator locator, Genome genome, boolean useIndex) throws IOException {
            super(locator, basicReader, codec, genome, false, useIndex);
            Iterator<Feature> iter = null;
            try {
                iter = this.reader.iterator();
                while (iter.hasNext()) {
                    Feature f = iter.next();
                    if (f == null) continue;
                    String seqName = f.getChr();
                    String igvChr = genome == null ? seqName : genome.getCanonicalChrName(seqName);
                    List<Feature> featureList = this.featureMap.get(igvChr);
                    if (featureList == null) {
                        featureList = new ArrayList<Feature>();
                        this.featureMap.put(igvChr, featureList);
                    }
                    featureList.add(f);
                    if (!(f instanceof NamedFeature)) continue;
                    FeatureDB.addFeature((NamedFeature)f, genome);
                }
            }
            finally {
                if (iter instanceof CloseableTribbleIterator) {
                    ((CloseableTribbleIterator)iter).close();
                }
            }
            for (List<Feature> featureList : this.featureMap.values()) {
                FeatureUtils.sortFeatureList(featureList);
            }
            if (genome != null) {
                this.coverageData = new CoverageDataSource(genome);
                this.coverageData.computeGenomeCoverage();
                this.sampleGenomeFeatures();
            }
        }

        @Override
        public void dispose() {
            super.dispose();
            for (List<Feature> featureList : this.featureMap.values()) {
                for (Feature f : featureList) {
                    if (!(f instanceof NamedFeature)) continue;
                    FeatureDB.removeFeature((NamedFeature)f, this.genome);
                }
            }
        }

        @Override
        public boolean isIndexed() {
            return false;
        }

        @Override
        public boolean isLoaded(ReferenceFrame frame) {
            return true;
        }

        @Override
        public List<LocusScore> getCoverageScores(String chr, int start, int end, int zoom) {
            return this.coverageData == null ? Collections.emptyList() : this.coverageData.getSummaryScoresForRange(chr, start, end, zoom);
        }

        public Iterator getFeatures(String chr, int start, int end) throws IOException {
            List<Feature> features = this.featureMap.get(chr);
            if (features == null) {
                return Collections.emptyList().iterator();
            }
            List<Feature> filteredFeatures = CollUtils.filter(features, FeatureUtils.getOverlapPredicate(chr, start, end));
            return filteredFeatures.iterator();
        }

        @Override
        protected Collection<String> getSequenceNames() {
            return this.featureMap.keySet();
        }

        @Override
        protected int estimateFeatureWindowSize(FeatureReader reader) {
            return 0;
        }

        protected void sampleGenomeFeatures() {
            ArrayList<BasicFeature> chrAllFeatures = new ArrayList<BasicFeature>(1000);
            int sampleLength = (int)((double)this.genome.getNominalLength() / 700000.0);
            int lastFeaturePosition = -1;
            for (String chr : this.genome.getLongChromosomeNames()) {
                List<Feature> features = this.featureMap.get(chr);
                if (features == null) continue;
                long offset = this.genome.getCumulativeOffset(chr);
                for (Feature feature : features) {
                    if (!(feature instanceof IGVFeature)) continue;
                    IGVFeature f = (IGVFeature)feature;
                    int genStart = (int)((offset + (long)f.getStart()) / 1000L);
                    int genEnd = (int)((offset + (long)f.getEnd()) / 1000L);
                    if (genEnd <= lastFeaturePosition + sampleLength) continue;
                    BasicFeature f2 = new BasicFeature("All", genStart, genEnd);
                    if (f instanceof BasicFeature) {
                        BasicFeature bf = (BasicFeature)f;
                        f2.setThickEnd((int)((offset + (long)bf.getThickEnd()) / 1000L));
                        f2.setThickStart((int)((offset + (long)bf.getThickStart()) / 1000L));
                        f2.setName(f.getName());
                    }
                    chrAllFeatures.add(f2);
                    lastFeaturePosition = genEnd;
                }
            }
            this.featureMap.put("All", chrAllFeatures);
        }

        class CoverageDataSource
        extends AbstractDataSource {
            int windowSize;
            double dataMin;
            double dataMax;
            Map<String, DataTile> dataCache;

            CoverageDataSource(Genome genome) {
                super(genome);
                this.windowSize = 1000;
                this.dataMin = 0.0;
                this.dataMax = 0.0;
                this.dataCache = new HashMap<String, DataTile>();
            }

            @Override
            protected DataTile getRawData(String chr, int startLocation, int endLocation) {
                DataTile coverageData = this.dataCache.get(chr);
                if (coverageData == null) {
                    coverageData = this.computeCoverage(chr, startLocation, endLocation);
                    this.dataCache.put(chr, coverageData);
                }
                return coverageData;
            }

            @Override
            protected List<LocusScore> getPrecomputedSummaryScores(String chr, int startLocation, int endLocation, int zoom) {
                return null;
            }

            @Override
            public int getLongestFeature(String chr) {
                return this.windowSize;
            }

            @Override
            public double getDataMax() {
                return this.dataMax;
            }

            @Override
            public double getDataMin() {
                return this.dataMin;
            }

            @Override
            public TrackType getTrackType() {
                return TrackType.OTHER;
            }

            private DataTile computeCoverage(String chr, int start, int end) {
                int nBins = (end - start) / this.windowSize + 1;
                int[] starts = new int[nBins];
                int[] ends = new int[nBins];
                for (int i = 0; i < nBins; ++i) {
                    starts[i] = start + i * this.windowSize;
                    ends[i] = starts[i] + this.windowSize;
                }
                float[] values = new float[nBins];
                List<Feature> features = NonIndexedFeatureSource.this.featureMap.get(chr);
                if (features != null) {
                    for (Feature f : features) {
                        int startBin = f.getStart() / this.windowSize;
                        int endBin = f.getEnd() / this.windowSize;
                        for (int i = startBin; i < endBin; ++i) {
                            values[i] = values[i] + 1.0f;
                            this.dataMax = Math.max(this.dataMax, (double)values[i]);
                        }
                    }
                }
                return new DataTile(starts, ends, values, null);
            }

            protected void computeGenomeCoverage() {
                int nBins = 1000;
                int[] starts = new int[nBins];
                int[] ends = new int[nBins];
                float[] values = new float[nBins];
                Arrays.fill(values, 0.0f);
                double step = (double)this.genome.getNominalLength() / 1000.0 / (double)nBins;
                for (int i = 0; i < nBins; ++i) {
                    starts[i] = (int)((double)i * step);
                    ends[i] = (int)((double)(i + 1) * step);
                }
                for (String chr : this.genome.getLongChromosomeNames()) {
                    List<Feature> features = NonIndexedFeatureSource.this.featureMap.get(chr);
                    if (features == null) continue;
                    long offset = this.genome.getCumulativeOffset(chr);
                    for (Feature f : features) {
                        int genStart = (int)((offset + (long)f.getStart()) / 1000L);
                        int genEnd = (int)((offset + (long)f.getEnd()) / 1000L);
                        int binStart = Math.min(values.length - 1, (int)((double)genStart / step));
                        int binEnd = Math.min(values.length - 1, (int)((double)genEnd / step));
                        for (int i = binStart; i <= binEnd; ++i) {
                            values[i] = values[i] + 1.0f;
                            this.dataMax = Math.max(this.dataMax, (double)values[i]);
                        }
                    }
                }
                this.dataCache.put("All", new DataTile(starts, ends, values, null));
            }

            public String getValueString(String chr, double position, ReferenceFrame frame) {
                int zoom = Math.max(0, frame.getZoom());
                List<LocusScore> scores = this.getSummaryScoresForRange(chr, (int)position - 10, (int)position + 10, zoom);
                double bpPerPixel = frame.getScale();
                int minWidth = (int)(2.0 * bpPerPixel);
                if (scores == null) {
                    return "";
                }
                LocusScore score = FeatureUtils.getFeatureAt(position, minWidth, scores);
                return score == null ? "" : "Mean count: " + score.getScore();
            }
        }
    }

    static class IndexedFeatureSource
    extends TribbleFeatureSource {
        private IndexedFeatureSource(AbstractFeatureReader basicReader, FeatureCodec codec, ResourceLocator locator, Genome genome, boolean useCache, boolean useIndex) throws IOException {
            super(locator, basicReader, codec, genome, useCache, useIndex);
            List<String> seqNames;
            if (genome != null && (seqNames = this.reader.getSequenceNames()) != null) {
                for (String seqName : seqNames) {
                    String igvChr = genome.getCanonicalChrName(seqName);
                    if (igvChr == null || igvChr.equals(seqName)) continue;
                    this.chrNameMap.put(igvChr, seqName);
                }
            }
        }

        @Override
        public boolean isIndexed() {
            return true;
        }

        public Iterator<Feature> getFeatures(String chr, int start, int end) throws IOException {
            String seqName = (String)this.chrNameMap.get(chr);
            if (seqName == null) {
                seqName = chr;
            }
            return this.checkReader().query(seqName, start, end);
        }

        @Override
        public List<LocusScore> getCoverageScores(String chr, int start, int end, int zoom) {
            return null;
        }

        @Override
        protected Collection<String> getSequenceNames() {
            return this.checkReader().getSequenceNames();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected int estimateFeatureWindowSize(FeatureReader reader) {
            if (this.isVCF) {
                return 10000;
            }
            try (CloseableTribbleIterator iter = null;){
                double mem = RuntimeUtils.getAvailableMemory();
                iter = reader.iterator();
                if (iter.hasNext()) {
                    Feature firstFeature;
                    int nSamples = 1000;
                    Feature lastFeature = firstFeature = (Feature)iter.next();
                    String chr = firstFeature.getChr();
                    int n = 1;
                    long len = 0L;
                    while (iter.hasNext() && n < nSamples) {
                        Feature f = (Feature)iter.next();
                        if (f == null) continue;
                        ++n;
                        if (f.getChr().equals(chr)) {
                            lastFeature = f;
                            continue;
                        }
                        len += (long)(lastFeature.getEnd() - firstFeature.getStart() + 1);
                        firstFeature = f;
                        lastFeature = f;
                        chr = f.getChr();
                    }
                    double dMem = mem - (double)RuntimeUtils.getAvailableMemory();
                    double bytesPerFeature = Math.max(100.0, dMem / (double)n);
                    double featuresPerBase = (double)n / (double)(len += (long)(lastFeature.getEnd() - firstFeature.getStart() + 1));
                    double targetBinMemory = 2.0E7;
                    int maxBinSize = Integer.MAX_VALUE;
                    int bs = Math.min(maxBinSize, (int)(targetBinMemory / (bytesPerFeature * featuresPerBase)));
                    int n2 = Math.max(1000000, bs);
                    return n2;
                }
                int n = Integer.MAX_VALUE;
                return n;
            }
        }
    }
}

