/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.client.builder;

import java.net.URI;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.awscore.client.config.AwsAdvancedClientOption;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.awscore.internal.EndpointUtils;
import software.amazon.awssdk.awscore.retry.AwsRetryPolicy;
import software.amazon.awssdk.core.client.builder.SdkDefaultClientBuilder;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.regions.providers.LazyAwsRegionProvider;
import software.amazon.awssdk.utils.AttributeMap;

@SdkProtectedApi
public abstract class AwsDefaultClientBuilder<BuilderT extends AwsClientBuilder<BuilderT, ClientT>, ClientT>
extends SdkDefaultClientBuilder<BuilderT, ClientT>
implements AwsClientBuilder<BuilderT, ClientT> {
    private static final String DEFAULT_ENDPOINT_PROTOCOL = "https";
    private static final AwsRegionProvider DEFAULT_REGION_PROVIDER = new LazyAwsRegionProvider(DefaultAwsRegionProviderChain::new);

    protected AwsDefaultClientBuilder() {
    }

    @SdkTestInternalApi
    AwsDefaultClientBuilder(SdkHttpClient.Builder defaultHttpClientBuilder, SdkAsyncHttpClient.Builder defaultAsyncHttpClientFactory) {
        super(defaultHttpClientBuilder, defaultAsyncHttpClientFactory);
    }

    protected abstract String serviceEndpointPrefix();

    protected abstract String signingName();

    protected abstract String serviceName();

    protected final AttributeMap childHttpConfig() {
        return this.serviceHttpConfig();
    }

    protected AttributeMap serviceHttpConfig() {
        return AttributeMap.empty();
    }

    protected final SdkClientConfiguration mergeChildDefaults(SdkClientConfiguration configuration) {
        SdkClientConfiguration config = this.mergeServiceDefaults(configuration);
        return config.merge(c -> c.option(AwsClientOption.AWS_REGION, (Object)this.resolveRegion(config)).option(AwsAdvancedClientOption.ENABLE_DEFAULT_REGION_DETECTION, (Object)true).option(AwsClientOption.CREDENTIALS_PROVIDER, (Object)DefaultCredentialsProvider.create()).option((ClientOption)SdkClientOption.RETRY_POLICY, (Object)AwsRetryPolicy.defaultRetryPolicy()).option((ClientOption)SdkAdvancedClientOption.DISABLE_HOST_PREFIX_INJECTION, (Object)false).option(AwsClientOption.SERVICE_SIGNING_NAME, (Object)this.signingName()).option((ClientOption)SdkClientOption.SERVICE_NAME, (Object)this.serviceName()));
    }

    protected SdkClientConfiguration mergeServiceDefaults(SdkClientConfiguration configuration) {
        return configuration;
    }

    protected final SdkClientConfiguration finalizeChildConfiguration(SdkClientConfiguration configuration) {
        SdkClientConfiguration config = configuration.toBuilder().option((ClientOption)SdkClientOption.ENDPOINT, (Object)this.resolveEndpoint(configuration)).option(AwsClientOption.SIGNING_REGION, (Object)this.resolveSigningRegion(configuration)).build();
        return this.finalizeServiceConfiguration(config);
    }

    protected SdkClientConfiguration finalizeServiceConfiguration(SdkClientConfiguration configuration) {
        return configuration;
    }

    private Region resolveSigningRegion(SdkClientConfiguration config) {
        return ServiceMetadata.of((String)this.serviceEndpointPrefix()).signingRegion((Region)config.option(AwsClientOption.AWS_REGION));
    }

    private URI resolveEndpoint(SdkClientConfiguration config) {
        return Optional.ofNullable(config.option((ClientOption)SdkClientOption.ENDPOINT)).orElseGet(() -> EndpointUtils.buildEndpoint(DEFAULT_ENDPOINT_PROTOCOL, this.serviceEndpointPrefix(), (Region)config.option(AwsClientOption.AWS_REGION)));
    }

    private Region resolveRegion(SdkClientConfiguration config) {
        return config.option(AwsClientOption.AWS_REGION) != null ? (Region)config.option(AwsClientOption.AWS_REGION) : this.regionFromDefaultProvider(config);
    }

    private Region regionFromDefaultProvider(SdkClientConfiguration config) {
        Boolean defaultRegionDetectionEnabled = (Boolean)config.option(AwsAdvancedClientOption.ENABLE_DEFAULT_REGION_DETECTION);
        if (defaultRegionDetectionEnabled != null && !defaultRegionDetectionEnabled.booleanValue()) {
            throw new IllegalStateException("No region was configured, and use-region-provider-chain was disabled.");
        }
        return DEFAULT_REGION_PROVIDER.getRegion();
    }

    @Override
    public final BuilderT region(Region region) {
        this.clientConfiguration.option(AwsClientOption.AWS_REGION, (Object)region);
        return (BuilderT)((AwsClientBuilder)this.thisBuilder());
    }

    public final void setRegion(Region region) {
        this.region(region);
    }

    @Override
    public final BuilderT credentialsProvider(AwsCredentialsProvider credentialsProvider) {
        this.clientConfiguration.option(AwsClientOption.CREDENTIALS_PROVIDER, (Object)credentialsProvider);
        return (BuilderT)((AwsClientBuilder)this.thisBuilder());
    }

    public final void setCredentialsProvider(AwsCredentialsProvider credentialsProvider) {
        this.credentialsProvider(credentialsProvider);
    }
}

