/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.encoding.reader.CramRecordReader;
import htsjdk.samtools.cram.ref.ReferenceContext;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.Slice;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ContainerParser {
    private final SAMFileHeader samFileHeader;

    public ContainerParser(SAMFileHeader samFileHeader) {
        this.samFileHeader = samFileHeader;
    }

    public List<CramCompressionRecord> getRecords(Container container, ArrayList<CramCompressionRecord> records, ValidationStringency validationStringency) {
        if (container.isEOF()) {
            return Collections.emptyList();
        }
        if (records == null) {
            records = new ArrayList(container.nofRecords);
        }
        for (Slice slice : container.getSlices()) {
            records.addAll(this.getRecords(slice, container.compressionHeader, validationStringency));
        }
        return records;
    }

    private ArrayList<CramCompressionRecord> getRecords(Slice slice, CompressionHeader header, ValidationStringency validationStringency) {
        ReferenceContext sliceContext = slice.getReferenceContext();
        String seqName = "*";
        if (sliceContext.isMappedSingleRef()) {
            SAMSequenceRecord sequence = this.samFileHeader.getSequence(sliceContext.getSequenceId());
            seqName = sequence.getSequenceName();
        }
        CramRecordReader reader = slice.createCramRecordReader(header, validationStringency);
        ArrayList<CramCompressionRecord> records = new ArrayList<CramCompressionRecord>(slice.nofRecords);
        int prevAlignmentStart = slice.alignmentStart;
        for (int i = 0; i < slice.nofRecords; ++i) {
            CramCompressionRecord record = new CramCompressionRecord();
            record.sliceIndex = slice.index;
            record.index = i;
            prevAlignmentStart = reader.read(record, prevAlignmentStart);
            record.sequenceName = sliceContext.isMappedSingleRef() && record.sequenceId == sliceContext.getSequenceId() ? seqName : (record.sequenceId == -1 ? "*" : this.samFileHeader.getSequence(record.sequenceId).getSequenceName());
            records.add(record);
        }
        return records;
    }
}

