/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import htsjdk.tribble.Feature;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.data.AbstractDataSource;
import org.broad.igv.data.CombinedDataSource;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.Range;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.basepair.BasePairTrack;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.feature.tribble.IGVBEDCodec;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.renderer.BarChartRenderer;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.HeatmapRenderer;
import org.broad.igv.renderer.LineplotRenderer;
import org.broad.igv.renderer.PointsRenderer;
import org.broad.igv.sam.AlignmentDataManager;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.CoverageTrack;
import org.broad.igv.sam.SAMWriter;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.DataSourceTrack;
import org.broad.igv.track.DataTrack;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.MergedTracks;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackMenuItemBuilder;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.DataRangeDialog;
import org.broad.igv.ui.HeatmapScaleDialog;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.PanelName;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.panel.TrackPanel;
import org.broad.igv.ui.util.FileDialogUtils;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.Pair;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.StringUtils;
import org.broad.igv.util.blat.BlatClient;
import org.broad.igv.util.collections.CollUtils;
import org.broad.igv.util.extview.ExtendViewClient;

public class TrackMenuUtils {
    static Logger log = Logger.getLogger(TrackMenuUtils.class);
    static final String LEADING_HEADING_SPACER = "  ";
    private static List<TrackMenuItemBuilder> trackMenuItems = new ArrayList<TrackMenuItemBuilder>();

    public static IGVPopupMenu getPopupMenu(Collection<Track> tracks, String title, TrackClickEvent te) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"enter getPopupMenu");
        }
        IGVPopupMenu menu = new IGVPopupMenu();
        JLabel popupTitle = new JLabel(LEADING_HEADING_SPACER + title, 0);
        popupTitle.setFont(UIConstants.boldFont);
        if (popupTitle != null) {
            menu.add(popupTitle);
            menu.addSeparator();
        }
        TrackMenuUtils.addStandardItems(menu, tracks, te);
        return menu;
    }

    public static void addPluginItems(JPopupMenu menu, Collection<Track> tracks, TrackClickEvent te) {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>(0);
        for (TrackMenuItemBuilder builder : trackMenuItems) {
            JMenuItem item = builder.build(tracks, te);
            if (item == null) continue;
            items.add(item);
        }
        if (items.size() > 0) {
            menu.addSeparator();
            for (JMenuItem item : items) {
                menu.add(item);
            }
        }
    }

    public static void addStandardItems(JPopupMenu menu, Collection<Track> tracks, TrackClickEvent te) {
        boolean hasDataTracks = false;
        boolean hasFeatureTracks = false;
        boolean hasOtherTracks = false;
        boolean hasCoverageTracks = false;
        for (Track track : tracks) {
            if (track instanceof DataTrack) {
                hasDataTracks = true;
            } else if (track instanceof CoverageTrack) {
                hasDataTracks = true;
                hasCoverageTracks = true;
            } else if (track instanceof FeatureTrack) {
                hasFeatureTracks = true;
            } else {
                hasOtherTracks = true;
            }
            if (!hasDataTracks || !hasFeatureTracks || !hasOtherTracks) continue;
            break;
        }
        boolean hasBasePairTracks = false;
        for (Track track : tracks) {
            if (!(track instanceof BasePairTrack)) continue;
            hasBasePairTracks = true;
            break;
        }
        if (hasBasePairTracks) {
            TrackMenuUtils.addBasePairItems(menu, tracks);
        }
        boolean bl = hasFeatureTracks && !hasDataTracks && !hasOtherTracks;
        boolean dataTracksOnly = !hasFeatureTracks && hasDataTracks && !hasOtherTracks;
        TrackMenuUtils.addSharedItems(menu, tracks, hasFeatureTracks, hasCoverageTracks);
        menu.addSeparator();
        if (dataTracksOnly) {
            TrackMenuUtils.addDataItems(menu, tracks, hasCoverageTracks);
        } else if (bl) {
            TrackMenuUtils.addFeatureItems(menu, tracks, te);
        }
    }

    public static void addZoomItems(JPopupMenu menu, final ReferenceFrame frame) {
        if (FrameManager.isGeneListMode()) {
            JMenuItem item = new JMenuItem("Reset panel to '" + frame.getName() + "'");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    frame.reset();
                }
            });
            menu.add(item);
        }
        JMenuItem zoomOutItem = new JMenuItem("Zoom out");
        zoomOutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                frame.doZoomIncrement(-1);
            }
        });
        menu.add(zoomOutItem);
        JMenuItem zoomInItem = new JMenuItem("Zoom in");
        zoomInItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                frame.doZoomIncrement(1);
            }
        });
        menu.add(zoomInItem);
    }

    public static void addDataItems(JPopupMenu menu, final Collection<Track> tracks, boolean hasCoverageTracks) {
        boolean merged;
        if (log.isTraceEnabled()) {
            log.trace((Object)"enter getDataPopupMenu");
        }
        if (!hasCoverageTracks) {
            String[] labels = new String[]{"Heatmap", "Bar Chart", "Points", "Line Plot"};
            Class[] renderers = new Class[]{HeatmapRenderer.class, BarChartRenderer.class, PointsRenderer.class, LineplotRenderer.class};
            JLabel rendererHeading = new JLabel("  Type of Graph", 2);
            rendererHeading.setFont(UIConstants.boldFont);
            menu.add(rendererHeading);
            HashSet currentRenderers = new HashSet();
            for (Track track : tracks) {
                if (track.getRenderer() == null) continue;
                currentRenderers.add(track.getRenderer().getClass());
            }
            for (int i = 0; i < labels.length; ++i) {
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(labels[i]);
                final Class clazz = renderers[i];
                if (currentRenderers.contains(clazz)) {
                    item.setSelected(true);
                }
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        TrackMenuUtils.changeRenderer(tracks, clazz);
                    }
                });
                menu.add(item);
            }
            menu.addSeparator();
            LinkedHashSet<WindowFunction> avaibleWindowFunctions = new LinkedHashSet<WindowFunction>();
            avaibleWindowFunctions.addAll(AbstractDataSource.ORDERED_WINDOW_FUNCTIONS);
            for (Track track : tracks) {
                avaibleWindowFunctions.retainAll(track.getAvailableWindowFunctions());
            }
            WindowFunction currentWindowFunction = null;
            for (Track track : tracks) {
                WindowFunction twf = track.getWindowFunction();
                if (currentWindowFunction == null) {
                    currentWindowFunction = twf;
                    continue;
                }
                if (twf == currentWindowFunction) continue;
                currentWindowFunction = null;
                break;
            }
            if (avaibleWindowFunctions.size() > 0) {
                JLabel jLabel = new JLabel("  Windowing Function", 2);
                jLabel.setFont(UIConstants.boldFont);
                menu.add(jLabel);
                for (final WindowFunction wf : avaibleWindowFunctions) {
                    JCheckBoxMenuItem item = new JCheckBoxMenuItem(wf.getValue());
                    item.setSelected(currentWindowFunction == wf);
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            TrackMenuUtils.changeStatType(wf.toString(), tracks);
                        }
                    });
                    menu.add(item);
                }
                menu.addSeparator();
            }
        }
        menu.add(TrackMenuUtils.getDataRangeItem(tracks));
        if (!hasCoverageTracks) {
            menu.add(TrackMenuUtils.getHeatmapScaleItem(tracks));
        }
        if (tracks.size() > 0) {
            menu.add(TrackMenuUtils.getLogScaleItem(tracks));
        }
        menu.add(TrackMenuUtils.getAutoscaleItem(tracks));
        if (tracks.size() > 1 || tracks.size() == 1 && tracks.iterator().next() instanceof MergedTracks) {
            menu.add(TrackMenuUtils.getGroupAutoscaleItem(tracks));
        }
        menu.add(TrackMenuUtils.getShowDataRangeItem(tracks));
        Track firstTrack = tracks.iterator().next();
        boolean bl = merged = tracks.size() == 1 && firstTrack instanceof MergedTracks;
        if (tracks.size() > 1 || merged) {
            menu.addSeparator();
            final ArrayList dataTrackList = Lists.newArrayList((Iterable)Iterables.filter(tracks, DataTrack.class));
            JMenuItem overlayGroups = new JMenuItem("Overlay Tracks");
            overlayGroups.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MergedTracks mergedTracks = new MergedTracks(UUID.randomUUID().toString(), "Overlay", dataTrackList);
                    Track firstTrack = (Track)tracks.iterator().next();
                    TrackPanel panel = TrackPanel.getParentPanel(firstTrack);
                    panel.addTrack(mergedTracks);
                    panel.moveSelectedTracksTo(Arrays.asList(mergedTracks), firstTrack, false);
                    panel.removeTracks(tracks);
                }
            });
            int numDataTracks = dataTrackList.size();
            overlayGroups.setEnabled(numDataTracks >= 2 && numDataTracks == tracks.size());
            menu.add(overlayGroups);
            JMenuItem unmergeItem = new JMenuItem("Separate Tracks");
            menu.add(unmergeItem);
            if (merged) {
                unmergeItem.addActionListener(e -> {
                    Track firstTrack1 = (Track)tracks.iterator().next();
                    TrackPanel panel = TrackPanel.getParentPanel(firstTrack1);
                    MergedTracks mergedTracks = (MergedTracks)firstTrack1;
                    mergedTracks.setTrackAlphas(1.0);
                    panel.addTracks(mergedTracks.getMemberTracks());
                    panel.moveSelectedTracksTo(mergedTracks.getMemberTracks(), mergedTracks, true);
                    IGV.getInstance().removeTracks(Arrays.asList(mergedTracks));
                });
            } else {
                unmergeItem.setEnabled(false);
            }
            if (merged) {
                Track track = tracks.iterator().next();
                MergedTracks mergedTracks = (MergedTracks)track;
                JMenuItem alphaItem = new JMenuItem("Adjust Transparency");
                alphaItem.addActionListener(e -> {
                    JDialog alphaDialog = mergedTracks.getAlphaDialog();
                    alphaDialog.setVisible(true);
                });
                menu.add(alphaItem);
            }
        }
        if (Globals.isDevelopment() && FrameManager.isGeneListMode() && tracks.size() == 1) {
            menu.addSeparator();
            menu.add(TrackMenuUtils.getShowSortFramesItem(tracks.iterator().next()));
        }
    }

    private static List<JMenuItem> getCombinedDataSourceItems(Collection<Track> tracks) {
        Iterable dataTracksIter = Iterables.filter(tracks, DataTrack.class);
        final ArrayList dataTracks = Lists.newArrayList((Iterable)dataTracksIter);
        JMenuItem addItem = new JMenuItem("Sum Tracks");
        JMenuItem subItem = new JMenuItem("Subtract Tracks");
        boolean enableComb = dataTracks.size() == 2;
        addItem.setEnabled(enableComb);
        addItem.setEnabled(enableComb);
        addItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackMenuUtils.addCombinedDataTrack(dataTracks, CombinedDataSource.Operation.ADD);
            }
        });
        subItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackMenuUtils.addCombinedDataTrack(dataTracks, CombinedDataSource.Operation.SUBTRACT);
            }
        });
        return Arrays.asList(addItem, subItem);
    }

    private static void addCombinedDataTrack(List<DataTrack> dataTracks, CombinedDataSource.Operation op) {
        String text = "";
        switch (op) {
            case ADD: {
                text = "Sum";
                break;
            }
            case SUBTRACT: {
                text = "Difference";
            }
        }
        DataTrack track0 = dataTracks.get(0);
        DataTrack track1 = dataTracks.get(1);
        CombinedDataSource source = new CombinedDataSource(track0, track1, op);
        DataSourceTrack newTrack = new DataSourceTrack(null, track0.getId() + track1.getId() + text, text, source);
        TrackMenuUtils.changeRenderer(Arrays.asList(newTrack), track0.getRenderer().getClass());
        newTrack.setDataRange(track0.getDataRange());
        newTrack.setColorScale(track0.getColorScale());
        IGV.getInstance().addTracks(Arrays.asList(newTrack), PanelName.DATA_PANEL);
    }

    private static void addFeatureItems(JPopupMenu featurePopupMenu, Collection<Track> tracks, TrackClickEvent te) {
        TrackMenuUtils.addDisplayModeItems(tracks, featurePopupMenu);
        if (tracks.size() == 1) {
            Track t = tracks.iterator().next();
            Feature f = t.getFeatureAtMousePosition(te);
            ReferenceFrame frame = te.getFrame();
            if (frame == null && !FrameManager.isGeneListMode()) {
                frame = FrameManager.getDefaultFrame();
            }
            String featureName = "";
            if (f != null) {
                featurePopupMenu.addSeparator();
                featurePopupMenu.add(TrackMenuUtils.getCopyDetailsItem(f, te));
                Feature sequenceFeature = f;
                if (sequenceFeature instanceof IGVFeature) {
                    featureName = ((IGVFeature)sequenceFeature).getName();
                    double position = te.getChromosomePosition();
                    List<Exon> exons = ((IGVFeature)sequenceFeature).getExons();
                    if (exons != null) {
                        for (Exon exon : exons) {
                            if (!(position > (double)exon.getStart()) || !(position < (double)exon.getEnd())) continue;
                            sequenceFeature = exon;
                            break;
                        }
                    }
                }
                featurePopupMenu.add(TrackMenuUtils.getCopySequenceItem(sequenceFeature));
                if (frame != null) {
                    Range r = frame.getCurrentRange();
                    featurePopupMenu.add(TrackMenuUtils.getExtendViewItem(featureName, sequenceFeature, r));
                }
                featurePopupMenu.add(TrackMenuUtils.getBlatItem(sequenceFeature));
            }
            if (Globals.isDevelopment()) {
                featurePopupMenu.addSeparator();
                featurePopupMenu.add(TrackMenuUtils.getFeatureToGeneListItem(t));
            }
            if (Globals.isDevelopment() && FrameManager.isGeneListMode() && tracks.size() == 1) {
                featurePopupMenu.addSeparator();
                featurePopupMenu.add(TrackMenuUtils.getShowSortFramesItem(tracks.iterator().next()));
            }
        }
        featurePopupMenu.addSeparator();
        featurePopupMenu.add(TrackMenuUtils.getChangeFeatureWindow(tracks));
    }

    /*
     * WARNING - void declaration
     */
    public static void addBasePairItems(JPopupMenu menu, final Collection<Track> tracks) {
        void var7_11;
        final ArrayList<BasePairTrack> bpTracks = new ArrayList<BasePairTrack>();
        for (Track track : tracks) {
            if (!(track instanceof BasePairTrack)) continue;
            bpTracks.add((BasePairTrack)track);
        }
        JLabel arcColorHeading = new JLabel("  Arc colors (click to change)", 2);
        arcColorHeading.setFont(UIConstants.boldFont);
        menu.add(arcColorHeading);
        ArrayList<Pair<Color, String>> legendList = new ArrayList<Pair<Color, String>>();
        HashSet<CallSite> keys = new HashSet<CallSite>();
        for (BasePairTrack basePairTrack : bpTracks) {
            List<String> colors = basePairTrack.getRenderOptions().getColors();
            List<String> colorLabels = basePairTrack.getRenderOptions().getColorLabels();
            for (int i = colors.size() - 1; i >= 0; --i) {
                String key = colors.get(i) + " " + colorLabels.get(i);
                if (keys.contains(key)) continue;
                keys.add((CallSite)((Object)key));
                legendList.add(new Pair<Color, String>(ColorUtilities.stringToColor(colors.get(i)), colorLabels.get(i)));
            }
        }
        for (Pair pair : legendList) {
            final Color color = (Color)pair.getFirst();
            final String label = (String)pair.getSecond();
            JLabel colorBox = new JLabel(LEADING_HEADING_SPACER);
            colorBox.setFont(UIConstants.boldFont);
            colorBox.setForeground(color);
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 0));
            p.add(colorBox);
            p.add(Box.createHorizontalStrut(1));
            p.add(new JLabel(" " + label));
            p.add(Box.createGlue());
            p.setAlignmentX(0.0f);
            JMenuItem item = new JMenuItem();
            item.add(p);
            double w = p.getPreferredSize().getWidth();
            double h = p.getPreferredSize().getHeight();
            Dimension size = new Dimension();
            size.setSize(w, h + 8.0);
            item.setPreferredSize(size);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TrackMenuUtils.changeBasePairTrackColor(bpTracks, color, label);
                }
            });
            menu.add(item);
        }
        menu.addSeparator();
        JLabel arcDirectionHeading = new JLabel("  Arc direction", 2);
        arcDirectionHeading.setFont(UIConstants.boldFont);
        menu.add(arcDirectionHeading);
        boolean bl = false;
        int downCount = 0;
        BasePairTrack.ArcDirection currentArcDirection = null;
        for (BasePairTrack track : bpTracks) {
            if (track.getRenderOptions().getArcDirection() == BasePairTrack.ArcDirection.UP) {
                ++var7_11;
            }
            if (track.getRenderOptions().getArcDirection() != BasePairTrack.ArcDirection.DOWN) continue;
            ++downCount;
        }
        if (var7_11 == false) {
            currentArcDirection = BasePairTrack.ArcDirection.DOWN;
        }
        if (downCount == 0) {
            currentArcDirection = BasePairTrack.ArcDirection.UP;
        }
        ButtonGroup group = new ButtonGroup();
        LinkedHashMap<String, BasePairTrack.ArcDirection> arcDirections = new LinkedHashMap<String, BasePairTrack.ArcDirection>(3);
        arcDirections.put("Up", BasePairTrack.ArcDirection.UP);
        arcDirections.put("Down", BasePairTrack.ArcDirection.DOWN);
        for (final Map.Entry entry : arcDirections.entrySet()) {
            JRadioButtonMenuItem mm = new JRadioButtonMenuItem((String)entry.getKey());
            mm.setSelected(currentArcDirection == entry.getValue());
            mm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    for (Track track : tracks) {
                        if (!(track instanceof BasePairTrack)) continue;
                        ((BasePairTrack)track).getRenderOptions().setArcDirection((BasePairTrack.ArcDirection)((Object)entry.getValue()));
                    }
                    TrackMenuUtils.refresh();
                }
            });
            group.add(mm);
            menu.add(mm);
        }
        menu.addSeparator();
    }

    private static JMenuItem getFeatureToGeneListItem(Track t) {
        JMenuItem mi = new JMenuItem("Use as loci list");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        return mi;
    }

    public static JMenuItem getExportFeatures(final Collection<Track> tracks, final ReferenceFrame frame) {
        Track ft = tracks.iterator().next();
        if (tracks.size() != 1) {
            return null;
        }
        JMenuItem exportData = null;
        if (ft instanceof FeatureTrack) {
            exportData = new JMenuItem("Export Features...");
            exportData.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File outFile = FileDialogUtils.chooseFile("Save Visible Data", PreferencesManager.getPreferences().getLastTrackDirectory(), new File("visibleData.bed"), FileDialogUtils.SAVE);
                    TrackMenuUtils.exportVisibleFeatures(outFile.getAbsolutePath(), tracks, frame);
                }
            });
        } else if (ft instanceof AlignmentTrack) {
            exportData = new JMenuItem("Export Alignments...");
            exportData.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File outFile = FileDialogUtils.chooseFile("Save Visible Data", PreferencesManager.getPreferences().getLastTrackDirectory(), new File("visibleData.sam"), FileDialogUtils.SAVE);
                    int countExp = TrackMenuUtils.exportVisibleAlignments(outFile.getAbsolutePath(), tracks, frame);
                    String msg = String.format("%d reads written", countExp);
                    MessageUtils.setStatusBarMessage(msg);
                }
            });
        }
        return exportData;
    }

    static int exportVisibleAlignments(String outPath, Collection<Track> tracks, ReferenceFrame frame) {
        AlignmentTrack alignmentTrack = null;
        for (Track track : tracks) {
            if (!(track instanceof AlignmentTrack)) continue;
            alignmentTrack = (AlignmentTrack)track;
            break;
        }
        if (alignmentTrack == null) {
            return -1;
        }
        File outFile = new File(outPath);
        try {
            AlignmentDataManager dataManager = alignmentTrack.getDataManager();
            ResourceLocator inlocator = dataManager.getLocator();
            Range range = frame.getCurrentRange();
            return SAMWriter.writeAlignmentFilePicard(dataManager, outFile, frame, range.getChr(), range.getStart(), range.getEnd());
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    static void exportVisibleFeatures(String outPath, Collection<Track> tracks, ReferenceFrame frame) {
        PrintWriter writer;
        try {
            writer = new PrintWriter(outPath);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        for (Track track : tracks) {
            if (!(track instanceof FeatureTrack)) continue;
            FeatureTrack fTrack = (FeatureTrack)track;
            String trackLine = fTrack.getExportTrackLine();
            if (trackLine != null) {
                writer.println(trackLine);
            }
            List<Feature> features = fTrack.getVisibleFeatures(frame);
            Range range = frame.getCurrentRange();
            Predicate<Feature> pred = FeatureUtils.getOverlapPredicate(range.getChr(), range.getStart(), range.getEnd());
            features = CollUtils.filter(features, pred);
            IGVBEDCodec codec = new IGVBEDCodec();
            for (Feature feat : features) {
                String featString = codec.encode(feat);
                writer.println(featString);
            }
        }
        writer.flush();
        writer.close();
    }

    public static void addSharedItems(JPopupMenu menu, final Collection<Track> tracks, boolean hasFeatureTracks, boolean hasCoverageTracks) {
        menu.add(TrackMenuUtils.getTrackRenameItem(tracks));
        String colorLabel = hasFeatureTracks || hasCoverageTracks ? "Change Track Color..." : "Change Track Color (Positive Values)...";
        JMenuItem item = new JMenuItem(colorLabel);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrackMenuUtils.changeTrackColor(tracks);
            }
        });
        menu.add(item);
        if (!hasFeatureTracks && !hasCoverageTracks) {
            item = new JMenuItem("Change Track Color (Negative Values)...");
            item.setToolTipText("Change the alternate track color.  This color is used when graphing negative values");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TrackMenuUtils.changeAltTrackColor(tracks);
                }
            });
            menu.add(item);
        }
        menu.add(TrackMenuUtils.getChangeTrackHeightItem(tracks));
        menu.add(TrackMenuUtils.getChangeFontSizeItem(tracks));
    }

    private static void changeStatType(String statType, Collection<Track> selectedTracks) {
        for (Track track : selectedTracks) {
            track.setWindowFunction(WindowFunction.valueOf(statType));
        }
        TrackMenuUtils.refresh();
    }

    public static JMenuItem getTrackRenameItem(final Collection<Track> selectedTracks) {
        JMenuItem item = new JMenuItem("Rename Track...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UIUtilities.invokeOnEventThread(new Runnable(){

                    @Override
                    public void run() {
                        TrackMenuUtils.renameTrack(selectedTracks);
                    }
                });
            }
        });
        if (selectedTracks.size() > 1) {
            item.setEnabled(false);
        }
        return item;
    }

    private static JMenuItem getHeatmapScaleItem(final Collection<Track> selectedTracks) {
        JMenuItem item = new JMenuItem("Set Heatmap Scale...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (selectedTracks.size() > 0) {
                    ContinuousColorScale colorScale = ((Track)selectedTracks.iterator().next()).getColorScale();
                    HeatmapScaleDialog dlg = new HeatmapScaleDialog(IGV.getMainFrame(), colorScale);
                    dlg.setVisible(true);
                    if (!dlg.isCanceled()) {
                        colorScale = dlg.getColorScale();
                        for (Track track : selectedTracks) {
                            track.setColorScale(colorScale);
                        }
                        IGV.getInstance().repaint();
                    }
                }
            }
        });
        return item;
    }

    public static JMenuItem getDataRangeItem(final Collection<Track> selectedTracks) {
        JMenuItem item = new JMenuItem("Set Data Range...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (selectedTracks.size() > 0) {
                    DataRange prevAxisDefinition = DataRange.getFromTracks(selectedTracks);
                    DataRangeDialog dlg = new DataRangeDialog(IGV.getMainFrame(), prevAxisDefinition);
                    dlg.setVisible(true);
                    if (!dlg.isCanceled()) {
                        float min = Math.min(dlg.getMax(), dlg.getMin());
                        float max = Math.max(dlg.getMin(), dlg.getMax());
                        float mid = dlg.getBase();
                        mid = Math.max(min, Math.min(mid, max));
                        DataRange axisDefinition = new DataRange(dlg.getMin(), mid, dlg.getMax(), prevAxisDefinition.isDrawBaseline(), dlg.isLog());
                        for (Track track : selectedTracks) {
                            track.setDataRange(axisDefinition);
                            track.setAutoScale(false);
                            track.removeAttribute("AUTOSCALE GROUP");
                        }
                        IGV.getInstance().repaint();
                    }
                }
            }
        });
        return item;
    }

    private static JMenuItem getDrawBorderItem() {
        final JCheckBoxMenuItem drawBorderItem = new JCheckBoxMenuItem("Draw borders");
        drawBorderItem.setSelected(FeatureTrack.isDrawBorder());
        drawBorderItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureTrack.setDrawBorder(drawBorderItem.isSelected());
                IGV.getInstance().revalidateTrackPanels();
            }
        });
        return drawBorderItem;
    }

    public static JMenuItem getLogScaleItem(final Collection<Track> selectedTracks) {
        final JCheckBoxMenuItem logScaleItem = new JCheckBoxMenuItem("Log scale");
        boolean logScale = selectedTracks.iterator().next().getDataRange().isLog();
        logScaleItem.setSelected(logScale);
        logScaleItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataRange.Type scaleType = logScaleItem.isSelected() ? DataRange.Type.LOG : DataRange.Type.LINEAR;
                for (Track t : selectedTracks) {
                    t.getDataRange().setType(scaleType);
                }
                IGV.getInstance().revalidateTrackPanels();
            }
        });
        return logScaleItem;
    }

    private static JMenuItem getAutoscaleItem(final Collection<Track> selectedTracks) {
        final JCheckBoxMenuItem autoscaleItem = new JCheckBoxMenuItem("Autoscale");
        if (selectedTracks.size() == 0) {
            autoscaleItem.setEnabled(false);
        } else {
            boolean autoScale = TrackMenuUtils.checkAutoscale(selectedTracks);
            autoscaleItem.setSelected(autoScale);
            autoscaleItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    boolean autoScale = autoscaleItem.isSelected();
                    for (Track t : selectedTracks) {
                        t.setAutoScale(autoScale);
                        if (!autoScale) continue;
                        t.removeAttribute("AUTOSCALE GROUP");
                    }
                    IGV.getInstance().repaint();
                }
            });
        }
        return autoscaleItem;
    }

    private static JMenuItem getGroupAutoscaleItem(final Collection<Track> selectedTracks) {
        JMenuItem autoscaleItem = new JMenuItem("Group Autoscale");
        autoscaleItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int nextAutoscaleGroup = IGV.getInstance().getSession().getNextAutoscaleGroup();
                for (Track t : selectedTracks) {
                    t.setAttributeValue("AUTOSCALE GROUP", "" + nextAutoscaleGroup);
                    t.setAutoScale(false);
                }
                PreferencesManager.getPreferences().setShowAttributeView(true);
                IGV.getInstance().getMainPanel().invalidate();
                IGV.getInstance().doRefresh();
            }
        });
        return autoscaleItem;
    }

    private static boolean checkAutoscale(Collection<Track> selectedTracks) {
        boolean autoScale = false;
        for (Track t : selectedTracks) {
            if (!t.getAutoScale()) continue;
            autoScale = true;
            break;
        }
        return autoScale;
    }

    public static JMenuItem getShowDataRangeItem(final Collection<Track> selectedTracks) {
        final JCheckBoxMenuItem item = new JCheckBoxMenuItem("Show Data Range");
        if (selectedTracks.size() == 0) {
            item.setEnabled(false);
        } else {
            boolean showDataRange = true;
            for (Track t : selectedTracks) {
                if (t.isShowDataRange()) continue;
                showDataRange = false;
                break;
            }
            item.setSelected(showDataRange);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    boolean showDataRange = item.isSelected();
                    for (Track t : selectedTracks) {
                        if (!(t instanceof DataTrack)) continue;
                        ((DataTrack)t).setShowDataRange(showDataRange);
                    }
                    IGV.getInstance().revalidateTrackPanels();
                }
            });
        }
        return item;
    }

    public static void addDisplayModeItems(final Collection<Track> tracks, JPopupMenu menu) {
        HashMap<Track.DisplayMode, Integer> counts = new HashMap<Track.DisplayMode, Integer>(Track.DisplayMode.values().length);
        Track.DisplayMode currentMode = null;
        for (Track track : tracks) {
            Track.DisplayMode displayMode = track.getDisplayMode();
            if (counts.containsKey((Object)displayMode)) {
                counts.put(displayMode, (Integer)counts.get((Object)displayMode) + 1);
                continue;
            }
            counts.put(displayMode, 1);
        }
        int maxCount = -1;
        for (Map.Entry entry : counts.entrySet()) {
            if ((Integer)entry.getValue() <= maxCount) continue;
            currentMode = (Track.DisplayMode)((Object)entry.getKey());
            maxCount = (Integer)entry.getValue();
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        LinkedHashMap<String, Track.DisplayMode> linkedHashMap = new LinkedHashMap<String, Track.DisplayMode>(4);
        linkedHashMap.put("Collapsed", Track.DisplayMode.COLLAPSED);
        linkedHashMap.put("Expanded", Track.DisplayMode.EXPANDED);
        linkedHashMap.put("Squished", Track.DisplayMode.SQUISHED);
        for (final Map.Entry entry : linkedHashMap.entrySet()) {
            JRadioButtonMenuItem mm = new JRadioButtonMenuItem((String)entry.getKey());
            mm.setSelected(currentMode == entry.getValue());
            mm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TrackMenuUtils.setTrackDisplayMode(tracks, (Track.DisplayMode)((Object)entry.getValue()));
                    TrackMenuUtils.refresh();
                }
            });
            buttonGroup.add(mm);
            menu.add(mm);
        }
    }

    private static void setTrackDisplayMode(Collection<Track> tracks, Track.DisplayMode mode) {
        for (Track t : tracks) {
            t.setDisplayMode(mode);
        }
    }

    public static JMenuItem getRemoveMenuItem(final Collection<Track> selectedTracks) {
        boolean multiple = selectedTracks.size() > 1;
        JMenuItem item = new JMenuItem("Remove Track" + (multiple ? "s" : ""));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrackMenuUtils.removeTracksAction(selectedTracks);
            }
        });
        return item;
    }

    public static void removeTracksAction(Collection<Track> selectedTracks) {
        if (selectedTracks.isEmpty()) {
            return;
        }
        IGV.getInstance().removeTracks(selectedTracks);
        IGV.getInstance().doRefresh();
    }

    public static void changeRenderer(Collection<Track> selectedTracks, Class rendererClass) {
        for (Track track : selectedTracks) {
            track.setRendererClass(rendererClass);
        }
        TrackMenuUtils.refresh();
    }

    public static void renameTrack(Collection<Track> selectedTracks) {
        if (selectedTracks.isEmpty()) {
            return;
        }
        Track t = selectedTracks.iterator().next();
        String newName = JOptionPane.showInputDialog(IGV.getMainFrame(), "Enter new name: ", t.getName());
        if (newName == null || newName.trim() == "") {
            return;
        }
        t.setName(newName);
        TrackMenuUtils.refresh();
    }

    public static void changeTrackHeight(Collection<Track> selectedTracks) {
        if (selectedTracks.isEmpty()) {
            return;
        }
        String parameter = "Track height";
        Integer value = TrackMenuUtils.getIntegerInput("Track height", TrackMenuUtils.getRepresentativeTrackHeight(selectedTracks));
        if (value == null) {
            return;
        }
        value = Math.max(0, value);
        for (Track track : selectedTracks) {
            track.setHeight(value, true);
        }
        TrackMenuUtils.refresh();
    }

    public static void changeFeatureVisibilityWindow(Collection<Track> selectedTracks) {
        ArrayList<Track> featureTracks = new ArrayList<Track>(selectedTracks.size());
        for (Track t : selectedTracks) {
            if (!(t instanceof FeatureTrack)) continue;
            featureTracks.add(t);
        }
        if (featureTracks.isEmpty()) {
            return;
        }
        int origValue = ((Track)featureTracks.iterator().next()).getVisibilityWindow();
        double origValueKB = (double)origValue / 1000.0;
        Double value = TrackMenuUtils.getDoubleInput("Enter visibility window in kilo-bases.  To load all data enter zero.", origValueKB);
        if (value == null) {
            return;
        }
        for (Track track : featureTracks) {
            track.setVisibilityWindow((int)(value * 1000.0));
        }
        TrackMenuUtils.refresh();
    }

    public static void changeFontSize(Collection<Track> selectedTracks) {
        if (selectedTracks.isEmpty()) {
            return;
        }
        String parameter = "Font size";
        int defaultValue = selectedTracks.iterator().next().getFontSize();
        Integer value = TrackMenuUtils.getIntegerInput("Font size", defaultValue);
        if (value == null) {
            return;
        }
        for (Track track : selectedTracks) {
            track.setFontSize(value);
        }
        TrackMenuUtils.refresh();
    }

    public static Integer getIntegerInput(String parameter, int value) {
        String strValue;
        while ((strValue = JOptionPane.showInputDialog(IGV.getMainFrame(), parameter + ": ", String.valueOf(value))) != null && !strValue.trim().equals("")) {
            try {
                value = Integer.parseInt(strValue);
                return value;
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(IGV.getMainFrame(), parameter + " must be an integer number.");
                continue;
            }
            break;
        }
        return null;
    }

    public static Double getDoubleInput(String parameter, double value) {
        String strValue;
        while ((strValue = JOptionPane.showInputDialog(IGV.getMainFrame(), parameter + ": ", String.valueOf(value))) != null && !strValue.trim().equals("")) {
            try {
                value = Double.parseDouble(strValue);
                return value;
            }
            catch (NumberFormatException numberFormatException) {
                MessageUtils.showMessage(parameter + " must be a number.");
                continue;
            }
            break;
        }
        return null;
    }

    public static void changeTrackColor(Collection<Track> selectedTracks) {
        if (selectedTracks.isEmpty()) {
            return;
        }
        Color currentSelection = selectedTracks.iterator().next().getColor();
        Color color = UIUtilities.showColorChooserDialog("Select Track Color (Positive Values)", currentSelection);
        if (color == null) {
            return;
        }
        for (Track track : selectedTracks) {
            track.setColor(ColorUtilities.modifyAlpha(color, currentSelection.getAlpha()));
        }
        TrackMenuUtils.refresh();
    }

    public static void changeAltTrackColor(Collection<Track> selectedTracks) {
        if (selectedTracks.isEmpty()) {
            return;
        }
        Color currentSelection = selectedTracks.iterator().next().getColor();
        Color color = UIUtilities.showColorChooserDialog("Select Track Color (Negative Values)", currentSelection);
        if (color == null) {
            return;
        }
        for (Track track : selectedTracks) {
            track.setAltColor(ColorUtilities.modifyAlpha(color, currentSelection.getAlpha()));
        }
        TrackMenuUtils.refresh();
    }

    public static void changeBasePairTrackColor(List<BasePairTrack> tracks, Color currentColor, String currentLabel) {
        if (tracks.isEmpty()) {
            return;
        }
        Color newColor = UIUtilities.showColorChooserDialog("Select Arc Color (" + currentLabel + ")", currentColor);
        if (newColor == null) {
            return;
        }
        for (BasePairTrack t : tracks) {
            t.getRenderOptions().changeColor(currentColor, currentLabel, newColor);
        }
        TrackMenuUtils.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportTrackNames(Collection<Track> selectedTracks) {
        if (selectedTracks.isEmpty()) {
            return;
        }
        File file = FileDialogUtils.chooseFile("Export track names", PreferencesManager.getPreferences().getLastTrackDirectory(), new File("trackNames.tab"), FileDialogUtils.SAVE);
        if (file == null) {
            return;
        }
        try (PrintWriter pw = null;){
            pw = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            List<String> attributes = AttributeManager.getInstance().getVisibleAttributes();
            pw.print("Name");
            for (String att : attributes) {
                pw.print("\t" + att);
            }
            pw.println();
            for (Track track : selectedTracks) {
                pw.print(track.getName());
                for (String att : attributes) {
                    String val = track.getAttributeValue(att);
                    pw.print("\t" + (val == null ? "" : val));
                }
                pw.println();
            }
        }
    }

    public static JMenuItem getCopyDetailsItem(final Feature f, final TrackClickEvent evt) {
        JMenuItem item = new JMenuItem("Copy Details to Clipboard");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReferenceFrame frame = evt.getFrame();
                int mouseX = evt.getMouseEvent().getX();
                double location = frame.getChromosomePosition(mouseX);
                if (f instanceof IGVFeature) {
                    Object details = f.getChr() + ":" + (f.getStart() + 1) + "-" + f.getEnd() + System.getProperty("line.separator") + System.getProperty("line.separator");
                    String valueString = ((IGVFeature)f).getValueString(location, mouseX, null);
                    if (details != null) {
                        details = (String)details + valueString;
                        details = ((String)details).replace("<br>", System.getProperty("line.separator"));
                        details = ((String)details).replace("<br/>", System.getProperty("line.separator"));
                        details = ((String)details).replace("<b>", "");
                        details = ((String)details).replace("</b>", "");
                        details = ((String)details).replace("&nbsp;", " ");
                        details = ((String)details).replace("<hr>", System.getProperty("line.separator") + "--------------------------" + System.getProperty("line.separator"));
                        StringUtils.copyTextToClipboard((String)details);
                    }
                }
            }
        });
        return item;
    }

    public static JMenuItem getCopySequenceItem(final Feature f) {
        final Strand strand = f instanceof IGVFeature ? ((IGVFeature)f).getStrand() : Strand.NONE;
        JMenuItem item = new JMenuItem("Copy Sequence");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Genome genome = GenomeManager.getInstance().getCurrentGenome();
                IGV.copySequenceToClipboard(genome, f.getChr(), f.getStart(), f.getEnd(), strand);
            }
        });
        return item;
    }

    public static JMenuItem getExtendViewItem(final String featureName, final Feature f, final Range r) {
        JMenuItem item = new JMenuItem("ExtView");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtendViewClient.postExtendView(featureName, f.getStart(), f.getEnd(), r.getChr(), r.getStart(), r.getEnd());
            }
        });
        return item;
    }

    public static JMenuItem getBlatItem(final Feature f) {
        JMenuItem item = new JMenuItem("Blat Sequence");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Strand strand = f instanceof IGVFeature ? ((IGVFeature)f).getStrand() : Strand.NONE;
                BlatClient.doBlatQuery(f.getChr(), f.getStart(), f.getEnd(), strand);
            }
        });
        return item;
    }

    public static int getRepresentativeTrackHeight(Collection<Track> tracks) {
        double[] heights = new double[tracks.size()];
        int i = 0;
        for (Track track : tracks) {
            heights[i] = track.getHeight();
            ++i;
        }
        int medianTrackHeight = (int)Math.round(StatUtils.percentile((double[])heights, (double)50.0));
        if (medianTrackHeight > 0) {
            return medianTrackHeight;
        }
        return PreferencesManager.getPreferences().getAsInt("15");
    }

    public static void refresh() {
        if (IGV.hasInstance()) {
            IGV.getInstance().showLoadedTrackCount();
            IGV.getInstance().doRefresh();
        }
    }

    public static JMenuItem getChangeTrackHeightItem(final Collection<Track> selectedTracks) {
        JMenuItem item = new JMenuItem("Change Track Height...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrackMenuUtils.changeTrackHeight(selectedTracks);
            }
        });
        return item;
    }

    public static JMenuItem getChangeFeatureWindow(final Collection<Track> selectedTracks) {
        JMenuItem item = new JMenuItem("Set Feature Visibility Window...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrackMenuUtils.changeFeatureVisibilityWindow(selectedTracks);
            }
        });
        return item;
    }

    public static JMenuItem getChangeFontSizeItem(final Collection<Track> selectedTracks) {
        JMenuItem item = new JMenuItem("Change Font Size...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TrackMenuUtils.changeFontSize(selectedTracks);
            }
        });
        return item;
    }

    public static JMenuItem getShowSortFramesItem(final Track track) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Sort frames");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        FrameManager.sortFrames(track);
                        IGV.getInstance().resetFrames();
                    }
                };
                LongRunningTask.submit(runnable);
            }
        });
        return item;
    }
}

