/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.genome;

import java.io.File;
import java.io.IOException;
import org.broad.igv.feature.genome.GenomeDownloadUtils;
import org.broad.igv.feature.genome.load.GenomeConfig;
import org.broad.igv.feature.genome.load.JsonGenomeLoader;
import org.broad.igv.ui.genome.GenomeListItem;

public class GenomeUtils {
    public static GenomeListItem updateGenome(GenomeListItem hostedItem) throws IOException {
        String id = hostedItem.getId();
        String path = hostedItem.getPath();
        if (path.endsWith(".json")) {
            JsonGenomeLoader loader = new JsonGenomeLoader(hostedItem.getPath());
            GenomeConfig config = loader.loadGenomeConfig();
            File localFile = GenomeDownloadUtils.downloadGenome(config, false, false);
            if (localFile != null) {
                return new GenomeListItem(hostedItem.getDisplayableName(), localFile.getAbsolutePath(), id);
            }
            return new GenomeListItem(hostedItem.getDisplayableName(), hostedItem.getPath(), id);
        }
        return hostedItem;
    }

    public static boolean isDeprecated(GenomeConfig config) {
        if (config.twoBitURL != null && !config.twoBitURL.isEmpty()) {
            return false;
        }
        String fastaURL = config.fastaURL;
        return GenomeUtils.isDeprecated(fastaURL);
    }

    public static boolean isDeprecated(String fastaURL) {
        return fastaURL.contains("amazonaws") && (fastaURL.contains("igv.org.genomes") || fastaURL.contains("igv.broadinstitute.org") || fastaURL.contains("igv-genepattern-org"));
    }
}

