/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.genome;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.table.TableStringConverter;
import org.broad.igv.ui.genome.GenomeListItem;

public class GenomeTableModel
extends AbstractTableModel {
    private String[] columnHeadings;
    private List<GenomeListItem> records;
    private final TableRowSorter<GenomeTableModel> sorter;

    public GenomeTableModel(String[] headers, List<GenomeListItem> records) {
        this.records = records;
        this.columnHeadings = headers;
        this.sorter = new TableRowSorter<GenomeTableModel>(this);
        this.sorter.setStringConverter(new TableStringConverter(this){

            @Override
            public String toString(TableModel model, int row, int column) {
                Object value = model.getValueAt(row, column);
                return value == null ? "" : value.toString();
            }
        });
    }

    public TableRowSorter<GenomeTableModel> getSorter() {
        return this.sorter;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnHeadings[column];
    }

    @Override
    public int getRowCount() {
        return this.records.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnHeadings.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.records.size() || columnIndex >= this.columnHeadings.length) {
            return null;
        }
        GenomeListItem record = this.records.get(rowIndex);
        String att = this.columnHeadings[columnIndex];
        return record.getAttributeValue(att);
    }

    public List<GenomeListItem> getRecords() {
        return this.records;
    }
}

