/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ucsc.bb;

import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.broad.igv.data.BasicScore;
import org.broad.igv.feature.FeatureType;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.ChromAlias;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ucsc.BPTree;
import org.broad.igv.ucsc.Trix;
import org.broad.igv.ucsc.bb.BBHeader;
import org.broad.igv.ucsc.bb.BBTotalSummary;
import org.broad.igv.ucsc.bb.BBUtils;
import org.broad.igv.ucsc.bb.BBZoomHeader;
import org.broad.igv.ucsc.bb.BedData;
import org.broad.igv.ucsc.bb.ChromTree;
import org.broad.igv.ucsc.bb.RPTree;
import org.broad.igv.ucsc.bb.WigDatum;
import org.broad.igv.ucsc.bb.codecs.BBCodec;
import org.broad.igv.ucsc.bb.codecs.BBCodecFactory;
import org.broad.igv.ucsc.twobit.UnsignedByteBuffer;
import org.broad.igv.ucsc.twobit.UnsignedByteBufferImpl;
import org.broad.igv.util.CompressionUtils;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;

public class BBFile {
    static Logger log = LogManager.getLogger(BBFile.class);
    public static final int BBFILE_HEADER_SIZE = 64;
    public static final long BIGWIG_MAGIC = 2291137574L;
    public static final long BIGBED_MAGIC = 2273964779L;
    public static final int BBFILE_EXTENDED_HEADER_HEADER_SIZE = 64;
    private Trix trix;
    private String autosql;
    private ChromTree chromTree;
    private double featureDensity;
    private Map<String, String> chrAliasTable;
    private BBTotalSummary totalSummary;
    private BPTree[] _searchTrees;
    private Map<Long, RPTree> rTreeCache;
    private BBCodec bedCodec;
    private String path;
    private Type type;
    private FeatureType featureType;
    private BBHeader header = null;
    private BBZoomHeader[] zoomHeaders;
    private ByteOrder byteOrder;
    private Genome genome;
    private byte[] _preloadBytes;

    public BBFile(String path, Genome genome) throws IOException {
        this.path = path;
        this.genome = genome;
        this.chrAliasTable = new HashMap<String, String>();
        this.rTreeCache = new HashMap<Long, RPTree>();
        this.init();
    }

    public void preload() throws IOException {
        if (FileUtils.isRemote(this.path)) {
            this._preloadBytes = HttpUtils.getInstance().getContentsAsBytes(new URL(this.path), null);
        }
    }

    public BBFile(String path, Genome genome, String trixPath) throws IOException {
        this(path, genome);
        this.trix = new Trix(trixPath + "x", trixPath);
    }

    void init() throws IOException {
        this.header = this.readHeader();
    }

    public int getChromosomeCount() {
        return (int)this.chromTree.getItemCount();
    }

    public Type getType() {
        return this.type;
    }

    public FeatureType getFeatureType() {
        if (this.featureType == null) {
            if (this.isBigWigFile()) {
                this.featureType = FeatureType.WIG;
            } else if (this.isBigBedFile()) {
                String as = this.getAutoSQL();
                if (as != null) {
                    BBUtils.ASTable astable = BBUtils.parseAutosql(this.autosql);
                    if (astable != null && "bigRmskBed".equals(astable.name)) {
                        this.featureType = FeatureType.RMSK;
                    } else if (astable != null && astable.name.toLowerCase().contains("interact")) {
                        this.featureType = FeatureType.INTERACT;
                    }
                }
                if (this.featureType == null) {
                    this.featureType = FeatureType.BED;
                }
            }
        }
        return this.featureType;
    }

    public BBHeader getHeader() {
        return this.header;
    }

    public Genome getGenome() {
        return this.genome;
    }

    public boolean isBigWigFile() {
        return this.type == Type.BIGWIG;
    }

    public boolean isBigBedFile() {
        return this.type == Type.BIGBED;
    }

    public double getFeatureDensity() {
        return this.featureDensity;
    }

    public String getAutoSQL() {
        return this.autosql;
    }

    BBHeader readHeader() throws IOException {
        ByteOrder order = ByteOrder.LITTLE_ENDIAN;
        UnsignedByteBuffer buffer = this.loadBinaryBuffer(this.path, order, 0L, 64);
        long magic = buffer.getUInt();
        if (magic == 2291137574L) {
            this.type = Type.BIGWIG;
        } else if (magic == 2273964779L) {
            this.type = Type.BIGBED;
        } else {
            order = ByteOrder.BIG_ENDIAN;
            buffer = this.loadBinaryBuffer(this.path, order, 0L, 64);
            magic = buffer.getUInt();
            if (magic == 2291137574L) {
                this.type = Type.BIGWIG;
            } else if (magic == 2273964779L) {
                this.type = Type.BIGBED;
            } else {
                throw new RuntimeException("Bad magic number " + magic);
            }
        }
        this.byteOrder = order;
        BBHeader header = new BBHeader();
        header.version = buffer.getUShort();
        header.nZoomLevels = buffer.getUShort();
        header.chromTreeOffset = buffer.getLong();
        header.fullDataOffset = buffer.getLong();
        header.fullIndexOffset = buffer.getLong();
        header.fieldCount = buffer.getUShort();
        header.definedFieldCount = buffer.getUShort();
        header.autoSqlOffset = buffer.getLong();
        header.totalSummaryOffset = buffer.getLong();
        header.uncompressBuffSize = buffer.getInt();
        header.extensionOffset = buffer.getLong();
        this.header = header;
        int size = (int)(header.totalSummaryOffset > 0L ? header.totalSummaryOffset - 64L + 40L : Math.min(header.fullDataOffset, header.chromTreeOffset) - 64L);
        buffer = this.loadBinaryBuffer(this.path, order, 64L, size);
        this.zoomHeaders = new BBZoomHeader[header.nZoomLevels];
        for (int i = 0; i < header.nZoomLevels; ++i) {
            BBZoomHeader zlh = new BBZoomHeader();
            zlh.reductionLevel = buffer.getUInt();
            zlh.reserved = buffer.getInt();
            zlh.dataOffset = buffer.getLong();
            zlh.indexOffset = buffer.getLong();
            this.zoomHeaders[i] = zlh;
        }
        Arrays.sort(this.zoomHeaders, (o1, o2) -> (int)(o2.reductionLevel - o1.reductionLevel));
        int startOffset = 64;
        if (header.autoSqlOffset > 0L) {
            buffer.position((int)(header.autoSqlOffset - 64L));
            this.autosql = buffer.getString();
        }
        if (header.version > 1 && header.totalSummaryOffset > 0L) {
            buffer.position((int)(header.totalSummaryOffset - 64L));
            this.totalSummary = BBTotalSummary.parseSummary(buffer);
        }
        this.chromTree = new ChromTree(this.path, this.header.chromTreeOffset);
        if (this.type == Type.BIGBED) {
            buffer = this.loadBinaryBuffer(this.path, order, header.fullDataOffset, 4);
            header.dataCount = buffer.getUInt();
            this.featureDensity = (double)header.dataCount / (double)this.chromTree.estimateGenomeSize();
            this.bedCodec = BBCodecFactory.getCodec(this.autosql, header.definedFieldCount);
        }
        if (header.extensionOffset > 0L) {
            this.loadExtendedHeader(header.extensionOffset);
        }
        return header;
    }

    void loadExtendedHeader(long offset) throws IOException {
        UnsignedByteBuffer binaryParser = this.loadBinaryBuffer(this.path, this.byteOrder, offset, 64);
        int extensionSize = binaryParser.getUShort();
        int extraIndexCount = binaryParser.getUShort();
        long extraIndexListOffset = binaryParser.getLong();
        if (extraIndexCount == 0) {
            return;
        }
        int sz = extraIndexCount * 56;
        binaryParser = this.loadBinaryBuffer(this.path, this.byteOrder, extraIndexListOffset, sz);
        long[] indexOffset = new long[extraIndexCount];
        for (int i = 0; i < extraIndexCount; ++i) {
            int type = binaryParser.getUShort();
            int fc = binaryParser.getUShort();
            indexOffset[i] = binaryParser.getLong();
            binaryParser.getInt();
            for (int j = 0; j < fc; ++j) {
                int fieldId = binaryParser.getUShort();
                binaryParser.getUShort();
            }
        }
        this.header.extraIndexCount = extraIndexCount;
        this.header.extraIndexOffsets = indexOffset;
    }

    List<byte[]> getLeafChunks(int chrIdx1, int bpStart, int chrIdx2, int bpEnd, long treeOffset) throws IOException {
        RPTree rpTree;
        if (this.header == null) {
            this.header = this.readHeader();
        }
        if ((rpTree = this.rTreeCache.get(treeOffset)) == null) {
            rpTree = RPTree.loadTree(this.path, treeOffset);
            this.rTreeCache.put(treeOffset, rpTree);
        }
        ArrayList<byte[]> leafChunks = new ArrayList<byte[]>();
        List<RPTree.Item> leafItems = rpTree.findLeafItemsOverlapping(chrIdx1, bpStart, chrIdx2, bpEnd);
        if (leafItems != null && leafItems.size() > 0) {
            long start = Long.MAX_VALUE;
            long end = 0L;
            for (RPTree.Item item : leafItems) {
                start = Math.min(start, item.dataOffset);
                end = Math.max(end, item.dataOffset + item.dataSize);
            }
            int size = (int)(end - start);
            int uncompressBufSize = this.header.uncompressBuffSize;
            byte[] buffer = this.getBytes(start, size);
            for (RPTree.Item item : leafItems) {
                int offset = (int)(item.dataOffset - start);
                int end_ = (int)((long)offset + item.dataSize);
                byte[] itemBuffer = leafItems.size() == 1 ? buffer : Arrays.copyOfRange(buffer, offset, end_);
                leafChunks.add(itemBuffer);
            }
        }
        return leafChunks;
    }

    Integer getIdForChr(String chr) throws IOException {
        Integer chrIdx;
        if (this.chrAliasTable.get(chr) != null) {
            chr = this.chrAliasTable.get(chr);
        }
        if ((chrIdx = this.chromTree.getIdForName(chr)) == null && this.genome != null) {
            String alias = null;
            ChromAlias aliasRecord = this.genome.getAliasRecord(chr);
            if (aliasRecord != null) {
                for (String v : aliasRecord.values()) {
                    chrIdx = this.chromTree.getIdForName(v);
                    if (chrIdx == null) continue;
                    alias = v;
                    break;
                }
            }
            this.chrAliasTable.put(chr, alias);
        }
        return chrIdx;
    }

    BBZoomHeader zoomLevelForScale(double bpPerPixel) {
        return this.zoomLevelForScale(bpPerPixel, 2);
    }

    BBZoomHeader zoomLevelForScale(double bpPerPixel, int tolerance) {
        if (this.zoomHeaders.length == 0) {
            return null;
        }
        for (BBZoomHeader zl : this.zoomHeaders) {
            if (!((double)zl.reductionLevel < bpPerPixel)) continue;
            return zl;
        }
        BBZoomHeader lastLevel = this.zoomHeaders[this.zoomHeaders.length - 1];
        return (double)(lastLevel.reductionLevel / (long)tolerance) < bpPerPixel ? lastLevel : null;
    }

    public boolean isSearchable() {
        return this.header.extraIndexCount > 0;
    }

    public List<IGVFeature> search(String term) throws IOException {
        if (this.header == null) {
            this.readHeader();
        }
        if (this.header.extraIndexCount == 0) {
            return null;
        }
        long[] region = this.searchForRegions(term);
        if (region != null) {
            List<IGVFeature> results;
            long start = region[0];
            int size = (int)region[1];
            byte[] buffer = this.getBytes(start, size);
            List<IGVFeature> features = this.decodeFeatures(null, buffer, -1, -1, -1);
            HashSet<String> matchingNames = new HashSet<String>();
            String termLower = term.toLowerCase();
            matchingNames.add(termLower);
            if (this.trix != null && (results = this.trix.search(termLower)) != null && results.containsKey(termLower)) {
                matchingNames.addAll(Arrays.stream((String[])results.get(termLower)).map(String::toLowerCase).toList());
            }
            if ((results = features.stream().filter(f -> matchingNames.contains(f.getName().toLowerCase())).toList()).isEmpty()) {
                results = features.stream().filter(f -> f.getAttributes() != null && f.getAttributes().values().stream().anyMatch(v -> v.toLowerCase().contains(termLower))).toList();
            }
            return results;
        }
        return null;
    }

    List<IGVFeature> decodeFeatures(String chr, byte[] buffer, int chrIdx, int start, int end) {
        ArrayList<IGVFeature> features = new ArrayList<IGVFeature>();
        byte[] uncompressed = this.header.uncompressBuffSize > 0 ? new CompressionUtils().decompress(buffer, this.header.uncompressBuffSize) : buffer;
        UnsignedByteBufferImpl bb = UnsignedByteBufferImpl.wrap(uncompressed, this.byteOrder);
        while (bb.remaining() > 0) {
            int chromId = bb.getInt();
            int chromStart = bb.getInt();
            int chromEnd = bb.getInt();
            String restOfFields = bb.getString();
            if (chrIdx > 0) {
                if (chromId < chrIdx || chromId == chrIdx && chromEnd < start) continue;
                if (chromId > chrIdx || chromId == chrIdx && chromStart >= end) break;
            }
            if (chr == null) {
                chr = this.chromTree.getNameForId(chromId);
            }
            if (chr == null) continue;
            BedData bedData = new BedData(chr, chromStart, chromEnd, restOfFields);
            IGVFeature feature = this.bedCodec.decode(bedData);
            features.add(feature);
        }
        return features;
    }

    List<LocusScore> decodeZoomData(String chr, byte[] buffer, int chrIdx, int start, int end, WindowFunction windowFunction, List<LocusScore> features) {
        boolean decodeChr = chr == null;
        byte[] uncompressed = this.header.uncompressBuffSize > 0 ? new CompressionUtils().decompress(buffer, this.header.uncompressBuffSize) : buffer;
        HashSet<Integer> unknownIds = new HashSet<Integer>();
        UnsignedByteBufferImpl bb = UnsignedByteBufferImpl.wrap(uncompressed, this.byteOrder);
        while (bb.remaining() > 0) {
            int chromId = bb.getInt();
            int chromStart = bb.getInt();
            int chromEnd = bb.getInt();
            int validCount = bb.getInt();
            float minVal = bb.getFloat();
            float maxVal = bb.getFloat();
            float sumData = bb.getFloat();
            float sumSquares = bb.getFloat();
            if (chrIdx > 0) {
                if (chromId < chrIdx || chromId == chrIdx && chromEnd < start) continue;
                if (chromId > chrIdx || chromId == chrIdx && chromStart >= end) break;
            }
            if (decodeChr) {
                chr = this.chromTree.getNameForId(chromId);
            }
            if (chr != null) {
                WigDatum feature = new WigDatum(chr, chromStart, chromEnd, switch (windowFunction) {
                    case WindowFunction.min -> minVal;
                    case WindowFunction.max -> maxVal;
                    case WindowFunction.mean -> sumData / (float)validCount;
                    default -> throw new RuntimeException("Unsupported window function: " + String.valueOf(windowFunction));
                });
                features.add(feature);
                continue;
            }
            if (unknownIds.contains(chromId)) continue;
            log.error("Could not find chromosome for id: " + chromId);
            unknownIds.add(chromId);
        }
        return features;
    }

    List<LocusScore> decodeWigData(byte[] buffer, int chrIdx, int start, int end, List<LocusScore> features) {
        int blockStart;
        byte[] uncompressed = this.header.uncompressBuffSize > 0 ? new CompressionUtils().decompress(buffer, this.header.uncompressBuffSize) : buffer;
        UnsignedByteBufferImpl binaryParser = UnsignedByteBufferImpl.wrap(uncompressed, this.byteOrder);
        int chromId = binaryParser.getInt();
        int chromStart = blockStart = binaryParser.getInt();
        int chromEnd = binaryParser.getInt();
        int itemStep = binaryParser.getInt();
        int itemSpan = binaryParser.getInt();
        byte type = binaryParser.get();
        byte reserved = binaryParser.get();
        int itemCount = binaryParser.getUShort();
        if (chromId >= chrIdx && chromId <= chrIdx) {
            int idx = 0;
            while (itemCount-- > 0) {
                float value = Float.POSITIVE_INFINITY;
                switch (type) {
                    case 1: {
                        chromStart = binaryParser.getInt();
                        chromEnd = binaryParser.getInt();
                        value = binaryParser.getFloat();
                        break;
                    }
                    case 2: {
                        chromStart = binaryParser.getInt();
                        value = binaryParser.getFloat();
                        chromEnd = chromStart + itemSpan;
                        break;
                    }
                    case 3: {
                        value = binaryParser.getFloat();
                        chromStart = blockStart + idx * itemStep;
                        chromEnd = chromStart + itemSpan;
                        ++idx;
                    }
                }
                if (chromId < chrIdx || chromId == chrIdx && chromEnd < start) continue;
                if (chromId > chrIdx || chromId == chrIdx && chromStart >= end) break;
                if (!Float.isFinite(value)) continue;
                features.add(new BasicScore(chromStart, chromEnd, value));
            }
        }
        return features;
    }

    private long[] searchForRegions(String term) throws IOException {
        BPTree[] searchTrees = this.getSearchTrees();
        if (searchTrees != null) {
            String termLower;
            Map<String, String[]> trixResults;
            if (this.trix != null && (trixResults = this.trix.search(termLower = term.toLowerCase())) != null && trixResults.containsKey(termLower)) {
                term = trixResults.get(termLower)[0];
            }
            for (BPTree bpTree : searchTrees) {
                long[] result;
                if (bpTree == null || (result = bpTree.searchLongLong(term)) == null) continue;
                return result;
            }
        }
        return null;
    }

    BPTree[] getSearchTrees() throws IOException {
        if (this._searchTrees == null && this.header.extraIndexOffsets != null && this.header.extraIndexOffsets.length > 0) {
            this._searchTrees = new BPTree[this.header.extraIndexOffsets.length];
            int idx = 0;
            for (long offset : this.header.extraIndexOffsets) {
                BPTree bpTree = BPTree.loadBPTree(this.path, offset);
                this._searchTrees[idx++] = bpTree;
            }
        }
        return this._searchTrees;
    }

    UnsignedByteBuffer loadBinaryBuffer(String path, ByteOrder order, long start, int size) throws IOException {
        byte[] bytes = this.getBytes(start, size);
        return UnsignedByteBufferImpl.wrap(bytes, this.byteOrder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBytes(long start, int size) throws IOException {
        if (this._preloadBytes != null) {
            return Arrays.copyOfRange(this._preloadBytes, (int)start, (int)start + size);
        }
        SeekableStream is = null;
        try {
            is = IGVSeekableStreamFactory.getInstance().getStreamFor(this.path);
            byte[] bytes = new byte[size];
            is.seek(start);
            is.readFully(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error("Error closing stream for " + this.path, e);
                }
            }
        }
    }

    public void computeStats() throws IOException {
        long rTreeOffset = this.getHeader().fullIndexOffset;
        double sum = 0.0;
        long basesCovered = 0L;
        double sumSquares = 0.0;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (int idx = 0; idx < this.getChromosomeCount(); ++idx) {
            List<byte[]> chunks = this.getLeafChunks(idx, 0, idx, Integer.MAX_VALUE, rTreeOffset);
            for (byte[] c : chunks) {
                ArrayList<LocusScore> features = new ArrayList<LocusScore>();
                this.decodeWigData(c, idx, 0, Integer.MAX_VALUE, features);
                for (LocusScore score : features) {
                    min = Math.min(min, (double)score.getScore());
                    max = Math.max(max, (double)score.getScore());
                    float val = score.getScore() * (float)(score.getEnd() - score.getStart());
                    sum += (double)val;
                    sumSquares += (double)(score.getScore() * val);
                    basesCovered += (long)(score.getEnd() - score.getStart());
                }
            }
        }
        System.out.println(this.totalSummary.printString());
        double mean = sum / (double)basesCovered;
        System.out.println("basesCovered: " + basesCovered);
        System.out.println("min: " + min);
        System.out.println("max: " + max);
        System.out.println("sum: " + sum);
        System.out.println("sumSquares: " + sumSquares);
        System.out.println("mean: " + mean);
    }

    public static enum Type {
        BIGWIG,
        BIGBED;

    }
}

