/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import org.broad.igv.Globals;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.PSLRecord;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.UCSCCodec;

public class PSLCodec
extends UCSCCodec<IGVFeature> {
    Genome genome;
    boolean keepText;

    public PSLCodec() {
        this((Genome)null);
    }

    public PSLCodec(Genome genome) {
        this(genome, false);
    }

    public PSLCodec(Genome genome, boolean keepText) {
        super(BasicFeature.class);
        this.genome = genome;
        this.keepText = keepText;
    }

    @Override
    public PSLRecord decode(String line) {
        try {
            if (line.trim().length() == 0 || line.startsWith("#") || line.startsWith("track") || line.startsWith("browser") || line.startsWith("psLayout") || line.startsWith("match") || line.startsWith("---")) {
                return null;
            }
            String[] tokens = Globals.tabPattern.split(line);
            return this.decode(tokens);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public PSLRecord decode(String[] tokens) {
        return PSLCodec.getPslRecord(tokens, this.genome);
    }

    public static PSLRecord getPslRecord(String[] tokens, Genome genome) {
        int nTokens = tokens.length;
        if (nTokens < 21) {
            return null;
        }
        int tSize = Integer.parseInt(tokens[14]);
        String chrToken = tokens[13];
        String chr = genome == null ? chrToken : genome.getCanonicalChrName(chrToken);
        int start = Integer.parseInt(tokens[15]);
        String strandString = tokens[8];
        Strand strand = strandString.startsWith("+") ? Strand.POSITIVE : Strand.NEGATIVE;
        boolean gNeg = false;
        if (strandString.length() > 1) {
            gNeg = strandString.charAt(1) == '-';
        }
        PSLRecord f = new PSLRecord();
        f.setName(tokens[9]);
        f.setChr(chr);
        f.setStart(start);
        f.setEnd(Integer.parseInt(tokens[16]));
        f.setStrand(strand);
        int exonCount = Integer.parseInt(tokens[17]);
        String[] exonSizes = tokens[18].split(",");
        String[] startsBuffer = tokens[20].split(",");
        if (startsBuffer.length == exonSizes.length && exonCount == startsBuffer.length) {
            for (int i = 0; i < startsBuffer.length; ++i) {
                int exonSize = Integer.parseInt(exonSizes[i]);
                int exonStart = Integer.parseInt(startsBuffer[i]);
                int exonEnd = exonStart + exonSize;
                Exon exon = new Exon(chr, exonStart, exonEnd, strand);
                f.addExon(exon);
            }
        }
        int match = Integer.parseInt(tokens[0]);
        int misMatch = Integer.parseInt(tokens[1]);
        int repMatch = Integer.parseInt(tokens[2]);
        int ns = Integer.parseInt(tokens[3]);
        int qGapCount = Integer.parseInt(tokens[4]);
        int qGapBases = Integer.parseInt(tokens[5]);
        int tGapCount = Integer.parseInt(tokens[6]);
        int tGapBases = Integer.parseInt(tokens[7]);
        int qSize = Integer.parseInt(tokens[10]);
        int qStart = Integer.parseInt(tokens[11]);
        int qEnd = Integer.parseInt(tokens[12]);
        float score = 1000.0f * (float)(match + repMatch - misMatch - qGapCount - tGapCount) / (float)qSize;
        f.setMatch(match);
        f.setMisMatch(misMatch);
        f.setRepMatch(repMatch);
        f.setNs(ns);
        f.setQGapCount(qGapCount);
        f.setQGapBases(qGapBases);
        f.setTGapCount(tGapCount);
        f.setTGapBases(tGapBases);
        f.setQSize(qSize);
        f.setqStart(qStart);
        f.setqEnd(qEnd);
        f.setBlockQueryStarts(tokens[19]);
        f.setScore(score);
        StringBuffer desc = new StringBuffer();
        desc.append("matches = " + tokens[0]);
        desc.append("<br>");
        desc.append("mismatches = " + tokens[1]);
        desc.append("<br>");
        desc.append("repeat matches = " + tokens[2]);
        desc.append("<br>");
        desc.append("# inserts in query = " + tokens[4]);
        desc.append("<br>");
        desc.append("# inserts in target = " + tokens[6]);
        f.setDescription(desc.toString());
        return f;
    }

    public boolean canDecode(String path) {
        return path.toLowerCase().endsWith(".psl") || path.toLowerCase().endsWith(".psl.gz");
    }
}

