/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome.load;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.load.GenomeConfig;
import org.broad.igv.feature.genome.load.GenomeLoader;
import org.broad.igv.feature.genome.load.TrackConfig;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.ParsingUtils;
import org.json.JSONObject;

public class JsonGenomeLoader
extends GenomeLoader {
    private static Logger log = LogManager.getLogger(JsonGenomeLoader.class);
    private String genomePath;

    public JsonGenomeLoader(String genomePath) {
        this.genomePath = genomePath;
    }

    @Override
    public Genome loadGenome() throws IOException {
        GenomeConfig genomeConfig = this.loadGenomeConfig();
        Genome genome = new Genome(genomeConfig);
        return genome;
    }

    public GenomeConfig loadGenomeConfig() throws IOException {
        try (InputStream is = ParsingUtils.openInputStream(this.genomePath);){
            String jsonString = ParsingUtils.readContentsFromStream(is);
            GenomeConfig genomeConfig = GenomeConfig.fromJson(jsonString);
            this.fixPaths(genomeConfig);
            GenomeConfig genomeConfig2 = genomeConfig;
            return genomeConfig2;
        }
    }

    private GenomeConfig fixPaths(GenomeConfig config) {
        List<TrackConfig> trackConfigs;
        if (config.chromAliasBbURL != null) {
            config.chromAliasBbURL = FileUtils.getAbsolutePath(config.chromAliasBbURL, this.genomePath);
        }
        if (config.twoBitURL != null) {
            config.twoBitURL = FileUtils.getAbsolutePath(config.twoBitURL, this.genomePath);
        }
        if (config.twoBitBptURL != null) {
            config.twoBitBptURL = FileUtils.getAbsolutePath(config.twoBitBptURL, this.genomePath);
        }
        if (config.cytobandBbURL != null) {
            config.cytobandBbURL = FileUtils.getAbsolutePath(config.cytobandBbURL, this.genomePath);
        }
        if (config.chromSizesURL != null) {
            config.chromSizesURL = FileUtils.getAbsolutePath(config.chromSizesURL, this.genomePath);
        }
        if (config.fastaURL != null) {
            config.fastaURL = FileUtils.getAbsolutePath(config.fastaURL, this.genomePath);
        }
        if (config.indexURL != null) {
            config.indexURL = FileUtils.getAbsolutePath(config.indexURL, this.genomePath);
        }
        if (config.gziIndexURL != null) {
            config.gziIndexURL = FileUtils.getAbsolutePath(config.gziIndexURL, this.genomePath);
        }
        if (config.cytobandURL != null) {
            config.cytobandURL = FileUtils.getAbsolutePath(config.cytobandURL, this.genomePath);
        }
        if (config.aliasURL != null) {
            config.aliasURL = FileUtils.getAbsolutePath(config.aliasURL, this.genomePath);
        }
        if (config.chromAliasBbURL != null) {
            config.chromAliasBbURL = FileUtils.getAbsolutePath(config.chromAliasBbURL, this.genomePath);
        }
        if (config.infoURL != null) {
            config.infoURL = FileUtils.getAbsolutePath(config.infoURL, this.genomePath);
        }
        if ((trackConfigs = config.getTrackConfigs()) != null) {
            trackConfigs.forEach(trackConfig -> {
                if (trackConfig.url != null) {
                    trackConfig.url = FileUtils.getAbsolutePath(trackConfig.url, this.genomePath);
                }
                if (trackConfig.indexURL != null) {
                    trackConfig.indexURL = FileUtils.getAbsolutePath(trackConfig.indexURL, this.genomePath);
                }
            });
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenomeDescriptor loadDescriptor() throws IOException {
        try (BufferedReader reader = null;){
            String line;
            reader = ParsingUtils.openBufferedReader(this.genomePath);
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            JSONObject json = new JSONObject(sb.toString());
            String id = json.optString("id");
            String name = json.optString("name");
            String fastaPath = json.optString("fastaURL");
            GenomeDescriptor genomeDescriptor = new GenomeDescriptor(id, name, fastaPath);
            return genomeDescriptor;
        }
    }

    public static class GenomeDescriptor {
        String id;
        String name;
        String fastaURL;

        public GenomeDescriptor(String id, String name, String fastaURL) {
            this.id = id;
            this.name = name;
            this.fastaURL = fastaURL;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }
}

