/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bedpe;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import org.broad.igv.bedpe.BedPE;
import org.broad.igv.bedpe.BedPERenderer;
import org.broad.igv.bedpe.InteractionTrack;
import org.broad.igv.track.RenderContext;

public class PEBlockRenderer
implements BedPERenderer {
    InteractionTrack track;
    int rowHeight = 6;

    public PEBlockRenderer(InteractionTrack track) {
        this.track = track;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(List<BedPE> features, RenderContext context, Rectangle trackRectangle, InteractionTrack.ArcOption arcOption) {
        Graphics2D g = null;
        try {
            g = (Graphics2D)context.getGraphics().create();
            double origin = context.getOrigin();
            double locScale = context.getScale();
            Color trackColor = this.track.getColor();
            int blockY = this.track.direction == InteractionTrack.Direction.DOWN ? trackRectangle.y : trackRectangle.y + trackRectangle.height - this.rowHeight;
            for (BedPE bedPE : features) {
                Color fcolor;
                Color color = fcolor = bedPE.getColor() == null ? trackColor : bedPE.getColor();
                if (fcolor != null) {
                    g.setColor(fcolor);
                }
                if (bedPE.isSameChr()) {
                    BedPE feature = bedPE;
                    int ps1 = (int)(((double)feature.getStart1() - origin) / locScale);
                    int pe1 = (int)(((double)feature.getEnd1() - origin) / locScale);
                    if ((double)pe1 >= trackRectangle.getX() && (double)ps1 <= trackRectangle.getMaxX()) {
                        this.drawBlock(ps1, pe1, blockY, g);
                    }
                    int ps2 = (int)(((double)feature.getStart2() - origin) / locScale);
                    int pe2 = (int)(((double)feature.getEnd2() - origin) / locScale);
                    if (!((double)pe2 >= trackRectangle.getX()) || !((double)ps2 <= trackRectangle.getMaxX())) continue;
                    this.drawBlock(ps2, pe2, blockY, g);
                    continue;
                }
                int ps1 = (int)(((double)bedPE.getStart() - origin) / locScale);
                int pe1 = (int)(((double)bedPE.getEnd() - origin) / locScale);
                if (!((double)pe1 >= trackRectangle.getX()) || !((double)ps1 <= trackRectangle.getMaxX())) continue;
                this.drawBlock(ps1, pe1, blockY, g);
            }
        }
        finally {
            if (g != null) {
                g.dispose();
            }
        }
    }

    private void drawBlock(int ps1, int pe1, int blockY, Graphics2D g) {
        int w1 = Math.max(1, pe1 - ps1);
        if (w1 > 3) {
            --w1;
        } else if (w1 > 5) {
            w1 -= 2;
            ++ps1;
        }
        g.fillRect(ps1, blockY, w1, this.rowHeight);
    }
}

