/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bedpe;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.broad.igv.Globals;
import org.broad.igv.bedpe.BedPE;
import org.broad.igv.bedpe.BedPEFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public class BedPEParser {
    private static Logger log = LogManager.getLogger(BedPEParser.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BedPE> parse(ResourceLocator locator, Genome genome) throws IOException {
        int colorColumn = -1;
        int thicknessColumn = -1;
        String[] columns = new String[]{"chrom1", "start1", "stop1", "chrom2", "start2", "stop2", "name", "score", "strand1", "strand2"};
        boolean col7isNumeric = true;
        HashMap<String, Color> colorCache = new HashMap<String, Color>();
        ArrayList<BedPE> features = new ArrayList<BedPE>();
        HashMap<String, Integer> featureCounts = new HashMap<String, Integer>();
        try (BufferedReader br = null;){
            String nextLine;
            br = ParsingUtils.openBufferedReader(locator.getPath());
            boolean firstLine = true;
            int skippedLineCount = 0;
            while ((nextLine = br.readLine()) != null) {
                if (nextLine.startsWith("#columns")) {
                    try {
                        String[] t1 = ParsingUtils.WHITESPACE_PATTERN.split(nextLine);
                        if (t1.length == 2) {
                            String[] t2;
                            for (String keyValue : t2 = ParsingUtils.SEMI_COLON_PATTERN.split(t1[1])) {
                                String[] t = keyValue.split("=");
                                if (t[0].equals("color")) {
                                    colorColumn = Integer.parseInt(t[1]) - 1;
                                    continue;
                                }
                                if (!t[0].equals("thickness")) continue;
                                thicknessColumn = Integer.parseInt(t[1]) - 1;
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        log.error("Error parsing #column line.", e);
                    }
                }
                if (nextLine.startsWith("#") || nextLine.startsWith("chr1\tx1\tx2")) {
                    tokens = Globals.tabPattern.split(nextLine);
                    if (tokens.length >= 6) {
                        columns = tokens;
                        for (int i = 6; i < columns.length; ++i) {
                            if (columns[i].equalsIgnoreCase("color")) {
                                colorColumn = i;
                                continue;
                            }
                            if (!columns[i].toLowerCase().equalsIgnoreCase("thickness")) continue;
                            thicknessColumn = i;
                        }
                    }
                } else if (nextLine.startsWith("track") || nextLine.startsWith("##track")) {
                    TrackProperties trackProperties = new TrackProperties();
                    ParsingUtils.parseTrackLine(nextLine, trackProperties);
                } else if (firstLine && nextLine.startsWith("chromosome1\tx1\tx2") || nextLine.startsWith("chr1\tx1\tx2")) {
                    columns = Globals.tabPattern.split(nextLine);
                    for (int i = 6; i < columns.length; ++i) {
                        if (!columns[i].equalsIgnoreCase("color")) continue;
                        colorColumn = i;
                    }
                } else {
                    tokens = Globals.tabPattern.split(nextLine);
                    if (tokens.length < 6) {
                        if (skippedLineCount >= 5 || ++skippedLineCount != 5) continue;
                        log.warn("Skipping line: " + nextLine + (skippedLineCount < 5 ? "" : " Further skipped lines will not be logged"));
                        continue;
                    }
                    String chr1 = genome == null ? tokens[0] : genome.getCanonicalChrName(tokens[0]);
                    String chr2 = genome == null ? tokens[3] : genome.getCanonicalChrName(tokens[3]);
                    int start1 = Integer.parseInt(tokens[1]);
                    int end1 = Integer.parseInt(tokens[2]);
                    int start2 = Integer.parseInt(tokens[4]);
                    int end2 = Integer.parseInt(tokens[5]);
                    BedPEFeature feature = new BedPEFeature(chr1, start1, end1, chr2, start2, end2);
                    if (chr1.equals(chr2)) {
                        Integer counts = featureCounts.containsKey(chr1) ? (Integer)featureCounts.get(chr1) : 0;
                        featureCounts.put(chr1, counts + 1);
                    }
                    if (tokens.length > 6) {
                        feature.name = tokens[6];
                        col7isNumeric = col7isNumeric && BedPEParser.isNumeric(tokens[6]);
                    } else {
                        col7isNumeric = false;
                    }
                    if (tokens.length > 7) {
                        feature.scoreString = tokens[7];
                        try {
                            feature.score = Float.parseFloat(tokens[7]);
                        }
                        catch (NumberFormatException e) {
                            feature.score = 0.0f;
                        }
                    }
                    if (tokens.length > 8) {
                        int extraFieldsStart = 8;
                        if (tokens[8].trim().equals("+") || tokens[8].trim().equals("-")) {
                            feature.strand1 = tokens[8].trim().equals("+") ? Strand.POSITIVE : Strand.NEGATIVE;
                            extraFieldsStart = 9;
                        }
                        if (tokens[9].trim().equals("+") || tokens[9].trim().equals("-")) {
                            feature.strand2 = tokens[9].trim().equals("+") ? Strand.POSITIVE : Strand.NEGATIVE;
                            extraFieldsStart = 10;
                        }
                        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
                        for (int i = extraFieldsStart; i < tokens.length; ++i) {
                            String c;
                            String t = tokens[i];
                            String string = c = columns != null && columns.length > i ? columns[i] : String.valueOf(i);
                            if (c.equals("info") && t.contains("=")) {
                                String[] kvPairs;
                                for (String kvPair : kvPairs = Globals.semicolonPattern.split(tokens[11])) {
                                    String[] kv = Globals.equalPattern.split(kvPair);
                                    if (kv.length <= 1) continue;
                                    attributes.put(kv[0], kv[1]);
                                }
                                continue;
                            }
                            attributes.put(c, t);
                        }
                        feature.attributes = attributes;
                        feature.type = (String)attributes.get("TYPE");
                    }
                    if (colorColumn > 0 && tokens.length > colorColumn) {
                        String colorString = tokens[colorColumn];
                        Color c = (Color)colorCache.get(colorString);
                        if (c == null) {
                            c = ColorUtilities.stringToColor(colorString);
                            colorCache.put(colorString, c);
                        }
                        feature.setColor(c);
                    }
                    if (thicknessColumn > 0 && tokens.length > thicknessColumn) {
                        feature.thickness = Math.max(1, (int)Float.parseFloat(tokens[thicknessColumn]));
                    }
                    if (!feature.getChr1().equals(feature.getChr2())) {
                        features.add(feature.getComplement());
                    }
                    features.add(feature);
                }
                firstLine = false;
            }
            if (col7isNumeric) {
                for (BedPE bedpe : features) {
                    if (!(bedpe instanceof BedPEFeature)) continue;
                    BedPEFeature f = (BedPEFeature)bedpe;
                    f.score = Float.parseFloat(f.name);
                    f.scoreString = f.name;
                    f.name = null;
                }
            }
            ArrayList<BedPE> arrayList = features;
            return arrayList;
        }
    }

    public static boolean isNumeric(String strNum) {
        return strNum.matches("-?\\d+(\\.\\d+)?");
    }
}

