/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.aa;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.InputMismatchException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broad.igv.feature.aa.AminoAcid;
import org.broad.igv.feature.aa.AminoAcidManager;
import org.json.JSONArray;
import org.json.JSONObject;

public class CodonTable {
    private static final String[] BASE_SEQUENCES = new String[]{"TTTTTTTTTTTTTTTTCCCCCCCCCCCCCCCCAAAAAAAAAAAAAAAAGGGGGGGGGGGGGGGG", "TTTTCCCCAAAAGGGGTTTTCCCCAAAAGGGGTTTTCCCCAAAAGGGGTTTTCCCCAAAAGGGG", "TCAGTCAGTCAGTCAGTCAGTCAGTCAGTCAGTCAGTCAGTCAGTCAGTCAGTCAGTCAGTCAG"};
    private final Integer id;
    private final List<String> names;
    private final Set<AminoAcid> starts;
    private final Map<String, AminoAcid> codonMap;
    private Set<String> altStartCodons;

    public AminoAcid getAminoAcid(String codon) {
        if (codon.length() != 3) {
            throw new IllegalArgumentException("Codon must be length 3: " + codon);
        }
        AminoAcid aa = this.codonMap.get(codon);
        if (aa == null) {
            return AminoAcid.NULL_AMINO_ACID;
        }
        return aa;
    }

    CodonTable(String path, int id, List<String> names, Set<AminoAcid> starts, Map<String, AminoAcid> codonMap) {
        this.id = id;
        this.names = Collections.unmodifiableList(names);
        this.starts = Collections.unmodifiableSet(starts);
        this.codonMap = Collections.unmodifiableMap(codonMap);
    }

    static CodonTable createFromJSON(String sourcePath, JSONObject jsonObject) {
        int id = jsonObject.getInt("id");
        JSONArray jsonnames = jsonObject.getJSONArray("name");
        ArrayList<String> names = new ArrayList<String>(jsonnames.length());
        for (int nn = 0; nn < jsonnames.length(); ++nn) {
            names.add(jsonnames.getString(nn));
        }
        String aas = jsonObject.getString("ncbieaa");
        String startString = jsonObject.getString("sncbieaa");
        CodonTable codonTable = CodonTable.build(sourcePath, id, names, aas, startString);
        if (jsonObject.has("altStartCodons")) {
            JSONArray a = jsonObject.getJSONArray("altStartCodons");
            HashSet<String> altStartCodons = new HashSet<String>();
            for (int i = 0; i < a.length(); ++i) {
                altStartCodons.add(a.getString(i));
            }
            codonTable.altStartCodons = altStartCodons;
        }
        return codonTable;
    }

    private static CodonTable build(String sourcePath, int id, List<String> names, String aas, String startString) {
        String base1 = BASE_SEQUENCES[0];
        String base2 = BASE_SEQUENCES[1];
        String base3 = BASE_SEQUENCES[2];
        CodonTable.checkLengths(base1, base2, base3, aas, startString);
        HashMap<String, AminoAcid> codonMap = new HashMap<String, AminoAcid>(aas.length());
        HashSet<AminoAcid> starts = new HashSet<AminoAcid>(aas.length());
        for (int cc = 0; cc < aas.length(); ++cc) {
            String codon = base1.substring(cc, cc + 1) + base2.substring(cc, cc + 1) + base3.substring(cc, cc + 1);
            AminoAcid aa = AminoAcidManager.AANameMap.get(aas.substring(cc, cc + 1));
            codonMap.put(codon, aa);
            if (startString.charAt(cc) != 'M') continue;
            starts.add(aa);
        }
        return new CodonTable(sourcePath, id, names, starts, codonMap);
    }

    private static void checkLengths(String ... values) {
        int length = values[0].length();
        assert (length == 64);
        for (int v = 1; v < values.length; ++v) {
            if (values[v].length() == length) continue;
            Object msg = "Amino acid and codon strings must all be the same length.";
            msg = (String)msg + "Expected length " + length + ", found length " + values[v].length();
            throw new InputMismatchException((String)msg);
        }
    }

    public int getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.names.get(0);
    }

    public Set<AminoAcid> getStarts() {
        return this.starts;
    }

    Map<String, AminoAcid> getCodonMap() {
        return this.codonMap;
    }

    public Set<String> getAltStartCodons() {
        return this.altStartCodons;
    }

    public boolean equals(Object object) {
        if (object instanceof CodonTable) {
            CodonTable other = (CodonTable)object;
            return Objects.equal((Object)this.id, (Object)other.id) && Objects.equal(this.names, other.names) && Objects.equal(this.starts, other.starts) && Objects.equal(this.codonMap, other.codonMap);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.names, this.starts, this.codonMap});
    }
}

