/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.broad.igv.track.Track;
import org.broad.igv.ui.IGV;
import org.broad.igv.util.FilterElement;

public class TrackFilter {
    private LinkedHashSet<FilterElement> elements = new LinkedHashSet();
    private boolean isEnabled = true;
    boolean showAll = false;
    boolean matchAll = true;

    public TrackFilter() {
    }

    public TrackFilter(boolean showAll, boolean matchAll, List<FilterElement> elements) {
        this();
        this.showAll = showAll;
        this.matchAll = matchAll;
        if (elements != null) {
            this.elements.addAll(elements);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Filter[");
        sb.append("enabled=").append(this.isEnabled);
        sb.append(", showAll=").append(this.showAll);
        sb.append(", matchAll=").append(this.matchAll);
        sb.append(", elements=[");
        for (FilterElement element : this.elements) {
            sb.append(element.toString()).append(", ");
        }
        if (!this.elements.isEmpty()) {
            sb.setLength(sb.length() - 2);
        }
        sb.append("]");
        sb.append("]");
        return sb.toString();
    }

    public boolean isMatchAll() {
        return this.matchAll;
    }

    public boolean isShowAll() {
        return this.showAll;
    }

    public void removeAll() {
        this.elements.clear();
    }

    public void setEnabled(boolean value) {
        this.isEnabled = value;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public Iterator getFilterElements() {
        return this.elements.iterator();
    }

    public void add(FilterElement element) {
        this.elements.add(element);
    }

    public void remove(FilterElement element) {
        this.elements.remove(element);
    }

    public void evaluate() {
        boolean filterEnabled = this.isEnabled();
        for (Track track : IGV.getInstance().getAllTracks()) {
            if (!filterEnabled || this.elements.isEmpty()) {
                track.setVisible(true);
                continue;
            }
            if (!track.isFilterable()) continue;
            boolean result = this.matchAll;
            for (FilterElement element : this.elements) {
                boolean elementResult = element.evaluate(track);
                if (this.matchAll && !elementResult) {
                    result = false;
                    break;
                }
                if (this.matchAll || !elementResult) continue;
                result = true;
                break;
            }
            track.setVisible(result);
        }
    }

    public List<String> evaluateSamples(List<String> sampleNames) {
        ArrayList<String> filteredSamples = new ArrayList<String>();
        for (String sampleName : sampleNames) {
            boolean result = this.matchAll;
            for (FilterElement element : this.elements) {
                boolean elementResult = element.evaluateSample(sampleName);
                if (this.matchAll && !elementResult) {
                    result = false;
                    break;
                }
                if (this.matchAll || !elementResult) continue;
                result = true;
                break;
            }
            if (!result) continue;
            filteredSamples.add(sampleName);
        }
        return filteredSamples;
    }
}

