/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import biz.source_code.base64Coder.Base64Coder;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.broad.igv.Globals;
import org.broad.igv.exceptions.HttpResponseException;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.oauth.OAuthProvider;
import org.broad.igv.oauth.OAuthUtils;
import org.broad.igv.prefs.IGVPreferences;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.AmazonUtils;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.GoogleUtils;
import org.broad.igv.util.HttpMappings;
import org.broad.igv.util.LoginDialog;
import org.broad.igv.util.Pair;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.StringUtils;
import org.broad.igv.util.Utilities;
import org.broad.igv.util.ftp.FTPUtils;

public class HttpUtils {
    private static Logger log = LogManager.getLogger(HttpUtils.class);
    private static HttpUtils instance;
    private final String UCSC_HOST;
    private final String UCSC_BACKUP_HOST;
    private ProxySettings proxySettings = null;
    private final int MAX_REDIRECTS = 5;
    private String defaultUserName = null;
    private char[] defaultPassword = null;
    private Map<String, Collection<String>> headerMap = new HashMap<String, Collection<String>>();
    private Map<URL, Boolean> headURLCache = new HashMap<URL, Boolean>();
    private Map<String, Long> contentLengthCache = new HashMap<String, Long>();
    private final int DEFAULT_REDIRECT_EXPIRATION_MIN = 15;
    private Map<URL, CachedRedirect> redirectCache = new HashMap<URL, CachedRedirect>();
    Deque<Pair<Pattern, String>> accessTokens = new ArrayDeque<Pair<Pattern, String>>();

    public static HttpUtils getInstance() {
        if (instance == null) {
            instance = new HttpUtils();
        }
        return instance;
    }

    private HttpUtils() {
        this.disableCertificateValidation();
        Authenticator.setDefault(new IGVAuthenticator());
        try {
            System.setProperty("java.net.useSystemProxies", "true");
        }
        catch (Exception e) {
            log.warn("Couldn't set useSystemProxies=true");
        }
        this.UCSC_HOST = PreferencesManager.getPreferences().get("UCSC_HOST");
        this.UCSC_BACKUP_HOST = PreferencesManager.getPreferences().get("UCSC_BACKUP_HOST");
    }

    public void setAccessToken(String token, String host) {
        host = host == null || host.trim().length() == 0 ? ".*" : host.replace("*", ".*");
        Pattern newPattern = Pattern.compile(host, 2);
        this.accessTokens.add(new Pair<Pattern, String>(newPattern, token));
    }

    String getCachedTokenFor(URL url) {
        Iterator<Pair<Pattern, String>> iter = this.accessTokens.descendingIterator();
        while (iter.hasNext()) {
            Pair<Pattern, String> next = iter.next();
            Matcher matcher = next.getFirst().matcher(url.getHost());
            if (!matcher.find()) continue;
            return next.getSecond();
        }
        return null;
    }

    public void clearAccessTokens() {
        this.accessTokens.clear();
    }

    public static URL createURL(String urlString) throws MalformedURLException {
        if (AmazonUtils.isAwsS3Path(urlString = HttpMappings.mapURL(urlString.trim())).booleanValue()) {
            try {
                urlString = AmazonUtils.translateAmazonCloudURL(urlString);
            }
            catch (IOException e) {
                log.error("Error translating amazon cloud URL: " + urlString, e);
                throw new RuntimeException(e);
            }
        }
        return new URL(urlString);
    }

    public static boolean isRemoteURL(String string) {
        return FileUtils.isRemote(string);
    }

    public String getContentsAsString(URL url) throws IOException {
        return this.getContentsAsString(url, null);
    }

    public String getContentsAsString(URL url, Map<String, String> headers) throws IOException {
        byte[] bytes = this.getContentsAsBytes(url, headers);
        return new String(bytes, "UTF-8");
    }

    public byte[] getContentsAsBytes(URL url, Map<String, String> headers) throws IOException {
        HttpURLConnection conn = this.openConnection(url, headers);
        try (InputStream is = null;){
            is = conn.getInputStream();
            byte[] byArray = is.readAllBytes();
            return byArray;
        }
    }

    public String getContentsAsJSON(URL url) throws IOException {
        InputStream is = null;
        HashMap<String, String> reqProperties = new HashMap<String, String>();
        reqProperties.put("Accept", "application/json,text/plain");
        HttpURLConnection conn = this.openConnection(url, reqProperties);
        try {
            is = conn.getInputStream();
            String string = ParsingUtils.readContentsFromStream(is);
            return string;
        }
        catch (IOException e) {
            this.readErrorStream(conn);
            throw e;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public String doPost(URL url, Map<String, String> params) throws IOException {
        int c;
        StringBuilder postData = new StringBuilder();
        for (Map.Entry<String, String> param : params.entrySet()) {
            if (postData.length() != 0) {
                postData.append('&');
            }
            postData.append(param.getKey());
            postData.append('=');
            postData.append(param.getValue());
        }
        byte[] postDataBytes = postData.toString().getBytes();
        log.debug("Raw POST request: " + String.valueOf(postData));
        url = new URL(HttpMappings.mapURL(url.toExternalForm()));
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("User-Agent", Globals.applicationString());
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setDoOutput(true);
        conn.getOutputStream().write(postDataBytes);
        StringBuilder response = new StringBuilder();
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
        while ((c = ((Reader)in).read()) >= 0) {
            response.append((char)c);
        }
        ((Reader)in).close();
        return response.toString();
    }

    public InputStream openConnectionStream(URL url) throws IOException {
        log.debug("Opening connection stream to  " + String.valueOf(url));
        if (url.getProtocol().toLowerCase().equals("ftp")) {
            throw new IOException("FTP protoco is not supported");
        }
        return this.openConnectionStream(url, null);
    }

    public InputStream openConnectionStream(URL url, Map<String, String> requestProperties) throws IOException {
        HttpURLConnection conn = this.openConnection(url, requestProperties);
        if (conn == null) {
            return null;
        }
        try {
            InputStream input = conn.getInputStream();
            return input;
        }
        catch (IOException e) {
            this.readErrorStream(conn);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resourceAvailable(String urlString) {
        URL url = null;
        try {
            url = HttpUtils.createURL(urlString);
        }
        catch (MalformedURLException e) {
            return false;
        }
        log.debug("Checking if resource is available: " + String.valueOf(url));
        if (url.getProtocol().toLowerCase().equals("ftp")) {
            return FTPUtils.resourceAvailable(url);
        }
        HttpURLConnection conn = null;
        try {
            conn = this.openConnectionHeadOrGet(url);
            int code = conn.getResponseCode();
            boolean bl = code >= 200 && code < 300;
            return bl;
        }
        catch (Exception e) {
            if (conn != null) {
                try {
                    this.readErrorStream(conn);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                try {
                    conn.disconnect();
                }
                catch (Exception exception) {}
            }
        }
    }

    private HttpURLConnection openConnectionHeadOrGet(URL url) throws IOException {
        boolean tryHead;
        String urlString = url.toString();
        boolean isAWS = urlString.contains("AWSAccessKeyId");
        boolean bl = tryHead = !isAWS && this.headURLCache.getOrDefault(url, true) != false;
        if (tryHead) {
            try {
                HttpURLConnection conn = this.openConnection(url, null, "HEAD");
                this.headURLCache.put(url, true);
                return conn;
            }
            catch (IOException e) {
                log.debug("HEAD request failed for url: " + url.toExternalForm());
                log.debug("Trying GET with Range header instead for url: " + url.toExternalForm());
                this.headURLCache.put(url, false);
            }
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Range", "bytes=0-0");
        return this.openConnection(url, headers, "GET");
    }

    public String getHeaderField(URL url, String key) throws IOException {
        HttpURLConnection conn = this.openConnectionHeadOrGet(url);
        if (conn == null) {
            return null;
        }
        return conn.getHeaderField(key);
    }

    public long getLastModified(URL url) throws IOException {
        HttpURLConnection conn = this.openConnectionHeadOrGet(url);
        if (conn == null) {
            return 0L;
        }
        return conn.getLastModified();
    }

    public long getContentLength(URL url) throws IOException {
        if (this.contentLengthCache.containsKey(url.toExternalForm())) {
            return this.contentLengthCache.get(url.toExternalForm());
        }
        long contentLength = -1L;
        try {
            String contentLengthString = this.getHeaderField(url, "Content-Length");
            if (contentLengthString != null) {
                contentLength = Long.parseLong(contentLengthString);
            }
        }
        catch (Exception e) {
            log.error("Error fetching content length", e);
        }
        this.contentLengthCache.put(url.toExternalForm(), contentLength);
        return contentLength;
    }

    public void updateProxySettings() {
        int proxyPort = -1;
        boolean auth = false;
        String user = null;
        String pw = null;
        IGVPreferences prefMgr = PreferencesManager.getPreferences();
        String proxyHost = prefMgr.get("PROXY.HOST", null);
        try {
            proxyPort = Integer.parseInt(prefMgr.get("PROXY.PORT", "-1"));
        }
        catch (NumberFormatException e) {
            proxyPort = -1;
        }
        boolean useProxy = prefMgr.getAsBoolean("PROXY.USE") && proxyHost != null && proxyHost.trim().length() > 0;
        auth = prefMgr.getAsBoolean("PROXY.AUTHENTICATE");
        user = prefMgr.get("PROXY.USERNAME", null);
        String pwString = prefMgr.get("PROXY.PW", null);
        if (pwString != null) {
            pw = Utilities.base64Decode(pwString);
        }
        String proxyTypeString = prefMgr.get("PROXY.TYPE", "HTTP");
        Proxy.Type type = Proxy.Type.valueOf(proxyTypeString.trim().toUpperCase());
        String proxyWhitelistString = prefMgr.get("PROXY.WHITELIST");
        HashSet<String> whitelist = proxyWhitelistString == null ? new HashSet<String>() : new HashSet<String>(Arrays.asList(Globals.commaPattern.split(proxyWhitelistString)));
        this.proxySettings = new ProxySettings(useProxy, user, pw, auth, proxyHost, proxyPort, type, whitelist);
    }

    private Proxy getSystemProxy(String uri) {
        try {
            if (PreferencesManager.getPreferences().getAsBoolean("DEBUG.PROXY")) {
                log.info("Getting system proxy for " + uri);
            }
            ProxySelector selector = ProxySelector.getDefault();
            List<Proxy> proxyList = selector.select(new URI(uri));
            return proxyList.get(0);
        }
        catch (URISyntaxException e) {
            log.error(e.getMessage(), e);
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    private void disableCertificateValidation() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(this){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (KeyManagementException keyManagementException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readErrorStream(HttpURLConnection connection) throws IOException {
        try (InputStream inputStream = null;){
            inputStream = connection.getErrorStream();
            if (inputStream == null) {
                String string = null;
                return string;
            }
            String string = ParsingUtils.readContentsFromStream(inputStream);
            return string;
        }
    }

    public HttpURLConnection delete(URL url) throws IOException {
        return this.openConnection(url, Collections.emptyMap(), "DELETE");
    }

    public HttpURLConnection openConnection(URL url, Map<String, String> requestProperties) throws IOException {
        return this.openConnection(url, requestProperties, "GET");
    }

    private HttpURLConnection openConnection(URL url, Map<String, String> requestProperties, String method) throws IOException {
        return this.openConnection(url, requestProperties, method, 0, 0);
    }

    private HttpURLConnection openConnection(URL url, Map<String, String> requestProperties, String method, int redirectCount, int retries) throws IOException {
        try {
            Collection<String> headers;
            OAuthProvider oauthProvider;
            String token;
            url = new URL(HttpMappings.mapURL(url.toExternalForm()));
            if (this.redirectCache.containsKey(url)) {
                CachedRedirect cr = this.redirectCache.get(url);
                if ((double)ZonedDateTime.now().compareTo(cr.expires) < 0.0) {
                    log.debug("Found URL in redirection cache: " + String.valueOf(url) + " ->" + String.valueOf(this.redirectCache.get((Object)url).url));
                    url = cr.url;
                } else {
                    log.debug("Removing expired URL from redirection cache: " + String.valueOf(url));
                    this.redirectCache.remove(url);
                }
            }
            if ((token = this.getCachedTokenFor(url)) == null && (oauthProvider = OAuthUtils.getInstance().getProviderForURL(url)) != null) {
                if (!oauthProvider.isGoogle()) {
                    oauthProvider.checkLogin();
                }
                token = oauthProvider.getAccessToken();
                if (OAuthProvider.findString != null) {
                    url = HttpUtils.createURL(url.toExternalForm().replaceFirst(OAuthProvider.findString, OAuthProvider.replaceString));
                }
            }
            if (AmazonUtils.isKnownPresignedURL(url.toExternalForm())) {
                url = new URL(AmazonUtils.updatePresignedURL(url.toExternalForm()));
            }
            if (AmazonUtils.isAwsS3Path(url.toExternalForm()).booleanValue()) {
                url = new URL(AmazonUtils.translateAmazonCloudURL(url.toExternalForm()));
            }
            url = StringUtils.encodeURLQueryString(url);
            if (log.isTraceEnabled()) {
                log.trace(url);
            }
            if (StringUtils.countChar(url.toExternalForm(), ' ') > 0) {
                String newPath = url.toExternalForm().replaceAll(" ", "%20");
                url = HttpUtils.createURL(newPath);
            }
            if (GoogleUtils.isGoogleURL(url.toExternalForm()) && GoogleUtils.getProjectID() != null && GoogleUtils.getProjectID().length() > 0 && !this.hasQueryParameter(url, "userProject")) {
                url = this.addQueryParameter(url, "userProject", GoogleUtils.getProjectID());
            }
            HttpURLConnection conn = this.openProxiedConnection(url);
            if (!"HEAD".equals(method)) {
                conn.setRequestProperty("Accept", "text/plain");
            }
            conn.setConnectTimeout(Globals.CONNECT_TIMEOUT);
            conn.setReadTimeout(Globals.READ_TIMEOUT);
            conn.setRequestMethod(method);
            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setInstanceFollowRedirects(false);
            if (requestProperties != null) {
                for (Map.Entry entry : requestProperties.entrySet()) {
                    conn.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if ((headers = this.headerMap.get(url.getHost())) != null) {
                for (String h : headers) {
                    String[] kv = h.split(":");
                    if (kv.length != 2) continue;
                    conn.setRequestProperty(kv[0], kv[1]);
                }
            }
            conn.setRequestProperty("User-Agent", Globals.applicationString());
            if (token != null) {
                conn.setRequestProperty("Authorization", "Bearer " + token);
            }
            if (method.equals("PUT")) {
                return conn;
            }
            int n = conn.getResponseCode();
            if (!this.isDropboxHost(url.getHost()) && requestProperties != null && requestProperties.containsKey("Range") && n == 200 && method.equals("GET")) {
                log.warn("Range header removed by proxy or ignored by server for url: " + String.valueOf(url));
                String[] positionString = requestProperties.get("Range").split("=")[1].split("-");
                int length = Integer.parseInt(positionString[1]) - Integer.parseInt(positionString[0]) + 1;
                requestProperties.remove("Range");
                URL wsUrl = HttpUtils.createURL("https://igv.org/genomes/range.php?file=" + url.toExternalForm() + "&position=" + positionString[0] + "&length=" + length);
                return this.openConnection(wsUrl, requestProperties, "GET", redirectCount, retries);
            }
            if (n >= 300 && n < 400) {
                if (redirectCount > 5) {
                    throw new IOException("Too many redirects");
                }
                CachedRedirect cr = new CachedRedirect(this);
                cr.url = new URL(conn.getHeaderField("Location"));
                if (cr.url != null) {
                    cr.expires = ZonedDateTime.now().plusMinutes(15L);
                    String s = conn.getHeaderField("Cache-Control");
                    if (s != null) {
                        CacheControl cc = null;
                        try {
                            cc = CacheControl.valueOf(s);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                        if (cc != null) {
                            if (cc.isNoCache()) {
                                cr.expires = null;
                            } else if (cc.getMaxAge() > 0L) {
                                cr.expires = ZonedDateTime.now().plusSeconds(cc.getMaxAge());
                            }
                        }
                    } else {
                        s = conn.getHeaderField("Expires");
                        if (s != null) {
                            try {
                                cr.expires = ZonedDateTime.parse(s);
                            }
                            catch (DateTimeParseException dateTimeParseException) {
                                // empty catch block
                            }
                        }
                    }
                    if (cr.expires != null) {
                        this.redirectCache.put(url, cr);
                        log.debug("Redirecting to " + String.valueOf(cr.url));
                        return this.openConnection(HttpUtils.createURL(cr.url.toString()), requestProperties, method, ++redirectCount, retries);
                    }
                }
            } else if (n >= 400) {
                Object message;
                if (n == 404) {
                    message = "File not found: " + url.toString();
                    throw new FileNotFoundException((String)message);
                }
                if (n == 401) {
                    OAuthProvider provider = OAuthUtils.getInstance().getProviderForURL(url);
                    if (provider == null && GoogleUtils.isGoogleURL(url.toExternalForm())) {
                        provider = OAuthUtils.getInstance().getGoogleProvider();
                    }
                    if (provider != null && retries == 0) {
                        if (!provider.isLoggedIn()) {
                            provider.checkLogin();
                        }
                        return this.openConnection(url, requestProperties, method, redirectCount, ++retries);
                    }
                    message = "You must log in to access this file";
                    throw new HttpResponseException(n, (String)message, "");
                }
                if (n == 403) {
                    message = "Access forbidden";
                    throw new HttpResponseException(n, (String)message, "");
                }
                if (n == 416) {
                    throw new UnsatisfiableRangeException(conn.getResponseMessage());
                }
                message = conn.getResponseMessage();
                String details = this.readErrorStream(conn);
                if (GoogleUtils.isGoogleURL(url.toExternalForm()) && details.contains("requester pays bucket")) {
                    MessageUtils.showMessage("<html>" + details + "<br>Use Google menu to set project.");
                }
                throw new HttpResponseException(n, (String)message, details);
            }
            return conn;
        }
        catch (IOException e) {
            if (url.getHost().equals(this.UCSC_HOST) && !HttpUtils.isIndex(url)) {
                try {
                    log.warn("Connection to " + url.getHost() + " failed, retrying with backup host");
                    String newURL = url.toExternalForm().replaceFirst(this.UCSC_HOST, this.UCSC_BACKUP_HOST);
                    return this.openConnection(new URL(newURL), requestProperties, method, redirectCount, retries);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    private static boolean isIndex(URL url) {
        return url.getPath().endsWith(".tbi") || url.getPath().endsWith(".idx") || url.getPath().endsWith("idx.gz") || url.getPath().endsWith(".csi");
    }

    public HttpURLConnection openProxiedConnection(URL url) throws IOException {
        Proxy sysProxy;
        HttpURLConnection conn = null;
        if (this.proxySettings != null && this.proxySettings.isProxyDefined()) {
            System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
            System.setProperty("jdk.http.auth.proxying.disabledSchemes", "");
            Proxy proxy = new Proxy(this.proxySettings.type, new InetSocketAddress(this.proxySettings.proxyHost, this.proxySettings.proxyPort));
            conn = (HttpURLConnection)url.openConnection(proxy);
            if (this.proxySettings.isUserPwDefined()) {
                byte[] bytes = (this.proxySettings.user + ":" + this.proxySettings.pw).getBytes();
                String encodedUserPwd = String.valueOf(Base64Coder.encode(bytes));
                conn.setRequestProperty("Proxy-Authorization", "Basic " + encodedUserPwd);
            }
        }
        if (conn == null && !PreferencesManager.getPreferences().getAsBoolean("PROXY.DISABLE_CHECK") && (sysProxy = this.getSystemProxy(url.toExternalForm())) != null && sysProxy.type() != Proxy.Type.DIRECT) {
            conn = (HttpURLConnection)url.openConnection(sysProxy);
        }
        if (conn == null) {
            conn = (HttpURLConnection)url.openConnection();
        }
        return conn;
    }

    private boolean isDropboxHost(String host) {
        return host.equals("dl.dropboxusercontent.com") || host.equals("www.dropbox.com");
    }

    private URL addQueryParameter(URL url, String param, String value) {
        Object urlString;
        urlString = (String)urlString + (((String)(urlString = url.toExternalForm())).contains("?") ? "&" : "?") + param + "=" + value;
        try {
            return new URL((String)urlString);
        }
        catch (MalformedURLException e) {
            log.error("Error adding query parameter", e);
            return url;
        }
    }

    private boolean hasQueryParameter(URL url, String parameter) {
        String urlstring = url.toExternalForm();
        if (urlstring.contains("?")) {
            int idx = urlstring.indexOf(63);
            return urlstring.substring(idx).contains(parameter + "=");
        }
        return false;
    }

    private void logHeaders(HttpURLConnection conn) {
        Map<String, List<String>> headerFields = conn.getHeaderFields();
        log.debug("Headers for " + String.valueOf(conn.getURL()));
        for (Map.Entry<String, List<String>> header : headerFields.entrySet()) {
            log.debug(header.getKey() + ": " + StringUtils.join(header.getValue(), ","));
        }
    }

    public void setDefaultPassword(String defaultPassword) {
        this.defaultPassword = defaultPassword.toCharArray();
    }

    public void setDefaultUserName(String defaultUserName) {
        this.defaultUserName = defaultUserName;
    }

    public void clearDefaultCredentials() {
        this.defaultPassword = null;
        this.defaultUserName = null;
    }

    public void addHeaders(Collection<String> headers, List<String> urls) {
        for (String u : urls) {
            if (!HttpUtils.isRemoteURL(u)) continue;
            try {
                URL url = new URL(u);
                this.headerMap.put(url.getHost(), headers);
                url = new URL(HttpMappings.mapURL(u));
                this.headerMap.put(url.getHost(), headers);
            }
            catch (MalformedURLException e) {
                log.error("Error parsing URL " + u, e);
            }
        }
    }

    private String stripParameters(String url) {
        int idx = url.indexOf("?");
        if (idx > 0) {
            return url.substring(0, idx);
        }
        return url;
    }

    public void shutdown() {
    }

    public static void readFully(InputStream is, byte[] b) throws IOException {
        int count;
        int len = b.length;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = is.read(b, n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    public static boolean isSignedURL(String url) {
        Pattern pattern = Pattern.compile("X-.*-Signature");
        Matcher matcher = pattern.matcher(url);
        return matcher.find();
    }

    public static class ProxySettings {
        boolean auth = false;
        String user;
        String pw;
        boolean useProxy;
        String proxyHost;
        int proxyPort = -1;
        Proxy.Type type;
        Set<String> whitelist;

        public ProxySettings(boolean useProxy, String user, String pw, boolean auth, String proxyHost, int proxyPort, Proxy.Type proxyType, Set<String> whitelist) {
            this.auth = auth;
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.pw = pw;
            this.useProxy = useProxy;
            this.user = user;
            this.type = proxyType;
            this.whitelist = whitelist;
        }

        public boolean isProxyDefined() {
            return this.useProxy && this.proxyHost != null && this.proxyPort > 0;
        }

        public boolean isUserPwDefined() {
            return this.auth && this.user != null && this.pw != null;
        }

        public Set<String> getWhitelist() {
            return this.whitelist;
        }
    }

    public class IGVAuthenticator
    extends Authenticator {
        Hashtable<String, PasswordAuthentication> pwCache = new Hashtable();
        HashSet<String> cacheAttempts = new HashSet();

        @Override
        protected synchronized PasswordAuthentication getPasswordAuthentication() {
            Authenticator.RequestorType type = this.getRequestorType();
            String urlString = this.getRequestingURL().toString();
            boolean isProxyChallenge = type == Authenticator.RequestorType.PROXY;
            String pKey = type.toString() + this.getRequestingProtocol() + this.getRequestingHost();
            PasswordAuthentication pw = this.pwCache.get(pKey);
            if (pw != null) {
                if (this.cacheAttempts.contains(urlString)) {
                    this.cacheAttempts.remove(urlString);
                } else {
                    this.cacheAttempts.add(urlString);
                    return pw;
                }
            }
            if (isProxyChallenge && HttpUtils.this.proxySettings.auth && HttpUtils.this.proxySettings.user != null && HttpUtils.this.proxySettings.pw != null) {
                return new PasswordAuthentication(HttpUtils.this.proxySettings.user, HttpUtils.this.proxySettings.pw.toCharArray());
            }
            if (HttpUtils.this.defaultUserName != null && HttpUtils.this.defaultPassword != null) {
                return new PasswordAuthentication(HttpUtils.this.defaultUserName, HttpUtils.this.defaultPassword);
            }
            Frame owner = IGV.hasInstance() ? IGV.getInstance().getMainFrame() : null;
            LoginDialog dlg = new LoginDialog(owner, urlString, isProxyChallenge);
            dlg.setVisible(true);
            if (dlg.isCanceled()) {
                return null;
            }
            String userString = dlg.getUsername();
            char[] userPass = dlg.getPassword();
            if (isProxyChallenge) {
                HttpUtils.this.proxySettings.user = userString;
                HttpUtils.this.proxySettings.pw = new String(userPass);
            }
            pw = new PasswordAuthentication(userString, userPass);
            this.pwCache.put(pKey, pw);
            return pw;
        }
    }

    private class CachedRedirect {
        private URL url = null;
        private ZonedDateTime expires = null;

        private CachedRedirect(HttpUtils httpUtils) {
        }
    }

    static class CacheControl {
        boolean noCache = false;
        long maxAge = 0L;

        static CacheControl valueOf(String s) {
            String[] tokens;
            CacheControl cc = new CacheControl();
            for (String t : tokens = Globals.commaPattern.split(s)) {
                if ((t = t.trim().toLowerCase()).startsWith("no-cache")) {
                    cc.noCache = true;
                    continue;
                }
                if (!t.startsWith("max-age")) continue;
                String[] ma = Globals.equalPattern.split(t);
                cc.maxAge = Long.parseLong(ma[1].trim());
            }
            return cc;
        }

        private CacheControl() {
        }

        public boolean isNoCache() {
            return this.noCache;
        }

        public long getMaxAge() {
            return this.maxAge;
        }
    }

    public class UnsatisfiableRangeException
    extends RuntimeException {
        String message;

        public UnsatisfiableRangeException(String message) {
            super(message);
            this.message = message;
        }
    }
}

