/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JPanel;
import org.broad.igv.Globals;
import org.broad.igv.track.Track;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.IGVMouseInputAdapter;
import org.broad.igv.ui.util.IconFactory;

public class ZoomSliderPanel
extends JPanel {
    private static final Color TRANSPARENT_GRAY = new Color(200, 200, 200, 150);
    private static final Color TRANSPARENT_BLUE = new Color(27, 96, 246, 25);
    static Color TICK_GRAY = new Color(90, 90, 90);
    static Color TICK_BLUE = new Color(25, 50, 200);
    Image slider;
    Image zoomPlus;
    Image zoomMinus;
    Rectangle zoomPlusRect;
    Rectangle zoomMinusRect;
    Rectangle[] zoomLevelRects;
    int numZoomLevels = 25;
    private int minZoomLevel = 0;
    private ReferenceFrame referenceFrame;
    private boolean darkMode;
    private Color markColor;
    private Color tickColor;

    public void setMinZoomLevel(int minZoomLevel) {
        this.minZoomLevel = minZoomLevel;
    }

    public ZoomSliderPanel() {
        this((ReferenceFrame)null);
    }

    public ZoomSliderPanel(ReferenceFrame referenceFrame) {
        this.referenceFrame = referenceFrame;
        this.slider = IconFactory.getInstance().getIcon(IconFactory.IconID.SLIDER).getImage();
        this.zoomPlus = IconFactory.getInstance().getIcon(IconFactory.IconID.ZOOM_PLUS).getImage();
        this.zoomMinus = IconFactory.getInstance().getIcon(IconFactory.IconID.ZOOM_MINUS).getImage();
        this.zoomLevelRects = new Rectangle[this.numZoomLevels];
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.init();
    }

    private void updateTickCount() {
        int tmp = Math.max(0, this.getReferenceFrame().getMaxZoom() + 1);
        if (tmp != this.numZoomLevels) {
            this.numZoomLevels = tmp;
            this.zoomLevelRects = new Rectangle[this.numZoomLevels];
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.updateTickCount();
        this.paintHorizontal(g);
    }

    protected void paintHorizontal(Graphics g) {
        Graphics2D transGraphics = (Graphics2D)g.create();
        transGraphics.setColor(TRANSPARENT_GRAY);
        int buttonWidth = this.zoomPlus.getWidth(null);
        int buttonHeight = this.zoomPlus.getHeight(null);
        Insets insets = this.getInsets();
        int panelWidth = this.getWidth() - insets.left - insets.right;
        int panelHeight = this.getHeight() - insets.top - insets.bottom;
        boolean enabled = this.isEnabled();
        g.setColor(enabled ? this.tickColor : Color.LIGHT_GRAY);
        double x = insets.left;
        double xStep = (double)(panelWidth - 2 * buttonWidth - 10) / (double)this.numZoomLevels;
        int y = insets.top + (panelHeight - buttonHeight) / 2;
        g.drawImage(this.zoomMinus, (int)x, y, null);
        this.zoomMinusRect = new Rectangle((int)x, y, buttonWidth, buttonHeight);
        if (!this.isEnabled()) {
            transGraphics.fill(this.zoomMinusRect);
        }
        int lastX = (int)((x += (double)(5 + buttonWidth)) - xStep);
        for (int i = 0; i < this.numZoomLevels; ++i) {
            Rectangle zoomRect = new Rectangle((int)x, y, (int)(x - (double)lastX), buttonHeight);
            int xLine = (int)(x + xStep / 2.0);
            g.drawLine(xLine, y + 3, xLine, y + buttonHeight - 4);
            this.zoomLevelRects[i] = zoomRect;
            lastX = (int)x;
            x += xStep;
        }
        y = insets.top + panelHeight / 2 - 1;
        y = insets.top + (panelHeight - buttonHeight) / 2;
        g.drawImage(this.zoomPlus, (int)(x += 5.0), y, null);
        this.zoomPlusRect = new Rectangle((int)x, y, buttonWidth, buttonWidth);
        if (!this.isEnabled()) {
            transGraphics.fill(this.zoomPlusRect);
        }
        int zoom = this.getReferenceFrame().getAdjustedZoom();
        if (enabled && zoom >= 0 && zoom < this.zoomLevelRects.length) {
            Rectangle rect = this.zoomLevelRects[zoom];
            g.setColor(this.markColor);
            g.fill3DRect((int)(rect.getX() + rect.getWidth() / 2.0) - 3, (int)rect.getY(), 6, (int)rect.getHeight(), true);
        }
        this.paintVisibilityThresholds(transGraphics);
        transGraphics.dispose();
    }

    private void paintVisibilityThresholds(Graphics2D transGraphics) {
        if (this.numZoomLevels > 1) {
            List<Integer> visibilityThresholds = IGV.getInstance().getAllTracks().stream().map(Track::getVisibilityWindow).filter(i -> i > 0).sorted().distinct().map(threshold -> this.getReferenceFrame().calculateZoom(0.0, threshold.intValue())).filter(z -> z > 1).toList();
            transGraphics.setColor(TRANSPARENT_BLUE);
            Rectangle maxZoom = this.zoomLevelRects[this.zoomLevelRects.length - 1];
            for (Integer window : visibilityThresholds) {
                Rectangle currentLevel = this.zoomLevelRects[window];
                Rectangle windowBox = new Rectangle(currentLevel.x, currentLevel.y, maxZoom.x + maxZoom.width - currentLevel.x, currentLevel.height);
                transGraphics.fill(windowBox);
            }
        }
    }

    void setZoom(MouseEvent e) {
        if (this.zoomPlusRect.contains(e.getX(), e.getY())) {
            this.getReferenceFrame().doZoomIncrement(1);
        } else if (this.zoomMinusRect.contains(e.getX(), e.getY())) {
            this.getReferenceFrame().doZoomIncrement(-1);
        } else {
            for (int i = 0; i < this.zoomLevelRects.length; ++i) {
                Rectangle rect = this.zoomLevelRects[i];
                if (!rect.contains(e.getX(), e.getY()) || i < this.minZoomLevel) continue;
                this.getReferenceFrame().setAdjustedZoom(i);
                break;
            }
        }
    }

    private ReferenceFrame getReferenceFrame() {
        if (this.referenceFrame == null) {
            return FrameManager.getDefaultFrame();
        }
        return this.referenceFrame;
    }

    private void init() {
        this.darkMode = Globals.isDarkMode();
        this.markColor = this.darkMode ? Color.CYAN : TICK_BLUE;
        this.tickColor = this.darkMode ? Color.white : Color.black;
        IGVMouseInputAdapter mouseAdapter = new IGVMouseInputAdapter(){
            int lastMousePressX = 0;

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                if (!ZoomSliderPanel.this.isEnabled()) {
                    return;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                if (!ZoomSliderPanel.this.isEnabled()) {
                    return;
                }
                ZoomSliderPanel.this.setZoom(e);
                ZoomSliderPanel.this.repaint();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
            }
        };
        this.addMouseMotionListener(mouseAdapter);
        this.addMouseListener(mouseAdapter);
    }
}

