/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bedpe;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.broad.igv.Globals;
import org.broad.igv.bedpe.BedPE;
import org.broad.igv.bedpe.InteractFeature;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public class InteractParser {
    private static Logger log = LogManager.getLogger(InteractParser.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BedPE> parse(ResourceLocator locator, Genome genome) throws IOException {
        ArrayList<BedPE> features = new ArrayList<BedPE>();
        try (BufferedReader br = null;){
            String nextLine;
            br = ParsingUtils.openBufferedReader(locator.getPath());
            while ((nextLine = br.readLine()) != null) {
                String[] tokens;
                InteractFeature f;
                if (nextLine.startsWith("#") || nextLine.startsWith("track") || nextLine.startsWith("browser") || (f = InteractFeature.fromTokens(tokens = Globals.whitespacePattern.split(nextLine), genome)) == null) continue;
                features.add(f);
            }
            ArrayList<BedPE> arrayList = features;
            return arrayList;
        }
    }
}

