/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ucsc.hub;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import org.broad.igv.Globals;
import org.broad.igv.ucsc.hub.HubTableModel;
import org.broad.igv.ui.util.IconFactory;

class HubTable
extends JTable {
    public static Color ALT_BACKGROUND = new Color(245, 245, 245);
    private final Map<Integer, Integer> rowHeights = new HashMap<Integer, Integer>();

    public HubTable(HubTableModel model) {
        super(model);
        this.getTableHeader().setReorderingAllowed(false);
        this.setRowSorter(new TableRowSorter<HubTableModel>(model));
        this.getColumnModel().getColumn(0).setMaxWidth(30);
        this.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JCheckBox checkBox = new JCheckBox();
                checkBox.setSelected(value != null && (Boolean)value != false);
                checkBox.setHorizontalAlignment(0);
                checkBox.setVerticalAlignment(1);
                checkBox.setOpaque(true);
                checkBox.setBackground(table.getBackground());
                return checkBox;
            }
        });
        this.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(new JCheckBox()){

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                JCheckBox checkBox = (JCheckBox)super.getTableCellEditorComponent(table, value, isSelected, row, column);
                checkBox.addActionListener(e -> HubTable.this.setValueAt(checkBox.isSelected(), row, column));
                return checkBox;
            }
        });
        this.getColumnModel().getColumn(1).setCellRenderer(HubTable.getMultiLineCellRenderer(Integer.MAX_VALUE));
        this.getColumnModel().getColumn(2).setCellRenderer(HubTable.getMultiLineCellRenderer(Integer.MAX_VALUE));
        this.getColumnModel().getColumn(3).setPreferredWidth(150);
        this.getColumnModel().getColumn(3).setMaxWidth(200);
        this.getColumnModel().getColumn(3).setCellRenderer(HubTable.getMultiLineCellRenderer(100));
        this.getColumnModel().getColumn(4).setMaxWidth(30);
        this.getColumnModel().getColumn(4).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value != null) {
                    ImageIcon icon = IconFactory.getInstance().getIcon(IconFactory.IconID.INFO);
                    JLabel label = new JLabel(icon);
                    label.setToolTipText(value.toString());
                    label.setOpaque(true);
                    label.setBackground(table.getBackground());
                    return label;
                }
                return new JLabel();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int column = HubTable.this.columnAtPoint(e.getPoint());
                if (column == 4) {
                    HubTable.this.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    HubTable.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Object value;
                int row = HubTable.this.rowAtPoint(e.getPoint());
                int column = HubTable.this.columnAtPoint(e.getPoint());
                if (column == 4 && (value = HubTable.this.getValueAt(row, column)) != null) {
                    try {
                        Desktop.getDesktop().browse(new URI(value.toString()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        if (Globals.isDarkMode()) {
            this.setBackground(Color.DARK_GRAY);
            this.setForeground(Color.WHITE);
            this.setSelectionBackground(Color.GRAY);
            this.setSelectionForeground(Color.WHITE);
            ALT_BACKGROUND = new Color(60, 60, 60);
            for (int i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
                TableCellRenderer renderer = this.getColumnModel().getColumn(i).getCellRenderer();
                if (!(renderer instanceof DefaultTableCellRenderer)) continue;
                ((DefaultTableCellRenderer)renderer).setBackground(this.getBackground());
                ((DefaultTableCellRenderer)renderer).setForeground(this.getForeground());
            }
        }
    }

    private static DefaultTableCellRenderer getMultiLineCellRenderer(final int maxLength) {
        return new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Object v;
                Object object = v = value != null ? value.toString() : "";
                if (((String)v).length() > maxLength) {
                    v = ((String)v).substring(0, maxLength) + "...";
                }
                JTextArea textArea = new JTextArea((String)v);
                textArea.setToolTipText(value.toString());
                textArea.setLineWrap(true);
                textArea.setWrapStyleWord(true);
                textArea.setOpaque(true);
                textArea.setFont(table.getFont());
                textArea.setBackground(table.getBackground());
                textArea.setForeground(table.getForeground());
                int columnWidth = table.getColumnModel().getColumn(column).getWidth();
                textArea.setSize(columnWidth, Short.MAX_VALUE);
                int preferredHeight = textArea.getPreferredSize().height + 5;
                if (preferredHeight > table.getRowHeight(row)) {
                    table.setRowHeight(row, preferredHeight);
                }
                return textArea;
            }
        };
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return column == 0 ? Boolean.class : (column == 4 ? JLabel.class : String.class);
    }

    @Override
    public boolean isCellSelected(int row, int column) {
        return false;
    }

    @Override
    public boolean isColumnSelected(int column) {
        return false;
    }

    @Override
    public boolean isRowSelected(int row) {
        return false;
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component component = super.prepareRenderer(renderer, row, column);
        component.setBackground(row % 2 == 0 ? ALT_BACKGROUND : (Globals.isDarkMode() ? Color.black : Color.WHITE));
        return component;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 0;
    }

    private DefaultTableCellRenderer getDefaultTableCellRenderer() {
        return new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JTextArea textArea = new JTextArea(value != null ? value.toString() : "");
                textArea.setLineWrap(true);
                textArea.setWrapStyleWord(true);
                textArea.setOpaque(true);
                textArea.setFont(table.getFont());
                textArea.setBackground(table.getBackground());
                textArea.setForeground(table.getForeground());
                int columnWidth = table.getColumnModel().getColumn(column).getWidth();
                textArea.setSize(columnWidth, Short.MAX_VALUE);
                int preferredHeight = textArea.getPreferredSize().height;
                if (table.getRowHeight(row) != preferredHeight) {
                    table.setRowHeight(row, preferredHeight);
                }
                return textArea;
            }
        };
    }
}

