/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ucsc.bb;

import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.ucsc.BPTree;
import org.broad.igv.ucsc.bb.RunningTotal;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;

public class ChromTree {
    private static Logger log = LogManager.getLogger(ChromTree.class);
    private final long startOffset;
    private BPTree bpTree;
    private HashMap<String, Integer> nameToId = new HashMap();
    private HashMap<Integer, String> idToName = new HashMap();

    public ChromTree(String file, long startOffset) throws IOException {
        if (FileUtils.isRemote(file)) {
            SeekableStream stream = IGVSeekableStreamFactory.getInstance().getBufferedStream(IGVSeekableStreamFactory.getInstance().getStreamFor(file), 65536);
            this.bpTree = new BPTree(stream, startOffset);
        } else {
            this.bpTree = new BPTree(file, startOffset);
        }
        this.startOffset = startOffset;
    }

    public Integer getIdForName(String chr) {
        if (this.nameToId.containsKey(chr)) {
            return this.nameToId.get(chr);
        }
        try {
            int[] result = this.bpTree.searchIntInt(chr);
            if (result != null) {
                int id = result[0];
                this.nameToId.put(chr, id);
                return id;
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getNameForId(int id) {
        if (this.idToName.containsKey(id)) {
            return this.idToName.get(id);
        }
        String name = this.searchForName(id);
        if (name != null) {
            this.idToName.put(id, name);
            return name;
        }
        return null;
    }

    public long getItemCount() {
        return this.bpTree.itemCount;
    }

    private String searchForName(int id) {
        try {
            return this.reverseSearch(this.startOffset + 32L, id);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String reverseSearch(long offset, int id) throws IOException {
        BPTree.Node node = this.bpTree.readTreeNode(offset);
        String found = null;
        if (node.type == 1) {
            for (BPTree.Item item : node.items) {
                String key = item.getKey();
                int[] values = item.getValueAsInts();
                this.nameToId.put(key, values[0]);
                this.idToName.put(values[0], key);
                if (values[0] != id) continue;
                found = key;
            }
            return found;
        }
        for (BPTree.Item item : node.items) {
            found = this.reverseSearch(item.offset, id);
            if (found == null) continue;
            break;
        }
        return found;
    }

    public long estimateGenomeSize() {
        try {
            RunningTotal runningTotal = new RunningTotal(0.0, 0);
            this.accumulateSize(this.startOffset + 32L, runningTotal, 1000);
            return (long)((double)(this.getItemCount() / (long)runningTotal.count) * runningTotal.total);
        }
        catch (IOException e) {
            log.error("Error estimating genome size", e);
            return -1L;
        }
    }

    private RunningTotal accumulateSize(long offset, RunningTotal runningTotal, int maxCount) throws IOException {
        BPTree.Node node = this.bpTree.readTreeNode(offset);
        if (node.type == 1) {
            for (BPTree.Item item : node.items) {
                int[] values = item.getValueAsInts();
                runningTotal.total += (double)values[1];
                ++runningTotal.count;
            }
        } else {
            ArrayList<BPTree.Item> shuffledItems = new ArrayList<BPTree.Item>(node.items);
            Collections.shuffle(shuffledItems);
            for (BPTree.Item item : shuffledItems) {
                this.accumulateSize(item.offset, runningTotal, maxCount);
                if (runningTotal.count <= maxCount) continue;
                break;
            }
        }
        return runningTotal;
    }
}

