/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Map;
import org.broad.igv.DirectoryManager;
import org.broad.igv.feature.genome.load.GenomeLoader;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.download.Downloader;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.Utilities;

public class DotGenomeUtils {
    private static Logger log = LogManager.getLogger(DotGenomeUtils.class);

    public static File getDotGenomeFile(String genomePath) throws MalformedURLException, UnsupportedEncodingException {
        File archiveFile;
        if (HttpUtils.isRemoteURL(genomePath.toLowerCase())) {
            URL genomeArchiveURL = HttpUtils.createURL(genomePath);
            String tmp = URLDecoder.decode(genomeArchiveURL.getFile(), "UTF-8");
            String cachedFilename = Utilities.getFileNameFromURL(tmp);
            if (!DirectoryManager.getGenomeCacheDirectory().exists()) {
                DirectoryManager.getGenomeCacheDirectory().mkdir();
            }
            archiveFile = new File(DirectoryManager.getGenomeCacheDirectory(), cachedFilename);
            Frame parent = IGV.hasInstance() ? IGV.getInstance().getMainFrame() : null;
            Downloader.download(genomeArchiveURL, archiveFile, parent);
        } else {
            archiveFile = new File(genomePath);
        }
        return archiveFile;
    }

    public static File getLocalFasta(String id) {
        return GenomeLoader.localSequenceMap.get(id);
    }

    public static void removeLocalFasta(String id) {
        GenomeLoader.localSequenceMap.remove(id);
        DotGenomeUtils.updateSequenceMapFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateSequenceMapFile() {
        try (PrintWriter pw = null;){
            File sequenceFile = new File(DirectoryManager.getGenomeCacheDirectory(), "sequenceMap.txt");
            pw = new PrintWriter(new BufferedWriter(new FileWriter(sequenceFile)));
            for (Map.Entry<String, File> entry : GenomeLoader.localSequenceMap.entrySet()) {
                pw.println(entry.getKey() + "\t" + String.valueOf(entry.getValue()));
            }
        }
    }
}

