/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bedpe;

import java.awt.Color;
import java.util.Map;
import org.broad.igv.bedpe.BedPE;
import org.broad.igv.bedpe.BedPEShape;
import org.broad.igv.feature.Strand;

public class BedPEFeature
implements BedPE {
    protected String chr1;
    protected int start1;
    protected int end1;
    protected Strand strand1 = Strand.NONE;
    protected String chr2;
    protected int start2;
    protected int end2;
    protected Strand strand2 = Strand.NONE;
    protected String name;
    protected String scoreString = "";
    protected float score;
    protected Color color;
    protected int thickness = 1;
    protected String type;
    Map<String, String> attributes;
    BedPEShape shape;
    private boolean isComplement = false;

    public BedPEFeature() {
    }

    public BedPEFeature(String chr1, int start1, int end1, String chr2, int start2, int end2) {
        this.chr1 = chr1;
        this.start1 = start1;
        this.chr2 = chr2;
        this.end1 = end1;
        this.start2 = start2;
        this.end2 = end2;
    }

    public BedPEFeature getComplement() {
        BedPEFeature complement = new BedPEFeature(this.chr1, this.start1, this.end1, this.chr2, this.start2, this.end2);
        complement.isComplement = true;
        return complement;
    }

    public String getChr() {
        if (this.isSameChr()) {
            return this.chr1;
        }
        return this.isComplement ? this.chr2 : this.chr1;
    }

    public int getStart() {
        return Math.min(this.start1, this.start2);
    }

    public int getEnd() {
        return Math.max(this.end1, this.end2);
    }

    @Override
    public double getMidStart() {
        return Math.min((double)(this.start1 + this.end1) / 2.0, (double)(this.start2 + this.end2) / 2.0);
    }

    @Override
    public double getMidEnd() {
        return Math.max((double)(this.start1 + this.end1) / 2.0, (double)(this.start2 + this.end2) / 2.0);
    }

    @Override
    public boolean isComplement() {
        return this.isComplement;
    }

    @Override
    public float getScore() {
        return this.score;
    }

    @Override
    public boolean isSameChr() {
        return this.chr1.equals(this.chr2);
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public int getThickness() {
        return this.thickness;
    }

    public String getContig() {
        return this.getChr();
    }

    @Override
    public BedPEShape getShape() {
        return this.shape;
    }

    @Override
    public void setShape(BedPEShape shape) {
        this.shape = shape;
    }

    @Override
    public String getValueString() {
        StringBuffer buf = new StringBuffer();
        String locus1 = this.chr1 + ":" + this.start1 + "-" + this.end1;
        String locus2 = this.chr2 + ":" + this.start2 + "-" + this.end2;
        if (this.name != null && this.name.length() > 0 && !this.name.equals(".")) {
            buf.append(this.name + "<br>");
        }
        buf.append(locus1);
        buf.append("<br>" + locus2);
        buf.append("<br>Score: " + this.score);
        if (this.attributes != null) {
            buf.append("<br><hr>");
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                buf.append("<br>" + entry.getKey() + ": " + entry.getValue());
            }
        }
        return buf.toString();
    }

    @Override
    public String getChr1() {
        return this.chr1;
    }

    @Override
    public int getStart1() {
        return this.start1;
    }

    @Override
    public int getEnd1() {
        return this.end1;
    }

    @Override
    public String getChr2() {
        return this.chr2;
    }

    @Override
    public int getStart2() {
        return this.start2;
    }

    @Override
    public int getEnd2() {
        return this.end2;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

