/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.util.StringUtil;
import htsjdk.utils.ValidationUtils;
import java.io.File;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SequenceUtil {
    public static final byte a = 97;
    public static final byte c = 99;
    public static final byte g = 103;
    public static final byte t = 116;
    public static final byte n = 110;
    public static final byte A = 65;
    public static final byte C = 67;
    public static final byte G = 71;
    public static final byte T = 84;
    public static final byte N = 78;
    public static final byte[] VALID_BASES_UPPER = new byte[]{65, 67, 71, 84};
    public static final byte[] VALID_BASES_LOWER = new byte[]{97, 99, 103, 116};
    private static final byte[] ACGTN_BASES = new byte[]{65, 67, 71, 84, 78};
    private static final String IUPAC_CODES_STRING = ".aAbBcCdDgGhHkKmMnNrRsStTvVwWyY";
    private static final byte[] BAM_READ_BASE_SET = "=ABCDGHKMNRSTVWY".getBytes();
    private static final int BASES_ARRAY_LENGTH = 127;
    private static final int SHIFT_TO_LOWER_CASE = 32;
    private static final byte[] bamReadBaseLookup = new byte[127];
    private static final byte A_MASK = 1;
    private static final byte C_MASK = 2;
    private static final byte G_MASK = 4;
    private static final byte T_MASK = 8;
    private static final byte[] bases;
    private static final byte NON_IUPAC_CODE = 0;
    static final Pattern mdPat;

    public static String reverseComplement(String sequenceData) {
        byte[] bases = StringUtil.stringToBytes(sequenceData);
        SequenceUtil.reverseComplement(bases);
        return StringUtil.bytesToString(bases);
    }

    public static boolean basesEqual(byte lhs, byte rhs) {
        if (lhs < 0 || lhs >= 127) {
            return false;
        }
        if (rhs < 0 || rhs >= 127) {
            return false;
        }
        return bases[lhs] == bases[rhs];
    }

    public static boolean readBaseMatchesRefBaseWithAmbiguity(byte readBase, byte refBase) {
        if (readBase < 0 || readBase >= 127) {
            return false;
        }
        if (refBase < 0 || refBase >= 127) {
            return false;
        }
        return (bases[readBase] & bases[refBase]) == bases[readBase];
    }

    public static boolean isNoCall(byte base) {
        return base == 78 || base == 110 || base == 46;
    }

    public static boolean isValidBase(byte b) {
        return SequenceUtil.isValidBase(b, VALID_BASES_UPPER) || SequenceUtil.isValidBase(b, VALID_BASES_LOWER);
    }

    private static boolean isValidBase(byte b, byte[] validBases) {
        for (byte validBase : validBases) {
            if (b != validBase) continue;
            return true;
        }
        return false;
    }

    public static boolean isUpperACGTN(byte base) {
        return SequenceUtil.isValidBase(base, ACGTN_BASES);
    }

    public static String getIUPACCodesString() {
        return IUPAC_CODES_STRING;
    }

    public static boolean isIUPAC(byte base) {
        if (base >= 127 || base < 0) {
            return false;
        }
        return bases[base] != 0;
    }

    public static double calculateGc(byte[] bases) {
        int gcs = 0;
        for (byte b : bases) {
            if (b != 67 && b != 71 && b != 99 && b != 103) continue;
            ++gcs;
        }
        return (double)gcs / (double)bases.length;
    }

    public static boolean isBamReadBase(byte base) {
        return SequenceUtil.isValidBase(base, BAM_READ_BASE_SET);
    }

    public static byte[] toBamReadBasesInPlace(byte[] bases) {
        for (int i = 0; i < bases.length; ++i) {
            bases[i] = bamReadBaseLookup[bases[i]];
        }
        return bases;
    }

    public static void assertSequenceListsEqual(List<SAMSequenceRecord> s1, List<SAMSequenceRecord> s2) {
        SequenceUtil.assertSequenceListsEqual(s1, s2, false);
    }

    public static void assertSequenceListsEqual(List<SAMSequenceRecord> s1, List<SAMSequenceRecord> s2, boolean checkPrefixOnly) {
        if (s1 != null && s2 != null) {
            int sizeToTest;
            if (checkPrefixOnly) {
                sizeToTest = Math.min(s1.size(), s2.size());
                if (sizeToTest == 0) {
                    throw new SequenceListsDifferException("Neither of the dictionaries can be empty.");
                }
            } else {
                sizeToTest = s1.size();
                if (s1.size() != s2.size()) {
                    throw new SequenceListsDifferException("Sequence dictionaries are not the same size (" + s1.size() + ", " + s2.size() + ")");
                }
            }
            for (int i = 0; i < sizeToTest; ++i) {
                if (s1.get(i).isSameSequence(s2.get(i))) continue;
                StringBuilder s1Attrs = new StringBuilder();
                for (Map.Entry<String, String> entry : s1.get(i).getAttributes()) {
                    s1Attrs.append("/").append(entry.getKey()).append("=").append(entry.getValue());
                }
                Object s2Attrs = "";
                for (Map.Entry<String, String> entry : s2.get(i).getAttributes()) {
                    s2Attrs = (String)s2Attrs + "/" + entry.getKey() + "=" + entry.getValue();
                }
                throw new SequenceListsDifferException("Sequences at index " + i + " don't match: " + s1.get(i).getSequenceIndex() + "/" + s1.get(i).getSequenceLength() + "/" + s1.get(i).getSequenceName() + String.valueOf(s1Attrs) + " " + s2.get(i).getSequenceIndex() + "/" + s2.get(i).getSequenceLength() + "/" + s2.get(i).getSequenceName() + (String)s2Attrs);
            }
        }
    }

    public static boolean areSequenceDictionariesEqual(SAMSequenceDictionary s1, SAMSequenceDictionary s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        try {
            SequenceUtil.assertSequenceListsEqual(s1.getSequences(), s2.getSequences());
            return true;
        }
        catch (SequenceListsDifferException e) {
            return false;
        }
    }

    public static void assertSequenceDictionariesEqual(SAMSequenceDictionary s1, SAMSequenceDictionary s2) {
        SequenceUtil.assertSequenceDictionariesEqual(s1, s2, false);
    }

    public static void assertSequenceDictionariesEqual(SAMSequenceDictionary s1, SAMSequenceDictionary s2, boolean checkPrefixOnly) {
        if (s1 == null || s2 == null) {
            return;
        }
        SequenceUtil.assertSequenceListsEqual(s1.getSequences(), s2.getSequences(), checkPrefixOnly);
    }

    public static void assertSequenceDictionariesEqual(SAMSequenceDictionary s1, SAMSequenceDictionary s2, File f1, File f2) {
        try {
            SequenceUtil.assertSequenceDictionariesEqual(s1, s2);
        }
        catch (SequenceListsDifferException e) {
            throw new SequenceListsDifferException("In files " + f1.getAbsolutePath() + " and " + f2.getAbsolutePath(), e);
        }
    }

    public static String makeCigarStringWithPossibleClipping(int alignmentStart, int readLength, int referenceSequenceLength) {
        int matchLength;
        int start = alignmentStart;
        int leftSoftClip = 0;
        if (start < 1) {
            leftSoftClip = 1 - start;
            start = 1;
        }
        int rightSoftClip = 0;
        if (alignmentStart + readLength > referenceSequenceLength + 1) {
            rightSoftClip = alignmentStart + readLength - referenceSequenceLength - 1;
        }
        if ((matchLength = readLength - leftSoftClip - rightSoftClip) < 1) {
            throw new SAMException("Unexpected cigar string with no M op for read.");
        }
        return SequenceUtil.makeSoftClipCigar(leftSoftClip) + Integer.toString(matchLength) + "M" + SequenceUtil.makeSoftClipCigar(rightSoftClip);
    }

    public static String makeCigarStringWithIndelPossibleClipping(int alignmentStart, int readLength, int referenceSequenceLength, int indelPosition, int indelLength) {
        int start = alignmentStart;
        int leftSoftClip = 0;
        if (start < 1) {
            leftSoftClip = 1 - start;
            start = 1;
        }
        int rightSoftClip = 0;
        int alignmentEnd = alignmentStart + readLength - indelLength;
        if (alignmentEnd > referenceSequenceLength + 1) {
            rightSoftClip = alignmentEnd - referenceSequenceLength - 1;
        }
        if (leftSoftClip >= indelPosition) {
            throw new IllegalStateException("Soft clipping entire pre-indel match. leftSoftClip: " + leftSoftClip + "; indelPosition: " + indelPosition);
        }
        int firstMatchLength = indelPosition - leftSoftClip;
        int secondMatchLength = readLength - indelPosition - (indelLength > 0 ? indelLength : 0) - rightSoftClip;
        if (secondMatchLength < 1) {
            throw new SAMException("Unexpected cigar string with no M op for read.");
        }
        return SequenceUtil.makeSoftClipCigar(leftSoftClip) + Integer.toString(firstMatchLength) + "M" + Math.abs(indelLength) + (indelLength > 0 ? "I" : "D") + Integer.toString(secondMatchLength) + "M" + SequenceUtil.makeSoftClipCigar(rightSoftClip);
    }

    public static String makeSoftClipCigar(int clipLength) {
        if (clipLength == 0) {
            return "";
        }
        return Integer.toString(clipLength) + "S";
    }

    private static boolean basesMatch(byte readBase, byte refBase, boolean negativeStrand, boolean bisulfiteSequence, boolean matchAmbiguousRef) {
        if (bisulfiteSequence) {
            if (matchAmbiguousRef) {
                return SequenceUtil.bisulfiteBasesMatchWithAmbiguity(negativeStrand, readBase, refBase);
            }
            return SequenceUtil.bisulfiteBasesEqual(negativeStrand, readBase, refBase);
        }
        if (matchAmbiguousRef) {
            return SequenceUtil.readBaseMatchesRefBaseWithAmbiguity(readBase, refBase);
        }
        return SequenceUtil.basesEqual(readBase, refBase);
    }

    public static int countMismatches(SAMRecord read, byte[] referenceBases) {
        return SequenceUtil.countMismatches(read, referenceBases, 0, false);
    }

    public static int countMismatches(SAMRecord read, byte[] referenceBases, int referenceOffset) {
        return SequenceUtil.countMismatches(read, referenceBases, referenceOffset, false);
    }

    public static int countMismatches(SAMRecord read, byte[] referenceBases, int referenceOffset, boolean bisulfiteSequence) {
        return SequenceUtil.countMismatches(read, referenceBases, referenceOffset, bisulfiteSequence, false);
    }

    public static int countMismatches(SAMRecord read, byte[] referenceBases, int referenceOffset, boolean bisulfiteSequence, boolean matchAmbiguousRef) {
        try {
            int mismatches = 0;
            byte[] readBases = read.getReadBases();
            for (AlignmentBlock block : read.getAlignmentBlocks()) {
                int readBlockStart = block.getReadStart() - 1;
                int referenceBlockStart = block.getReferenceStart() - 1 - referenceOffset;
                int length = block.getLength();
                for (int i = 0; i < length; ++i) {
                    if (SequenceUtil.basesMatch(readBases[readBlockStart + i], referenceBases[referenceBlockStart + i], read.getReadNegativeStrandFlag(), bisulfiteSequence, matchAmbiguousRef)) continue;
                    ++mismatches;
                }
            }
            return mismatches;
        }
        catch (Exception e) {
            throw new SAMException("Exception counting mismatches for read " + String.valueOf(read), e);
        }
    }

    public static int countMismatches(SAMRecord read, byte[] referenceBases, boolean bisulfiteSequence) {
        return SequenceUtil.countMismatches(read, referenceBases, 0, bisulfiteSequence);
    }

    public static int sumQualitiesOfMismatches(SAMRecord read, byte[] referenceBases) {
        return SequenceUtil.sumQualitiesOfMismatches(read, referenceBases, 0, false);
    }

    public static int sumQualitiesOfMismatches(SAMRecord read, byte[] referenceBases, int referenceOffset) {
        return SequenceUtil.sumQualitiesOfMismatches(read, referenceBases, referenceOffset, false);
    }

    public static int sumQualitiesOfMismatches(SAMRecord read, byte[] referenceBases, int referenceOffset, boolean bisulfiteSequence) {
        int qualities = 0;
        byte[] readBases = read.getReadBases();
        byte[] readQualities = read.getBaseQualities();
        if (read.getAlignmentStart() <= referenceOffset) {
            throw new IllegalArgumentException("read.getAlignmentStart(" + read.getAlignmentStart() + ") <= referenceOffset(" + referenceOffset + ")");
        }
        for (AlignmentBlock block : read.getAlignmentBlocks()) {
            int readBlockStart = block.getReadStart() - 1;
            int referenceBlockStart = block.getReferenceStart() - 1 - referenceOffset;
            int length = block.getLength();
            for (int i = 0; i < length; ++i) {
                if (!bisulfiteSequence) {
                    if (SequenceUtil.basesEqual(readBases[readBlockStart + i], referenceBases[referenceBlockStart + i])) continue;
                    qualities += readQualities[readBlockStart + i];
                    continue;
                }
                if (SequenceUtil.bisulfiteBasesEqual(read.getReadNegativeStrandFlag(), readBases[readBlockStart + i], referenceBases[referenceBlockStart + i])) continue;
                qualities += readQualities[readBlockStart + i];
            }
        }
        return qualities;
    }

    public static int countInsertedBases(Cigar cigar) {
        int ret = 0;
        for (CigarElement element : cigar.getCigarElements()) {
            if (element.getOperator() != CigarOperator.INSERTION) continue;
            ret += element.getLength();
        }
        return ret;
    }

    public static int countDeletedBases(Cigar cigar) {
        int ret = 0;
        for (CigarElement element : cigar.getCigarElements()) {
            if (element.getOperator() != CigarOperator.DELETION) continue;
            ret += element.getLength();
        }
        return ret;
    }

    public static int countInsertedBases(SAMRecord read) {
        return SequenceUtil.countInsertedBases(read.getCigar());
    }

    public static int countDeletedBases(SAMRecord read) {
        return SequenceUtil.countDeletedBases(read.getCigar());
    }

    public static int calculateSamNmTag(SAMRecord read, byte[] referenceBases) {
        return SequenceUtil.calculateSamNmTag(read, referenceBases, 0, false);
    }

    public static int calculateSamNmTag(SAMRecord read, byte[] referenceBases, int referenceOffset) {
        return SequenceUtil.calculateSamNmTag(read, referenceBases, referenceOffset, false);
    }

    public static int calculateSamNmTag(SAMRecord read, byte[] referenceBases, int referenceOffset, boolean bisulfiteSequence) {
        int samNm = SequenceUtil.countMismatches(read, referenceBases, referenceOffset, bisulfiteSequence, false);
        for (CigarElement el : read.getCigar().getCigarElements()) {
            if (el.getOperator() != CigarOperator.INSERTION && el.getOperator() != CigarOperator.DELETION) continue;
            samNm += el.getLength();
        }
        return samNm;
    }

    public static int calculateSamNmTagFromCigar(SAMRecord record) {
        int samNm = 0;
        for (CigarElement el : record.getCigar().getCigarElements()) {
            if (el.getOperator() != CigarOperator.X && el.getOperator() != CigarOperator.INSERTION && el.getOperator() != CigarOperator.DELETION) continue;
            samNm += el.getLength();
        }
        return samNm;
    }

    public static byte complement(byte b) {
        switch (b) {
            case 97: {
                return 116;
            }
            case 99: {
                return 103;
            }
            case 103: {
                return 99;
            }
            case 116: {
                return 97;
            }
            case 65: {
                return 84;
            }
            case 67: {
                return 71;
            }
            case 71: {
                return 67;
            }
            case 84: {
                return 65;
            }
        }
        return b;
    }

    public static boolean bisulfiteBasesEqual(boolean negativeStrand, byte read, byte reference) {
        return SequenceUtil.basesEqual(read, reference) || SequenceUtil.isBisulfiteConverted(read, reference, negativeStrand);
    }

    public static boolean bisulfiteBasesEqual(byte read, byte reference) {
        return SequenceUtil.bisulfiteBasesEqual(false, read, reference);
    }

    public static boolean bisulfiteBasesMatchWithAmbiguity(boolean negativeStrand, byte read, byte reference) {
        return SequenceUtil.readBaseMatchesRefBaseWithAmbiguity(read, reference) || SequenceUtil.isBisulfiteConverted(read, reference, negativeStrand);
    }

    public static boolean isBisulfiteConverted(byte read, byte reference, boolean negativeStrand) {
        return negativeStrand ? SequenceUtil.basesEqual(reference, (byte)71) && SequenceUtil.basesEqual(read, (byte)65) : SequenceUtil.basesEqual(reference, (byte)67) && SequenceUtil.basesEqual(read, (byte)84);
    }

    public static boolean isBisulfiteConverted(byte read, byte reference) {
        return SequenceUtil.isBisulfiteConverted(read, reference, false);
    }

    public static byte[] makeReferenceFromAlignment(SAMRecord rec, boolean includeReferenceBasesForDeletions) {
        String md = rec.getStringAttribute(SAMTag.MD);
        if (md == null) {
            throw new SAMException("Cannot create reference from SAMRecord with no MD tag, read: " + rec.getReadName());
        }
        int maxOutputLength = 0;
        Cigar cigar = rec.getCigar();
        if (cigar == null) {
            throw new SAMException("Cannot create reference from SAMRecord with no CIGAR, read: " + rec.getReadName());
        }
        for (CigarElement cigarElement : cigar.getCigarElements()) {
            maxOutputLength += cigarElement.getLength();
        }
        byte[] ret = new byte[maxOutputLength];
        int outIndex = 0;
        Matcher match = mdPat.matcher(md);
        int curSeqPos = 0;
        int savedBases = 0;
        byte[] seq = rec.getReadBases();
        for (CigarElement cigEl : cigar.getCigarElements()) {
            int i;
            int cigElLen = cigEl.getLength();
            CigarOperator cigElOp = cigEl.getOperator();
            if (cigElOp == CigarOperator.SKIPPED_REGION) {
                if (!includeReferenceBasesForDeletions) continue;
                for (i = 0; i < cigElLen; ++i) {
                    ret[outIndex++] = 78;
                }
                continue;
            }
            if (cigElOp.consumesReferenceBases()) {
                int basesMatched;
                for (basesMatched = 0; savedBases > 0 && basesMatched < cigElLen; --savedBases, ++basesMatched) {
                    ret[outIndex++] = seq[curSeqPos++];
                }
                while (basesMatched < cigElLen) {
                    boolean matched = match.find();
                    if (matched) {
                        String mg = match.group(1);
                        if (mg != null && !mg.isEmpty()) {
                            int num = Integer.parseInt(mg);
                            for (int i2 = 0; i2 < num; ++i2) {
                                if (basesMatched < cigElLen) {
                                    ret[outIndex++] = seq[curSeqPos++];
                                } else {
                                    ++savedBases;
                                }
                                ++basesMatched;
                            }
                        } else {
                            mg = match.group(2);
                            if (mg != null && !mg.isEmpty()) {
                                if (basesMatched < cigElLen) {
                                    ret[outIndex++] = StringUtil.charToByte(mg.charAt(0));
                                    ++curSeqPos;
                                } else {
                                    throw new IllegalStateException("Should never happen.");
                                }
                                ++basesMatched;
                            } else {
                                mg = match.group(3);
                                if (mg != null && !mg.isEmpty()) {
                                    if (includeReferenceBasesForDeletions) {
                                        byte[] deletedBases = StringUtil.stringToBytes(mg);
                                        System.arraycopy(deletedBases, 1, ret, outIndex, deletedBases.length - 1);
                                        outIndex += deletedBases.length - 1;
                                    }
                                    if ((basesMatched += mg.length() - 1) != cigElLen) {
                                        throw new SAMException("Got a deletion in CIGAR (" + String.valueOf(cigar) + ", deletion " + cigElLen + " length) with an unequal ref insertion in MD (" + md + ", md " + basesMatched + " length");
                                    }
                                    if (cigElOp != CigarOperator.DELETION) {
                                        throw new SAMException("Got an insertion in MD (" + md + ") without a corresponding deletion in cigar (" + String.valueOf(cigar) + ")");
                                    }
                                } else {
                                    matched = false;
                                }
                            }
                        }
                    }
                    if (matched) continue;
                    throw new SAMException("Illegal MD pattern: " + md + " for read " + rec.getReadName() + " with CIGAR " + rec.getCigarString());
                }
                continue;
            }
            if (!cigElOp.consumesReadBases()) continue;
            for (i = 0; i < cigElLen; ++i) {
                char c = cigElOp == CigarOperator.SOFT_CLIP ? (char)'0' : '-';
                ret[outIndex++] = StringUtil.charToByte(c);
                ++curSeqPos;
            }
        }
        if (outIndex < ret.length) {
            byte[] shorter = new byte[outIndex];
            System.arraycopy(ret, 0, shorter, 0, outIndex);
            return shorter;
        }
        return ret;
    }

    public static void reverseComplement(byte[] bases) {
        SequenceUtil.reverseComplement(bases, 0, bases.length);
    }

    public static void reverseQualities(byte[] quals) {
        SequenceUtil.reverse(quals, 0, quals.length);
    }

    public static void reverse(byte[] array, int offset, int len) {
        int lastIndex = len - 1;
        int i = offset;
        for (int j = offset + lastIndex; i < j; ++i, --j) {
            byte tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
        }
        if (len % 2 == 1) {
            array[i] = array[i];
        }
    }

    public static void reverseComplement(byte[] bases, int offset, int len) {
        int lastIndex = len - 1;
        int i = offset;
        for (int j = offset + lastIndex; i < j; ++i, --j) {
            byte tmp = SequenceUtil.complement(bases[i]);
            bases[i] = SequenceUtil.complement(bases[j]);
            bases[j] = tmp;
        }
        if (len % 2 == 1) {
            bases[i] = SequenceUtil.complement(bases[i]);
        }
    }

    public static String calculateMD5String(byte[] data) {
        return SequenceUtil.calculateMD5String(data, 0, data.length);
    }

    public static String calculateMD5String(byte[] data, int offset, int len) {
        byte[] digest = SequenceUtil.calculateMD5(data, offset, len);
        return SequenceUtil.md5DigestToString(digest);
    }

    public static String md5DigestToString(byte[] digest) {
        return String.format(Locale.US, "%032x", new BigInteger(1, digest));
    }

    public static byte[] calculateMD5(byte[] data, int offset, int len) {
        try {
            MessageDigest md5_MessageDigest = MessageDigest.getInstance("MD5");
            md5_MessageDigest.reset();
            md5_MessageDigest.update(data, offset, len);
            return md5_MessageDigest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static void calculateMdAndNmTags(SAMRecord record, byte[] ref, boolean calcMD, boolean calcNM) {
        if (!calcMD && !calcNM) {
            return;
        }
        Cigar cigar = record.getCigar();
        List<CigarElement> cigarElements = cigar.getCigarElements();
        byte[] seq = record.getReadBases();
        int alignmentStart = record.getAlignmentStart() - 1;
        int matchCount = 0;
        int nmCount = 0;
        StringBuilder mdString = new StringBuilder();
        int nElements = cigarElements.size();
        int blockReadStart = 0;
        int blockRefPos = alignmentStart;
        for (int cigarIndex = 0; cigarIndex < nElements; ++cigarIndex) {
            int inBlockOffset;
            CigarElement ce = cigarElements.get(cigarIndex);
            int blockLength = ce.getLength();
            CigarOperator op = ce.getOperator();
            if (op == CigarOperator.MATCH_OR_MISMATCH || op == CigarOperator.EQ || op == CigarOperator.X) {
                for (inBlockOffset = 0; inBlockOffset < blockLength; ++inBlockOffset) {
                    int readOffset = blockReadStart + inBlockOffset;
                    if (ref.length <= blockRefPos + inBlockOffset) break;
                    byte readBase = seq[readOffset];
                    byte refBase = ref[blockRefPos + inBlockOffset];
                    if (bases[readBase] == bases[refBase] || readBase == 0) {
                        ++matchCount;
                        continue;
                    }
                    mdString.append(matchCount);
                    mdString.appendCodePoint(refBase);
                    matchCount = 0;
                    ++nmCount;
                }
                if (inBlockOffset < blockLength) break;
                blockRefPos += blockLength;
                blockReadStart += blockLength;
                continue;
            }
            if (op == CigarOperator.DELETION) {
                mdString.append(matchCount);
                mdString.append('^');
                for (inBlockOffset = 0; inBlockOffset < blockLength && ref[blockRefPos + inBlockOffset] != 0; ++inBlockOffset) {
                    mdString.appendCodePoint(ref[blockRefPos + inBlockOffset]);
                }
                matchCount = 0;
                if (inBlockOffset < blockLength) break;
                blockRefPos += blockLength;
                nmCount += blockLength;
                continue;
            }
            if (op == CigarOperator.INSERTION || op == CigarOperator.SOFT_CLIP) {
                blockReadStart += blockLength;
                if (op != CigarOperator.INSERTION) continue;
                nmCount += blockLength;
                continue;
            }
            if (op != CigarOperator.SKIPPED_REGION) continue;
            blockRefPos += blockLength;
        }
        mdString.append(matchCount);
        if (calcMD) {
            record.setAttribute(SAMTag.MD, (Object)mdString.toString());
        }
        if (calcNM) {
            record.setAttribute(SAMTag.NM, (Object)nmCount);
        }
    }

    public static byte upperCase(byte base) {
        return base >= 97 ? (byte)(base - 32) : base;
    }

    public static byte[] upperCase(byte[] bases) {
        for (int i = 0; i < bases.length; ++i) {
            bases[i] = SequenceUtil.upperCase(bases[i]);
        }
        return bases;
    }

    public static List<byte[]> generateAllKmers(int length) {
        LinkedList<byte[]> sofar = new LinkedList<byte[]>();
        if (sofar.isEmpty()) {
            sofar.add(new byte[length]);
        }
        block0: while (true) {
            byte[] bs = (byte[])sofar.remove(0);
            int indexOfNextBase = -1;
            for (int i = 0; i < bs.length; ++i) {
                if (bs[i] != 0) continue;
                indexOfNextBase = i;
                break;
            }
            if (indexOfNextBase == -1) {
                sofar.add(bs);
                break;
            }
            byte[] byArray = VALID_BASES_UPPER;
            int n = byArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block0;
                byte b = byArray[n2];
                byte[] next = Arrays.copyOf(bs, bs.length);
                next[indexOfNextBase] = b;
                sofar.add(next);
                ++n2;
            }
            break;
        }
        return sofar;
    }

    public static String getSamReadNameFromFastqHeader(String fastqHeader) {
        String readName;
        int idx = fastqHeader.indexOf(" ");
        String string = readName = idx == -1 ? fastqHeader : fastqHeader.substring(0, idx);
        while (readName.endsWith("/1") || readName.endsWith("/2")) {
            readName = readName.substring(0, readName.length() - 2);
        }
        return readName;
    }

    public static byte[] getRandomBases(Random random, int length) {
        ValidationUtils.validateArg(length >= 0, "length must be non-negative");
        byte[] bases = new byte[length];
        SequenceUtil.getRandomBases(random, length, bases);
        return bases;
    }

    public static void getRandomBases(Random random, int length, byte[] bases) {
        ValidationUtils.validateArg(length >= 0, "length must be non-negative");
        ValidationUtils.validateArg(length <= bases.length, "length must no larger than size of input array");
        for (int i = 0; i < length; ++i) {
            bases[i] = VALID_BASES_UPPER[random.nextInt(VALID_BASES_UPPER.length)];
        }
    }

    static {
        Arrays.fill(bamReadBaseLookup, (byte)78);
        byte[] byArray = BAM_READ_BASE_SET;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte base;
            SequenceUtil.bamReadBaseLookup[base] = base = byArray[i];
            SequenceUtil.bamReadBaseLookup[base + 32] = base;
        }
        bases = new byte[127];
        Arrays.fill(bases, (byte)0);
        SequenceUtil.bases[65] = 1;
        SequenceUtil.bases[67] = 2;
        SequenceUtil.bases[71] = 4;
        SequenceUtil.bases[84] = 8;
        SequenceUtil.bases[77] = 3;
        SequenceUtil.bases[82] = 5;
        SequenceUtil.bases[87] = 9;
        SequenceUtil.bases[83] = 6;
        SequenceUtil.bases[89] = 10;
        SequenceUtil.bases[75] = 12;
        SequenceUtil.bases[86] = 7;
        SequenceUtil.bases[72] = 11;
        SequenceUtil.bases[68] = 13;
        SequenceUtil.bases[66] = 14;
        SequenceUtil.bases[78] = 15;
        for (int i = 65; i <= 90; ++i) {
            SequenceUtil.bases[(byte)i + 32] = bases[(byte)i];
        }
        SequenceUtil.bases[46] = 15;
        mdPat = Pattern.compile("\\G(?:([0-9]+)|([ACTGNactgn])|(\\^[ACTGNactgn]+))");
    }

    public static class SequenceListsDifferException
    extends SAMException {
        public SequenceListsDifferException() {
        }

        public SequenceListsDifferException(String s) {
            super(s);
        }

        public SequenceListsDifferException(String s, Throwable throwable) {
            super(s, throwable);
        }

        public SequenceListsDifferException(Throwable throwable) {
            super(throwable);
        }
    }
}

