/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.AbstractBAMFileIndex;
import htsjdk.samtools.BAMFileConstants;
import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.BAMIndexContent;
import htsjdk.samtools.BAMIndexMetaData;
import htsjdk.samtools.Bin;
import htsjdk.samtools.BinList;
import htsjdk.samtools.BinWithOffset;
import htsjdk.samtools.BrowseableBAMIndex;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.GenomicIndexUtil;
import htsjdk.samtools.IndexFileBuffer;
import htsjdk.samtools.IndexFileBufferFactory;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.seekablestream.SeekablePathStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;

public class CSIIndex
extends AbstractBAMFileIndex
implements BrowseableBAMIndex {
    private int binDepth;
    private int minShift;
    private int maxBins;
    private int maxSpan;
    private byte[] auxData;
    private int nReferences;
    private long metaDataPos;

    public CSIIndex(SeekableStream stream, SAMSequenceDictionary dictionary) {
        this(IndexFileBufferFactory.getBuffer(stream), stream.getSource(), dictionary);
    }

    public CSIIndex(Path path, SAMSequenceDictionary dictionary) throws IOException {
        this(new SeekablePathStream(path), dictionary);
    }

    public CSIIndex(File file, boolean enableMemoryMapping, SAMSequenceDictionary dictionary) {
        this(IndexFileBufferFactory.getBuffer(file, enableMemoryMapping), file.getName(), dictionary);
    }

    private CSIIndex(IndexFileBuffer indexFileBuffer, String source, SAMSequenceDictionary dictionary) {
        super(indexFileBuffer, source, dictionary);
    }

    public int getBinDepth() {
        return this.binDepth;
    }

    private void setBinDepth(int binDepth) {
        this.binDepth = binDepth;
    }

    public int getMinShift() {
        return this.minShift;
    }

    private void setMinShift(int minShift) {
        this.minShift = minShift;
    }

    public int getMaxBins() {
        return this.maxBins;
    }

    private void setMaxBins(int binDepth) {
        this.maxBins = ((1 << 3 * binDepth) - 1) / 7;
    }

    public int getMaxSpan() {
        return this.maxSpan;
    }

    private void setMaxSpan(int binDepth, int minShift) {
        this.maxSpan = 1 << minShift + 3 * (binDepth - 1);
    }

    public byte[] getAuxData() {
        return this.auxData;
    }

    private void setAuxData(byte[] auxData) {
        this.auxData = auxData;
    }

    @Override
    public int getNumberOfReferences() {
        return this.nReferences;
    }

    private void setNumberOfReferences(int nReferences) {
        this.nReferences = nReferences;
    }

    @Override
    public int getLevelSize(int levelNumber) {
        if (levelNumber >= this.getBinDepth()) {
            throw new SAMException("Level number (" + levelNumber + ") is greater than or equal to maximum (" + this.getBinDepth() + ").");
        }
        return 1 << 3 * levelNumber;
    }

    public int getFirstBinInLevelForCSI(int levelNumber) {
        if (levelNumber >= this.getBinDepth()) {
            throw new SAMException("Level number (" + levelNumber + ") is greater than or equal to maximum (" + this.getBinDepth() + ").");
        }
        return ((1 << 3 * levelNumber) - 1) / 7;
    }

    @Override
    public int getLevelForBin(Bin bin) {
        if (bin == null || bin.getBinNumber() > this.getMaxBins()) {
            throw new SAMException("Tried to get level for invalid bin: " + String.valueOf(bin));
        }
        for (int i = this.getBinDepth() - 1; i > -1; --i) {
            if (bin.getBinNumber() < this.getFirstBinInLevelForCSI(i)) continue;
            return i;
        }
        throw new SAMException("Unable to find correct level for bin: " + String.valueOf(bin));
    }

    @Override
    public int getFirstLocusInBin(Bin bin) {
        if (bin == null || bin.getBinNumber() > this.getMaxBins()) {
            throw new SAMException("Tried to get first locus for invalid bin: " + String.valueOf(bin));
        }
        int level = this.getLevelForBin(bin);
        int firstBinOnLevel = this.getFirstBinInLevelForCSI(level);
        int levelSize = this.getLevelSize(level);
        return (bin.getBinNumber() - firstBinOnLevel) * (this.getMaxSpan() / levelSize) + 1;
    }

    @Override
    public int getLastLocusInBin(Bin bin) {
        if (bin == null || bin.getBinNumber() > this.getMaxBins()) {
            throw new SAMException("Tried to get last locus for invalid bin: " + String.valueOf(bin));
        }
        int level = this.getLevelForBin(bin);
        int firstBinOnLevel = this.getFirstBinInLevelForCSI(level);
        int levelSize = this.getLevelSize(level);
        return (bin.getBinNumber() - firstBinOnLevel + 1) * (this.getMaxSpan() / levelSize);
    }

    @Override
    public BinList getBinsOverlapping(int referenceIndex, int startPos, int endPos) {
        BitSet regionBins = GenomicIndexUtil.regionToBins(startPos, endPos, this.getMinShift(), this.getBinDepth());
        if (regionBins == null) {
            return null;
        }
        return new BinList(referenceIndex, regionBins);
    }

    @Override
    public BAMFileSpan getSpanOverlapping(int referenceIndex, int startPos, int endPos) {
        Bin targetBin;
        BAMIndexContent queryResults = this.query(referenceIndex, startPos, endPos);
        int initialBinNumber = this.getFirstBinInLevelForCSI(this.getBinDepth() - 1) + (startPos - 1 >> this.getMinShift());
        long minimumOffset = 0L;
        if (queryResults == null) {
            return null;
        }
        while ((targetBin = queryResults.getBins().getBin(initialBinNumber)) == null) {
            int firstBinNumber = (this.getParentBinNumber(initialBinNumber) << 3) + 1;
            initialBinNumber = initialBinNumber > firstBinNumber ? --initialBinNumber : this.getParentBinNumber(initialBinNumber);
            if (initialBinNumber != 0) continue;
        }
        if (initialBinNumber == 0) {
            targetBin = queryResults.getBins().getBin(initialBinNumber);
        }
        if (targetBin != null && targetBin instanceof BinWithOffset) {
            minimumOffset = ((BinWithOffset)targetBin).getlOffset();
        }
        List<Chunk> chunkList = new ArrayList<Chunk>();
        for (Chunk chunk : queryResults.getAllChunks()) {
            chunkList.add(chunk.clone());
        }
        chunkList = Chunk.optimizeChunkList(chunkList, minimumOffset);
        return new BAMFileSpan(chunkList);
    }

    @Override
    public BAMFileSpan getSpanOverlapping(Bin bin) {
        if (bin == null) {
            return null;
        }
        int referenceSequence = bin.getReferenceSequence();
        BAMIndexContent queryResults = this.getQueryResults(referenceSequence);
        if (queryResults == null) {
            return null;
        }
        int binLevel = this.getLevelForBin(bin);
        int firstLocusInBin = this.getFirstLocusInBin(bin);
        long minimumOffset = bin instanceof BinWithOffset ? ((BinWithOffset)bin).getlOffset() : 0L;
        ArrayList<Bin> binTree = new ArrayList<Bin>();
        if (queryResults.containsBin(bin)) {
            binTree.add(queryResults.getBins().getBin(bin.getBinNumber()));
        }
        int currentBinLevel = binLevel;
        while (--currentBinLevel >= 0) {
            int binStart = this.getFirstBinInLevelForCSI(currentBinLevel);
            int binWidth = this.getMaxSpan() / this.getLevelSize(currentBinLevel);
            int parentBinNumber = firstLocusInBin / binWidth + binStart;
            Bin parentBin = queryResults.getBins().getBin(parentBinNumber);
            if (parentBin == null || !queryResults.containsBin(parentBin)) continue;
            binTree.add(parentBin);
        }
        List<Chunk> chunkList = new ArrayList<Chunk>();
        for (Bin coveringBin : binTree) {
            for (Chunk chunk : coveringBin.getChunkList()) {
                chunkList.add(chunk.clone());
            }
        }
        chunkList = Chunk.optimizeChunkList(chunkList, minimumOffset);
        return new BAMFileSpan(chunkList);
    }

    @Override
    public long getStartOfLastLinearBin() {
        if (this.metaDataPos > 0L && this.position() != this.metaDataPos) {
            this.seek(this.metaDataPos);
        }
        int sequenceIndex = this.getNumberOfReferences();
        long loffset = -1L;
        for (int i = 0; i < sequenceIndex; ++i) {
            int nBins = this.readInteger();
            for (int j = 0; j < nBins; ++j) {
                this.readInteger();
                loffset = this.readLong();
                int nChunks = this.readInteger();
                this.skipBytes(16 * nChunks);
            }
        }
        return loffset;
    }

    @Override
    protected void verifyIndexMagicNumber(String sourceName) {
        if (0L != this.position()) {
            this.seek(0L);
        }
        byte[] buffer = new byte[4];
        this.readBytes(buffer);
        if (!Arrays.equals(buffer, BAMFileConstants.CSI_INDEX_MAGIC)) {
            throw new RuntimeIOException("Invalid file header in BAM CSI index " + sourceName + ": " + new String(buffer));
        }
    }

    private void readMinShiftAndBinDepth() {
        if (4L != this.position()) {
            this.seek(4L);
        }
        this.setMinShift(this.readInteger());
        this.setBinDepth(this.readInteger() + 1);
        this.setMaxBins(this.binDepth);
        this.setMaxSpan(this.binDepth, this.minShift);
    }

    private void readAuxDataAndNRef() {
        if (12L != this.position()) {
            this.seek(12L);
        }
        byte[] auxData = new byte[this.readInteger()];
        this.readBytes(auxData);
        this.setAuxData(auxData);
        this.setNumberOfReferences(this.readInteger());
        this.metaDataPos = this.position();
    }

    @Override
    protected final void initParameters() {
        this.readMinShiftAndBinDepth();
        this.readAuxDataAndNRef();
        this.setSequenceIndexes(this.getNumberOfReferences());
    }

    public int getParentBinNumber(int binNumber) {
        if (binNumber >= this.getMaxBins()) {
            throw new SAMException("Tried to get parent bin for invalid bin (" + binNumber + ").");
        }
        if (binNumber == 0) {
            return 0;
        }
        return binNumber - 1 >> 3;
    }

    public int getParentBinNumber(Bin bin) {
        if (bin == null) {
            throw new SAMException("Tried to get parent bin for null bin.");
        }
        return this.getParentBinNumber(bin.getBinNumber());
    }

    private int getMaxBinNumberForReference(int reference) {
        try {
            int sequenceLength = this.getBamDictionary().getSequence(reference).getSequenceLength();
            return this.getFirstBinInLevelForCSI(this.getBinDepth() - 1) + (sequenceLength >> this.getMinShift());
        }
        catch (Exception e) {
            return this.getMaxBins();
        }
    }

    @Override
    protected BAMIndexContent query(int referenceSequence, int startPos, int endPos) {
        if (this.metaDataPos > 0L && this.position() != this.metaDataPos) {
            this.seek(this.metaDataPos);
        }
        ArrayList<Chunk> metaDataChunks = new ArrayList<Chunk>();
        int sequenceCount = this.getNumberOfReferences();
        if (referenceSequence >= sequenceCount) {
            return null;
        }
        BitSet regionBins = GenomicIndexUtil.regionToBins(startPos, endPos, this.getMinShift(), this.getBinDepth());
        if (regionBins == null) {
            return null;
        }
        this.skipToSequence(referenceSequence);
        int binCount = this.readInteger();
        boolean metaDataSeen = false;
        Bin[] bins = new BinWithOffset[this.getMaxBinNumberForReference(referenceSequence) + 1];
        for (int binNumber = 0; binNumber < binCount; ++binNumber) {
            List<Chunk> chunks;
            int indexBin = this.readInteger();
            long lOffset = this.readLong();
            int nChunks = this.readInteger();
            Chunk lastChunk = null;
            if (regionBins.get(indexBin)) {
                chunks = new ArrayList<Chunk>(nChunks);
                this.readChunks(nChunks, chunks);
            } else {
                if (indexBin == this.getMaxBins() + 1) {
                    this.readChunks(nChunks, metaDataChunks);
                    metaDataSeen = true;
                    continue;
                }
                this.skipBytes(16 * nChunks);
                chunks = Collections.emptyList();
            }
            BinWithOffset bin = new BinWithOffset(referenceSequence, indexBin, lOffset);
            bin.setChunkList(chunks);
            bin.setLastChunk(lastChunk);
            bins[indexBin] = bin;
        }
        return new BAMIndexContent(referenceSequence, bins, binCount - (metaDataSeen ? 1 : 0), new BAMIndexMetaData(metaDataChunks), null);
    }

    @Override
    public BAMIndexMetaData getMetaData(int reference) {
        if (this.metaDataPos > 0L && this.position() != this.metaDataPos) {
            this.seek(this.metaDataPos);
        }
        ArrayList<Chunk> metaDataChunks = new ArrayList<Chunk>();
        int sequenceCount = this.getNumberOfReferences();
        if (reference >= sequenceCount) {
            return null;
        }
        this.skipToSequence(reference);
        int binCount = this.readInteger();
        for (int binNumber = 0; binNumber < binCount; ++binNumber) {
            int indexBin = this.readInteger();
            long lOffset = this.readLong();
            int nChunks = this.readInteger();
            if (indexBin == this.getMaxBins() + 1) {
                this.readChunks(nChunks, metaDataChunks);
                continue;
            }
            this.skipBytes(16 * nChunks);
        }
        return new BAMIndexMetaData(metaDataChunks);
    }

    @Override
    public Long getNoCoordinateCount() {
        if (this.metaDataPos > 0L && this.position() != this.metaDataPos) {
            this.seek(this.metaDataPos);
        }
        this.skipToSequence(this.getNumberOfReferences());
        try {
            return this.readLong();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public BAMIndexContent getQueryResults(int referenceSequence) {
        return this.query(referenceSequence, 1, -1);
    }

    @Override
    protected void skipToSequence(int sequenceIndex) {
        if (sequenceIndex > this.getNumberOfReferences()) {
            throw new SAMException("Sequence index (" + sequenceIndex + ") is greater than maximum (" + this.getNumberOfReferences() + ").");
        }
        if (this.sequenceIndexes[sequenceIndex] != -1L) {
            this.seek(this.sequenceIndexes[sequenceIndex]);
            return;
        }
        if (this.metaDataPos > 0L && this.position() != this.metaDataPos) {
            this.seek(this.metaDataPos);
        }
        for (int i = 0; i < sequenceIndex; ++i) {
            int nBins = this.readInteger();
            for (int j = 0; j < nBins; ++j) {
                this.readInteger();
                this.readLong();
                int nChunks = this.readInteger();
                this.skipBytes(16 * nChunks);
            }
        }
        this.sequenceIndexes[sequenceIndex] = this.position();
    }
}

