/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.RecentUrlsSet;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.MenuAndToolbarUtils;
import org.broad.igv.util.ResourceLocator;

public class RecentUrlsMenu
extends JMenu {
    public RecentUrlsMenu() {
        this("Recent Files");
    }

    private RecentUrlsMenu(String name) {
        super(name);
        this.addMenuListener(e -> {
            RecentUrlsSet recentFileList = IGV.getInstance().getRecentUrls();
            if (recentFileList.isEmpty()) {
                this.setVisible(false);
            } else {
                this.setVisible(true);
                this.removeAll();
                for (ResourceLocator resourceLocator : recentFileList) {
                    JMenuItem menuItem = RecentUrlsMenu.createMenuItem(resourceLocator);
                    this.add(menuItem);
                }
                this.addSeparator();
                JMenuItem clearButton = MenuAndToolbarUtils.createMenuItem(new MenuAction("Clear Recent Files"){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        IGV.getInstance().getRecentUrls().clear();
                        RecentUrlsMenu.this.setVisible(false);
                    }
                });
                this.add(clearButton);
            }
        });
    }

    private static JMenuItem createMenuItem(final ResourceLocator resourceLocator) {
        MenuAction menuItemAction = new MenuAction(resourceLocator.getPath()){

            @Override
            public void actionPerformed(ActionEvent event) {
                IGV igv = IGV.getInstance();
                List<ResourceLocator> resource = List.of(resourceLocator);
                igv.loadTracks(resource);
                igv.addToRecentUrls(resource);
            }
        };
        String toolTipText = resourceLocator.getIndexPath() == null ? "Load track from " + resourceLocator.getPath() : "<html>Load track from <br>path:  " + resourceLocator.getPath() + "<br>index: " + resourceLocator.getIndexPath() + "</html>";
        menuItemAction.setToolTipText(toolTipText);
        return MenuAndToolbarUtils.createMenuItem(menuItemAction);
    }
}

